/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.login;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;
import net.raphimc.netminecraft.util.UUIDAdapter;

public class S2CLoginGameProfilePacket
implements Packet {
    public UUID uuid;
    public String name;
    public List<String[]> properties;
    public boolean strictErrorHandling;

    public S2CLoginGameProfilePacket() {
    }

    public S2CLoginGameProfilePacket(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public S2CLoginGameProfilePacket(UUID uuid, String name, List<String[]> properties) {
        this(uuid, name);
        this.properties = properties;
    }

    public S2CLoginGameProfilePacket(UUID uuid, String name, List<String[]> properties, boolean strictErrorHandling) {
        this(uuid, name, properties);
        this.strictErrorHandling = strictErrorHandling;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.uuid = protocolVersion <= 4 ? UUIDAdapter.fromString((String)PacketTypes.readString((ByteBuf)byteBuf, (int)36)) : (protocolVersion <= 578 ? UUID.fromString(PacketTypes.readString((ByteBuf)byteBuf, (int)36)) : this.uuidFromIntArray(new int[]{byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt()}));
        this.name = PacketTypes.readString((ByteBuf)byteBuf, (int)16);
        if (protocolVersion >= 759) {
            int count = PacketTypes.readVarInt((ByteBuf)byteBuf);
            this.properties = new ArrayList<String[]>();
            for (int i = 0; i < count; ++i) {
                String name = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
                String value = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
                String signature = null;
                if (byteBuf.readBoolean()) {
                    signature = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
                }
                this.properties.add(new String[]{name, value, signature});
            }
        }
        if (protocolVersion >= 766 && protocolVersion <= 767) {
            this.strictErrorHandling = byteBuf.readBoolean();
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        if (protocolVersion <= 4) {
            PacketTypes.writeString((ByteBuf)byteBuf, (String)(this.uuid == null ? "" : UUIDAdapter.fromUUID((UUID)this.uuid)));
        } else if (protocolVersion <= 578) {
            PacketTypes.writeString((ByteBuf)byteBuf, (String)(this.uuid == null ? "" : this.uuid.toString()));
        } else {
            for (int i : this.uuidToIntArray(this.uuid)) {
                byteBuf.writeInt(i);
            }
        }
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.name);
        if (protocolVersion >= 759) {
            PacketTypes.writeVarInt((ByteBuf)byteBuf, (int)this.properties.size());
            Object object = this.properties.iterator();
            while (object.hasNext()) {
                String[] property = (String[])object.next();
                PacketTypes.writeString((ByteBuf)byteBuf, (String)property[0]);
                PacketTypes.writeString((ByteBuf)byteBuf, (String)property[1]);
                byteBuf.writeBoolean(property[2] != null);
                if (property[2] == null) continue;
                PacketTypes.writeString((ByteBuf)byteBuf, (String)property[2]);
            }
        }
        if (protocolVersion >= 766 && protocolVersion <= 767) {
            byteBuf.writeBoolean(this.strictErrorHandling);
        }
    }

    protected UUID uuidFromIntArray(int[] ints) {
        return new UUID((long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL, (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL);
    }

    protected int[] uuidToIntArray(UUID uuid) {
        return this.bitsToIntArray(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    protected int[] bitsToIntArray(long long1, long long2) {
        return new int[]{(int)(long1 >> 32), (int)long1, (int)(long2 >> 32), (int)long2};
    }
}

