/*
 * Decompiled with CFR 0.152.
 */
package net.wesjd.anvilgui.version;

import net.wesjd.anvilgui.version.VersionWrapper;
import org.bukkit.Bukkit;

public class VersionMatcher {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionWrapper match() {
        String rVersion;
        String craftBukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
        if (!craftBukkitPackage.contains(".v")) {
            String[] versionNumbers = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
            int major = Integer.parseInt(versionNumbers[1]);
            int minor = Integer.parseInt(versionNumbers[2]);
            if (major != 20 || minor < 5) throw new IllegalStateException("AnvilGUI does not support bukkit server version \"" + Bukkit.getBukkitVersion() + "\"");
            rVersion = "1_20_R4";
        } else {
            rVersion = craftBukkitPackage.split("\\.")[3].substring(1);
        }
        try {
            return (VersionWrapper)Class.forName(this.getClass().getPackage().getName() + ".Wrapper" + rVersion).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("AnvilGUI does not support server version \"" + rVersion + "\"", exception);
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("Failed to instantiate version wrapper for version " + rVersion, exception);
        }
    }
}

