/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireReleaseVersion
extends AbstractNonCacheableEnforcerRule {
    public boolean failWhenParentIsSnapshot = true;

    public void execute(EnforcerRuleHelper theHelper) throws EnforcerRuleException {
        Artifact parentArtifact;
        MavenProject project = this.getProject(theHelper);
        if (project.getArtifact().isSnapshot()) {
            StringBuffer buf = new StringBuffer();
            if (this.message != null) {
                buf.append(this.message + "\n");
            }
            buf.append("This project cannot be a snapshot:" + project.getArtifact().getId());
            throw new EnforcerRuleException(buf.toString());
        }
        if (this.failWhenParentIsSnapshot && (parentArtifact = project.getParentArtifact()) != null && parentArtifact.isSnapshot()) {
            throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
        }
    }

    private MavenProject getProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
    }

    public boolean isFailWhenParentIsSnapshot() {
        return this.failWhenParentIsSnapshot;
    }

    public void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }
}

