/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quadrant;
import com.mojang.math.SymmetricGroup3;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.util.StringRepresentable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

public enum OctahedralGroup implements StringRepresentable
{
    IDENTITY("identity", SymmetricGroup3.P123, false, false, false),
    ROT_180_FACE_XY("rot_180_face_xy", SymmetricGroup3.P123, true, true, false),
    ROT_180_FACE_XZ("rot_180_face_xz", SymmetricGroup3.P123, true, false, true),
    ROT_180_FACE_YZ("rot_180_face_yz", SymmetricGroup3.P123, false, true, true),
    ROT_120_NNN("rot_120_nnn", SymmetricGroup3.P231, false, false, false),
    ROT_120_NNP("rot_120_nnp", SymmetricGroup3.P312, true, false, true),
    ROT_120_NPN("rot_120_npn", SymmetricGroup3.P312, false, true, true),
    ROT_120_NPP("rot_120_npp", SymmetricGroup3.P231, true, false, true),
    ROT_120_PNN("rot_120_pnn", SymmetricGroup3.P312, true, true, false),
    ROT_120_PNP("rot_120_pnp", SymmetricGroup3.P231, true, true, false),
    ROT_120_PPN("rot_120_ppn", SymmetricGroup3.P231, false, true, true),
    ROT_120_PPP("rot_120_ppp", SymmetricGroup3.P312, false, false, false),
    ROT_180_EDGE_XY_NEG("rot_180_edge_xy_neg", SymmetricGroup3.P213, true, true, true),
    ROT_180_EDGE_XY_POS("rot_180_edge_xy_pos", SymmetricGroup3.P213, false, false, true),
    ROT_180_EDGE_XZ_NEG("rot_180_edge_xz_neg", SymmetricGroup3.P321, true, true, true),
    ROT_180_EDGE_XZ_POS("rot_180_edge_xz_pos", SymmetricGroup3.P321, false, true, false),
    ROT_180_EDGE_YZ_NEG("rot_180_edge_yz_neg", SymmetricGroup3.P132, true, true, true),
    ROT_180_EDGE_YZ_POS("rot_180_edge_yz_pos", SymmetricGroup3.P132, true, false, false),
    ROT_90_X_NEG("rot_90_x_neg", SymmetricGroup3.P132, false, false, true),
    ROT_90_X_POS("rot_90_x_pos", SymmetricGroup3.P132, false, true, false),
    ROT_90_Y_NEG("rot_90_y_neg", SymmetricGroup3.P321, true, false, false),
    ROT_90_Y_POS("rot_90_y_pos", SymmetricGroup3.P321, false, false, true),
    ROT_90_Z_NEG("rot_90_z_neg", SymmetricGroup3.P213, false, true, false),
    ROT_90_Z_POS("rot_90_z_pos", SymmetricGroup3.P213, true, false, false),
    INVERSION("inversion", SymmetricGroup3.P123, true, true, true),
    INVERT_X("invert_x", SymmetricGroup3.P123, true, false, false),
    INVERT_Y("invert_y", SymmetricGroup3.P123, false, true, false),
    INVERT_Z("invert_z", SymmetricGroup3.P123, false, false, true),
    ROT_60_REF_NNN("rot_60_ref_nnn", SymmetricGroup3.P312, true, true, true),
    ROT_60_REF_NNP("rot_60_ref_nnp", SymmetricGroup3.P231, true, false, false),
    ROT_60_REF_NPN("rot_60_ref_npn", SymmetricGroup3.P231, false, false, true),
    ROT_60_REF_NPP("rot_60_ref_npp", SymmetricGroup3.P312, false, false, true),
    ROT_60_REF_PNN("rot_60_ref_pnn", SymmetricGroup3.P231, false, true, false),
    ROT_60_REF_PNP("rot_60_ref_pnp", SymmetricGroup3.P312, true, false, false),
    ROT_60_REF_PPN("rot_60_ref_ppn", SymmetricGroup3.P312, false, true, false),
    ROT_60_REF_PPP("rot_60_ref_ppp", SymmetricGroup3.P231, true, true, true),
    SWAP_XY("swap_xy", SymmetricGroup3.P213, false, false, false),
    SWAP_YZ("swap_yz", SymmetricGroup3.P132, false, false, false),
    SWAP_XZ("swap_xz", SymmetricGroup3.P321, false, false, false),
    SWAP_NEG_XY("swap_neg_xy", SymmetricGroup3.P213, true, true, false),
    SWAP_NEG_YZ("swap_neg_yz", SymmetricGroup3.P132, false, true, true),
    SWAP_NEG_XZ("swap_neg_xz", SymmetricGroup3.P321, true, false, true),
    ROT_90_REF_X_NEG("rot_90_ref_x_neg", SymmetricGroup3.P132, true, false, true),
    ROT_90_REF_X_POS("rot_90_ref_x_pos", SymmetricGroup3.P132, true, true, false),
    ROT_90_REF_Y_NEG("rot_90_ref_y_neg", SymmetricGroup3.P321, true, true, false),
    ROT_90_REF_Y_POS("rot_90_ref_y_pos", SymmetricGroup3.P321, false, true, true),
    ROT_90_REF_Z_NEG("rot_90_ref_z_neg", SymmetricGroup3.P213, false, true, true),
    ROT_90_REF_Z_POS("rot_90_ref_z_pos", SymmetricGroup3.P213, true, false, true);

    private static final Direction.Axis[] AXES;
    private final Matrix3fc transformation;
    private final String name;
    @Nullable
    private Map<Direction, Direction> rotatedDirections;
    private final boolean invertX;
    private final boolean invertY;
    private final boolean invertZ;
    private final SymmetricGroup3 permutation;
    private static final OctahedralGroup[][] CAYLEY_TABLE;
    private static final OctahedralGroup[] INVERSE_TABLE;
    private static final OctahedralGroup[][] XY_TABLE;

    private OctahedralGroup(String var2, SymmetricGroup3 var3, boolean var4, boolean var5, boolean var6) {
        this.name = var2;
        this.invertX = var4;
        this.invertY = var5;
        this.invertZ = var6;
        this.permutation = var3;
        Matrix3f var7 = new Matrix3f().scaling(var4 ? -1.0f : 1.0f, var5 ? -1.0f : 1.0f, var6 ? -1.0f : 1.0f);
        var7.mul(var3.transformation());
        this.transformation = var7;
    }

    private BooleanList packInversions() {
        return new BooleanArrayList(new boolean[]{this.invertX, this.invertY, this.invertZ});
    }

    public OctahedralGroup compose(OctahedralGroup var0) {
        return CAYLEY_TABLE[this.ordinal()][var0.ordinal()];
    }

    public OctahedralGroup inverse() {
        return INVERSE_TABLE[this.ordinal()];
    }

    public Matrix3fc transformation() {
        return this.transformation;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public Direction rotate(Direction var02) {
        if (this.rotatedDirections == null) {
            this.rotatedDirections = Util.makeEnumMap(Direction.class, var0 -> {
                Direction.Axis var1 = var0.getAxis();
                Direction.AxisDirection var2 = var0.getAxisDirection();
                Direction.Axis var3 = this.permute(var1);
                Direction.AxisDirection var4 = this.inverts(var3) ? var2.opposite() : var2;
                return Direction.fromAxisAndDirection(var3, var4);
            });
        }
        return this.rotatedDirections.get(var02);
    }

    public boolean inverts(Direction.Axis var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> this.invertX;
            case Direction.Axis.Y -> this.invertY;
            case Direction.Axis.Z -> this.invertZ;
        };
    }

    public Direction.Axis permute(Direction.Axis var0) {
        return AXES[this.permutation.permutation(var0.ordinal())];
    }

    public FrontAndTop rotate(FrontAndTop var0) {
        return FrontAndTop.fromFrontAndTop(this.rotate(var0.front()), this.rotate(var0.top()));
    }

    public static OctahedralGroup fromXYAngles(Quadrant var0, Quadrant var1) {
        return XY_TABLE[var0.ordinal()][var1.ordinal()];
    }

    static {
        AXES = Direction.Axis.values();
        CAYLEY_TABLE = Util.make(new OctahedralGroup[OctahedralGroup.values().length][OctahedralGroup.values().length], var02 -> {
            Map<Pair, OctahedralGroup> var1 = Arrays.stream(OctahedralGroup.values()).collect(Collectors.toMap(var0 -> Pair.of((Object)((Object)var0.permutation), (Object)var0.packInversions()), var0 -> var0));
            for (OctahedralGroup var5 : OctahedralGroup.values()) {
                for (OctahedralGroup var9 : OctahedralGroup.values()) {
                    BooleanList var10 = var5.packInversions();
                    BooleanList var11 = var9.packInversions();
                    SymmetricGroup3 var12 = var9.permutation.compose(var5.permutation);
                    BooleanArrayList var13 = new BooleanArrayList(3);
                    for (int var14 = 0; var14 < 3; ++var14) {
                        var13.add(var10.getBoolean(var14) ^ var11.getBoolean(var5.permutation.permutation(var14)));
                    }
                    var02[var5.ordinal()][var9.ordinal()] = var1.get(Pair.of((Object)((Object)var12), (Object)var13));
                }
            }
        });
        INVERSE_TABLE = (OctahedralGroup[])Arrays.stream(OctahedralGroup.values()).map(var0 -> Arrays.stream(OctahedralGroup.values()).filter(var1 -> var0.compose((OctahedralGroup)var1) == IDENTITY).findAny().get()).toArray(OctahedralGroup[]::new);
        XY_TABLE = Util.make(new OctahedralGroup[Quadrant.values().length][Quadrant.values().length], var0 -> {
            for (Quadrant var4 : Quadrant.values()) {
                for (Quadrant var8 : Quadrant.values()) {
                    int var10;
                    OctahedralGroup var9 = IDENTITY;
                    for (var10 = 0; var10 < var8.shift; ++var10) {
                        var9 = var9.compose(ROT_90_Y_NEG);
                    }
                    for (var10 = 0; var10 < var4.shift; ++var10) {
                        var9 = var9.compose(ROT_90_X_NEG);
                    }
                    var0[var4.ordinal()][var8.ordinal()] = var9;
                }
            }
        });
    }
}

