/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.commands.AttributeCommand;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.commands.ClearInventoryCommands;
import net.minecraft.server.commands.CloneCommands;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DataPackCommand;
import net.minecraft.server.commands.DeOpCommands;
import net.minecraft.server.commands.DebugCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DefaultGameModeCommands;
import net.minecraft.server.commands.DialogCommand;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.server.commands.EffectCommands;
import net.minecraft.server.commands.EmoteCommands;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ExperienceCommand;
import net.minecraft.server.commands.FetchProfileCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.commands.ForceLoadCommand;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.commands.HelpCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.KickCommand;
import net.minecraft.server.commands.KillCommand;
import net.minecraft.server.commands.ListPlayersCommand;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.commands.MsgCommand;
import net.minecraft.server.commands.OpCommand;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.PardonIpCommand;
import net.minecraft.server.commands.ParticleCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PermissionCheck;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.PlaySoundCommand;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.RecipeCommand;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.SaveAllCommand;
import net.minecraft.server.commands.SaveOffCommand;
import net.minecraft.server.commands.SaveOnCommand;
import net.minecraft.server.commands.SayCommand;
import net.minecraft.server.commands.ScheduleCommand;
import net.minecraft.server.commands.ScoreboardCommand;
import net.minecraft.server.commands.SeedCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.commands.SetPlayerIdleTimeoutCommand;
import net.minecraft.server.commands.SetSpawnCommand;
import net.minecraft.server.commands.SetWorldSpawnCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.SpectateCommand;
import net.minecraft.server.commands.SpreadPlayersCommand;
import net.minecraft.server.commands.StopCommand;
import net.minecraft.server.commands.StopSoundCommand;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.TagCommand;
import net.minecraft.server.commands.TeamCommand;
import net.minecraft.server.commands.TeamMsgCommand;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.commands.TellRawCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.commands.TitleCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.TriggerCommand;
import net.minecraft.server.commands.VersionCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WaypointCommand;
import net.minecraft.server.commands.WeatherCommand;
import net.minecraft.server.commands.WhitelistCommand;
import net.minecraft.server.commands.WorldBorderCommand;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;

public class Commands {
    public static final String COMMAND_PREFIX = "/";
    private static final ThreadLocal<ExecutionContext<CommandSourceStack>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private static final ClientboundCommandsPacket.NodeInspector<CommandSourceStack> COMMAND_NODE_INSPECTOR = new ClientboundCommandsPacket.NodeInspector<CommandSourceStack>(){

        @Override
        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<CommandSourceStack, ?> argumentcommandnode) {
            SuggestionProvider suggestionprovider = argumentcommandnode.getCustomSuggestions();
            return suggestionprovider != null ? SuggestionProviders.getName(suggestionprovider) : null;
        }

        @Override
        public boolean isExecutable(CommandNode<CommandSourceStack> commandnode) {
            return commandnode.getCommand() != null;
        }

        @Override
        public boolean isRestricted(CommandNode<CommandSourceStack> commandnode) {
            PermissionCheck permissioncheck;
            Predicate<CommandSourceStack> predicate = commandnode.getRequirement();
            if (predicate instanceof PermissionCheck && (permissioncheck = (PermissionCheck)predicate).requiredLevel() > 0) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }
    };
    private final CommandDispatcher<CommandSourceStack> dispatcher = new CommandDispatcher();

    public Commands(CommandSelection commanddispatcher_servertype, CommandBuildContext commandbuildcontext) {
        this();
        AdvancementCommands.register(this.dispatcher);
        AttributeCommand.register(this.dispatcher, commandbuildcontext);
        ExecuteCommand.register(this.dispatcher, commandbuildcontext);
        BossBarCommands.register(this.dispatcher, commandbuildcontext);
        ClearInventoryCommands.register(this.dispatcher, commandbuildcontext);
        CloneCommands.register(this.dispatcher, commandbuildcontext);
        DamageCommand.register(this.dispatcher, commandbuildcontext);
        DataCommands.register(this.dispatcher);
        DataPackCommand.register(this.dispatcher, commandbuildcontext);
        DebugCommand.register(this.dispatcher);
        DefaultGameModeCommands.register(this.dispatcher);
        DialogCommand.register(this.dispatcher, commandbuildcontext);
        DifficultyCommand.register(this.dispatcher);
        EffectCommands.register(this.dispatcher, commandbuildcontext);
        EmoteCommands.register(this.dispatcher);
        EnchantCommand.register(this.dispatcher, commandbuildcontext);
        ExperienceCommand.register(this.dispatcher);
        FillCommand.register(this.dispatcher, commandbuildcontext);
        FillBiomeCommand.register(this.dispatcher, commandbuildcontext);
        ForceLoadCommand.register(this.dispatcher);
        FunctionCommand.register(this.dispatcher);
        GameModeCommand.register(this.dispatcher);
        GameRuleCommand.register(this.dispatcher, commandbuildcontext);
        GiveCommand.register(this.dispatcher, commandbuildcontext);
        HelpCommand.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, commandbuildcontext);
        KickCommand.register(this.dispatcher);
        KillCommand.register(this.dispatcher);
        ListPlayersCommand.register(this.dispatcher);
        LocateCommand.register(this.dispatcher, commandbuildcontext);
        LootCommand.register(this.dispatcher, commandbuildcontext);
        MsgCommand.register(this.dispatcher);
        ParticleCommand.register(this.dispatcher, commandbuildcontext);
        PlaceCommand.register(this.dispatcher);
        PlaySoundCommand.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        ReloadCommand.register(this.dispatcher);
        RecipeCommand.register(this.dispatcher);
        FetchProfileCommand.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        RotateCommand.register(this.dispatcher);
        SayCommand.register(this.dispatcher);
        ScheduleCommand.register(this.dispatcher);
        ScoreboardCommand.register(this.dispatcher, commandbuildcontext);
        SeedCommand.register(this.dispatcher, commanddispatcher_servertype != CommandSelection.INTEGRATED);
        VersionCommand.register(this.dispatcher, commanddispatcher_servertype != CommandSelection.INTEGRATED);
        SetBlockCommand.register(this.dispatcher, commandbuildcontext);
        SetSpawnCommand.register(this.dispatcher);
        SetWorldSpawnCommand.register(this.dispatcher);
        SpectateCommand.register(this.dispatcher);
        SpreadPlayersCommand.register(this.dispatcher);
        StopSoundCommand.register(this.dispatcher);
        SummonCommand.register(this.dispatcher, commandbuildcontext);
        TagCommand.register(this.dispatcher);
        TeamCommand.register(this.dispatcher, commandbuildcontext);
        TeamMsgCommand.register(this.dispatcher);
        TeleportCommand.register(this.dispatcher);
        TellRawCommand.register(this.dispatcher, commandbuildcontext);
        TestCommand.register(this.dispatcher, commandbuildcontext);
        TickCommand.register(this.dispatcher);
        TimeCommand.register(this.dispatcher);
        TitleCommand.register(this.dispatcher, commandbuildcontext);
        TriggerCommand.register(this.dispatcher);
        WaypointCommand.register(this.dispatcher, commandbuildcontext);
        WeatherCommand.register(this.dispatcher);
        WorldBorderCommand.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_CHASE_COMMAND) {
            ChaseCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_DEV_COMMANDS || SharedConstants.IS_RUNNING_IN_IDE) {
            RaidCommand.register(this.dispatcher, commandbuildcontext);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (commanddispatcher_servertype.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher, commandbuildcontext);
            }
        }
        if (commanddispatcher_servertype.includeDedicated) {
            BanIpCommands.register(this.dispatcher);
            BanListCommands.register(this.dispatcher);
            BanPlayerCommands.register(this.dispatcher);
            DeOpCommands.register(this.dispatcher);
            OpCommand.register(this.dispatcher);
            PardonCommand.register(this.dispatcher);
            PardonIpCommand.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            SaveAllCommand.register(this.dispatcher);
            SaveOffCommand.register(this.dispatcher);
            SaveOnCommand.register(this.dispatcher);
            SetPlayerIdleTimeoutCommand.register(this.dispatcher);
            StopCommand.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            WhitelistCommand.register(this.dispatcher);
        }
        if (commanddispatcher_servertype.includeIntegrated) {
            PublishCommand.register(this.dispatcher);
        }
    }

    public Commands() {
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> parseresults, UnaryOperator<S> unaryoperator) {
        CommandContextBuilder commandcontextbuilder = parseresults.getContext();
        CommandContextBuilder commandcontextbuilder1 = commandcontextbuilder.withSource(unaryoperator.apply(commandcontextbuilder.getSource()));
        return new ParseResults(commandcontextbuilder1, parseresults.getReader(), parseresults.getExceptions());
    }

    public void dispatchServerCommand(CommandSourceStack sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith(COMMAND_PREFIX)) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        String cmd = args[0];
        if (cmd.startsWith("minecraft:")) {
            cmd = cmd.substring("minecraft:".length());
        }
        if (cmd.startsWith("bukkit:")) {
            cmd = cmd.substring("bukkit:".length());
        }
        if (cmd.equalsIgnoreCase("stop") || cmd.equalsIgnoreCase("kick") || cmd.equalsIgnoreCase("op") || cmd.equalsIgnoreCase("deop") || cmd.equalsIgnoreCase("ban") || cmd.equalsIgnoreCase("ban-ip") || cmd.equalsIgnoreCase("pardon") || cmd.equalsIgnoreCase("pardon-ip") || cmd.equalsIgnoreCase("reload")) {
            return;
        }
        if (sender.getLevel().getCraftServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + (String)args[0];
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void performPrefixedCommand(CommandSourceStack commandlistenerwrapper, String s) {
        this.performPrefixedCommand(commandlistenerwrapper, s, s);
    }

    public void performPrefixedCommand(CommandSourceStack commandlistenerwrapper, String s, String label) {
        s = Commands.trimOptionalPrefix(s);
        this.performCommand(this.dispatcher.parse(s, commandlistenerwrapper), s, label);
    }

    public static String trimOptionalPrefix(String s) {
        return s.startsWith(COMMAND_PREFIX) ? s.substring(1) : s;
    }

    public void performCommand(ParseResults<CommandSourceStack> parseresults, String s) {
        this.performCommand(parseresults, s, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandSourceStack> parseresults, String s, String label) {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)parseresults.getContext().getSource();
        Profiler.get().push(() -> COMMAND_PREFIX + s);
        ContextChain<CommandSourceStack> contextchain = Commands.finishParsing(parseresults, s, commandlistenerwrapper, label);
        try {
            if (contextchain != null) {
                Commands.executeCommandInContext(commandlistenerwrapper, executioncontext -> ExecutionContext.queueInitialCommandExecution(executioncontext, s, contextchain, commandlistenerwrapper, CommandResultCallback.EMPTY));
            }
        }
        catch (Exception exception) {
            MutableComponent ichatmutablecomponent = Component.literal(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Command exception: /{}", (Object)s, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i = 0; i < Math.min(astacktraceelement.length, 3); ++i) {
                    ichatmutablecomponent.append("\n\n").append(astacktraceelement[i].getMethodName()).append("\n ").append(astacktraceelement[i].getFileName()).append(":").append(String.valueOf(astacktraceelement[i].getLineNumber()));
                }
            }
            commandlistenerwrapper.sendFailure(Component.translatable("command.failed").withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent.ShowText(ichatmutablecomponent))));
            if (SharedConstants.DEBUG_VERBOSE_COMMAND_ERRORS || SharedConstants.IS_RUNNING_IN_IDE) {
                commandlistenerwrapper.sendFailure(Component.literal(Util.describeError(exception)));
                LOGGER.error("'/{}' threw an exception", (Object)s, (Object)exception);
            }
        }
        finally {
            Profiler.get().pop();
        }
    }

    @Nullable
    private static ContextChain<CommandSourceStack> finishParsing(ParseResults<CommandSourceStack> parseresults, String s, CommandSourceStack commandlistenerwrapper, String label) {
        try {
            Commands.validateParseResults(parseresults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseresults.getContext().build(s)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            commandlistenerwrapper.sendFailure(ComponentUtils.fromMessage(commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int i = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                MutableComponent ichatmutablecomponent = Component.empty().withStyle(ChatFormatting.GRAY).withStyle(chatmodifier -> chatmodifier.withClickEvent(new ClickEvent.SuggestCommand(COMMAND_PREFIX + label)));
                if (i > 10) {
                    ichatmutablecomponent.append(CommonComponents.ELLIPSIS);
                }
                ichatmutablecomponent.append(commandsyntaxexception.getInput().substring(Math.max(0, i - 10), i));
                if (i < commandsyntaxexception.getInput().length()) {
                    MutableComponent ichatbasecomponent = Component.literal(commandsyntaxexception.getInput().substring(i)).withStyle(ChatFormatting.RED, ChatFormatting.UNDERLINE);
                    ichatmutablecomponent.append(ichatbasecomponent);
                }
                ichatmutablecomponent.append(Component.translatable("command.context.here").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
                commandlistenerwrapper.sendFailure(ichatmutablecomponent);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandSourceStack commandlistenerwrapper, Consumer<ExecutionContext<CommandSourceStack>> consumer) {
        block9: {
            boolean flag;
            MinecraftServer minecraftserver = commandlistenerwrapper.getServer();
            ExecutionContext<CommandSourceStack> executioncontext = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = flag = executioncontext == null;
            if (flag) {
                int i = Math.max(1, minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH));
                int j = minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_FORK_COUNT);
                try (ExecutionContext executioncontext1 = new ExecutionContext(i, j, Profiler.get());){
                    CURRENT_EXECUTION_CONTEXT.set(executioncontext1);
                    consumer.accept(executioncontext1);
                    executioncontext1.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            consumer.accept(executioncontext);
        }
    }

    public void sendCommands(ServerPlayer entityplayer) {
        IdentityHashMap map = new IdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode<CommandSourceStack> vanilla = entityplayer.server.vanillaCommandDispatcher.getDispatcher().getRoot();
        map.put((CommandNode)vanilla, (CommandNode)vanillaRoot);
        Commands.fillUsableCommands(vanilla, vanillaRoot, entityplayer.createCommandSourceStack(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put((CommandNode)this.dispatcher.getRoot(), (CommandNode)rootcommandnode);
        Commands.fillUsableCommands(this.dispatcher.getRoot(), rootcommandnode, entityplayer.createCommandSourceStack(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)entityplayer.getBukkitEntity(), new LinkedHashSet(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootcommandnode.removeCommand(orig);
        }
        entityplayer.connection.send(new ClientboundCommandsPacket(rootcommandnode, COMMAND_NODE_INSPECTOR));
    }

    private static <S> void fillUsableCommands(CommandNode<S> commandnode, CommandNode<S> commandnode1, S s0, Map<CommandNode<S>, CommandNode<S>> map) {
        for (CommandNode<S> commandnode2 : commandnode.getChildren()) {
            if (!commandnode2.canUse(s0)) continue;
            ArgumentBuilder<S, ?> argumentbuilder = commandnode2.createBuilder();
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(map.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode3 = argumentbuilder.build();
            map.put(commandnode2, commandnode3);
            commandnode1.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            Commands.fillUsableCommands(commandnode2, commandnode3, s0, map);
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String s) {
        return LiteralArgumentBuilder.literal((String)s);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String s, ArgumentType<T> argumenttype) {
        return RequiredArgumentBuilder.argument((String)s, argumenttype);
    }

    public static Predicate<String> createValidator(ParseFunction commanddispatcher_b) {
        return s -> {
            try {
                commanddispatcher_b.parse(new StringReader(s));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> parseresults) throws CommandSyntaxException {
        CommandSyntaxException commandsyntaxexception = Commands.getParseException(parseresults);
        if (commandsyntaxexception != null) {
            throw commandsyntaxexception;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> parseresults) {
        return !parseresults.getReader().canRead() ? null : (parseresults.getExceptions().size() == 1 ? (CommandSyntaxException)((Object)parseresults.getExceptions().values().iterator().next()) : (parseresults.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parseresults.getReader())));
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.Provider holderlookup_a) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet enabledFeatures() {
                return FeatureFlags.REGISTRY.allFlags();
            }

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return holderlookup_a.listRegistryKeys();
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> resourcekey) {
                return holderlookup_a.lookup(resourcekey).map(this::createLookup);
            }

            private <T> HolderLookup.RegistryLookup.Delegate<T> createLookup(final HolderLookup.RegistryLookup<T> holderlookup_b) {
                return new HolderLookup.RegistryLookup.Delegate<T>(){

                    @Override
                    public HolderLookup.RegistryLookup<T> parent() {
                        return holderlookup_b;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> tagkey) {
                        return Optional.of(this.getOrThrow(tagkey));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> tagkey) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.parent().get(tagkey);
                        return optional.orElseGet(() -> HolderSet.emptyNamed(this.parent(), tagkey));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext commandbuildcontext = Commands.createValidationContext(VanillaRegistries.createLookup());
        CommandDispatcher<CommandSourceStack> com_mojang_brigadier_commanddispatcher = new Commands(CommandSelection.ALL, commandbuildcontext).getDispatcher();
        RootCommandNode<CommandSourceStack> rootcommandnode = com_mojang_brigadier_commanddispatcher.getRoot();
        com_mojang_brigadier_commanddispatcher.findAmbiguities((AmbiguityConsumer<CommandSourceStack>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{com_mojang_brigadier_commanddispatcher.getPath(commandnode1), com_mojang_brigadier_commanddispatcher.getPath(commandnode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.findUsedArgumentTypes(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentTypeInfos.isClassRecognized(argumenttype.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + String.valueOf(argumenttype)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static <T extends PermissionSource> PermissionCheck<T> hasPermission(int i) {
        return new PermissionSource.Check(i);
    }

    public static enum CommandSelection {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        final boolean includeIntegrated;
        final boolean includeDedicated;

        private CommandSelection(boolean flag, boolean flag1) {
            this.includeIntegrated = flag;
            this.includeDedicated = flag1;
        }
    }

    @FunctionalInterface
    public static interface ParseFunction {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

