/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityAnchorArgument
implements ArgumentType<Anchor> {
    private static final Collection<String> EXAMPLES = Arrays.asList("eyes", "feet");
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.anchor.invalid", var0));

    public static Anchor getAnchor(CommandContext<CommandSourceStack> var0, String var1) {
        return (Anchor)((Object)var0.getArgument(var1, Anchor.class));
    }

    public static EntityAnchorArgument anchor() {
        return new EntityAnchorArgument();
    }

    public Anchor parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = var0.readUnquotedString();
        Anchor var3 = Anchor.getByName(var2);
        if (var3 == null) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0, (Object)var2);
        }
        return var3;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.suggest(Anchor.BY_NAME.keySet(), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static enum Anchor {
        FEET("feet", (var0, var1) -> var0),
        EYES("eyes", (var0, var1) -> new Vec3(var0.x, var0.y + (double)var1.getEyeHeight(), var0.z));

        static final Map<String, Anchor> BY_NAME;
        private final String name;
        private final BiFunction<Vec3, Entity, Vec3> transform;

        private Anchor(String var2, BiFunction var3) {
            this.name = var2;
            this.transform = var3;
        }

        @Nullable
        public static Anchor getByName(String var0) {
            return BY_NAME.get(var0);
        }

        public Vec3 apply(Entity var0) {
            return this.transform.apply(var0.position(), var0);
        }

        public Vec3 apply(CommandSourceStack var0) {
            Entity var1 = var0.getEntity();
            if (var1 == null) {
                return var0.getPosition();
            }
            return this.transform.apply(var0.getPosition(), var1);
        }

        static {
            BY_NAME = Util.make(Maps.newHashMap(), var0 -> {
                for (Anchor var4 : Anchor.values()) {
                    var0.put(var4.name, var4);
                }
            });
        }
    }
}

