/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NbtPathArgument
implements ArgumentType<NbtPath> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType ERROR_INVALID_NODE = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.node.invalid"));
    public static final SimpleCommandExceptionType ERROR_DATA_TOO_DEEP = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.too_deep"));
    public static final DynamicCommandExceptionType ERROR_NOTHING_FOUND = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.nbtpath.nothing_found", var0));
    static final DynamicCommandExceptionType ERROR_EXPECTED_LIST = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.modify.expected_list", var0));
    static final DynamicCommandExceptionType ERROR_INVALID_INDEX = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.modify.invalid_index", var0));
    private static final char INDEX_MATCH_START = '[';
    private static final char INDEX_MATCH_END = ']';
    private static final char KEY_MATCH_START = '{';
    private static final char KEY_MATCH_END = '}';
    private static final char QUOTED_KEY_START = '\"';
    private static final char SINGLE_QUOTED_KEY_START = '\'';

    public static NbtPathArgument nbtPath() {
        return new NbtPathArgument();
    }

    public static NbtPath getPath(CommandContext<CommandSourceStack> var0, String var1) {
        return (NbtPath)var0.getArgument(var1, NbtPath.class);
    }

    public NbtPath parse(StringReader var0) throws CommandSyntaxException {
        ArrayList var1 = Lists.newArrayList();
        int var2 = var0.getCursor();
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        boolean var4 = true;
        while (var0.canRead() && var0.peek() != ' ') {
            char var6;
            Node var5 = NbtPathArgument.parseNode(var0, var4);
            var1.add(var5);
            var3.put((Object)var5, var0.getCursor() - var2);
            var4 = false;
            if (!var0.canRead() || (var6 = var0.peek()) == ' ' || var6 == '[' || var6 == '{') continue;
            var0.expect('.');
        }
        return new NbtPath(var0.getString().substring(var2, var0.getCursor()), var1.toArray(new Node[0]), (Object2IntMap<Node>)var3);
    }

    private static Node parseNode(StringReader var0, boolean var1) throws CommandSyntaxException {
        return switch (var0.peek()) {
            case '{' -> {
                if (!var1) {
                    throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)var0);
                }
                CompoundTag var2 = TagParser.parseCompoundAsArgument(var0);
                yield new MatchRootObjectNode(var2);
            }
            case '[' -> {
                var0.skip();
                char var2 = var0.peek();
                if (var2 == '{') {
                    CompoundTag var3 = TagParser.parseCompoundAsArgument(var0);
                    var0.expect(']');
                    yield new MatchElementNode(var3);
                }
                if (var2 == ']') {
                    var0.skip();
                    yield AllElementsNode.INSTANCE;
                }
                int var3 = var0.readInt();
                var0.expect(']');
                yield new IndexedElementNode(var3);
            }
            case '\"', '\'' -> NbtPathArgument.readObjectNode(var0, var0.readString());
            default -> NbtPathArgument.readObjectNode(var0, NbtPathArgument.readUnquotedName(var0));
        };
    }

    private static Node readObjectNode(StringReader var0, String var1) throws CommandSyntaxException {
        if (var1.isEmpty()) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)var0);
        }
        if (var0.canRead() && var0.peek() == '{') {
            CompoundTag var2 = TagParser.parseCompoundAsArgument(var0);
            return new MatchObjectNode(var1, var2);
        }
        return new CompoundChildNode(var1);
    }

    private static String readUnquotedName(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        while (var0.canRead() && NbtPathArgument.isAllowedInUnquotedName(var0.peek())) {
            var0.skip();
        }
        if (var0.getCursor() == var1) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)var0);
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isAllowedInUnquotedName(char var0) {
        return var0 != ' ' && var0 != '\"' && var0 != '\'' && var0 != '[' && var0 != ']' && var0 != '.' && var0 != '{' && var0 != '}';
    }

    static Predicate<Tag> createTagPredicate(CompoundTag var0) {
        return var1 -> NbtUtils.compareNbt(var0, var1, true);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class NbtPath {
        private final String original;
        private final Object2IntMap<Node> nodeToOriginalPosition;
        private final Node[] nodes;
        public static final Codec<NbtPath> CODEC = Codec.STRING.comapFlatMap(var0 -> {
            try {
                NbtPath var1 = new NbtPathArgument().parse(new StringReader(var0));
                return DataResult.success((Object)var1);
            }
            catch (CommandSyntaxException var1) {
                return DataResult.error(() -> "Failed to parse path " + var0 + ": " + var1.getMessage());
            }
        }, NbtPath::asString);

        public static NbtPath of(String var0) throws CommandSyntaxException {
            return new NbtPathArgument().parse(new StringReader(var0));
        }

        public NbtPath(String var0, Node[] var1, Object2IntMap<Node> var2) {
            this.original = var0;
            this.nodes = var1;
            this.nodeToOriginalPosition = var2;
        }

        public List<Tag> get(Tag var0) throws CommandSyntaxException {
            List<Tag> var1 = Collections.singletonList(var0);
            for (Node var5 : this.nodes) {
                if (!(var1 = var5.get(var1)).isEmpty()) continue;
                throw this.createNotFoundException(var5);
            }
            return var1;
        }

        public int countMatching(Tag var0) {
            List<Tag> var1 = Collections.singletonList(var0);
            for (Node var5 : this.nodes) {
                if (!(var1 = var5.get(var1)).isEmpty()) continue;
                return 0;
            }
            return var1.size();
        }

        private List<Tag> getOrCreateParents(Tag var0) throws CommandSyntaxException {
            List<Tag> var1 = Collections.singletonList(var0);
            for (int var2 = 0; var2 < this.nodes.length - 1; ++var2) {
                Node var3 = this.nodes[var2];
                int var4 = var2 + 1;
                if (!(var1 = var3.getOrCreate(var1, this.nodes[var4]::createPreferredParentTag)).isEmpty()) continue;
                throw this.createNotFoundException(var3);
            }
            return var1;
        }

        public List<Tag> getOrCreate(Tag var0, Supplier<Tag> var1) throws CommandSyntaxException {
            List<Tag> var2 = this.getOrCreateParents(var0);
            Node var3 = this.nodes[this.nodes.length - 1];
            return var3.getOrCreate(var2, var1);
        }

        private static int apply(List<Tag> var02, Function<Tag, Integer> var12) {
            return var02.stream().map(var12).reduce(0, (var0, var1) -> var0 + var1);
        }

        public static boolean isTooDeep(Tag var0, int var1) {
            block4: {
                block3: {
                    if (var1 >= 512) {
                        return true;
                    }
                    if (!(var0 instanceof CompoundTag)) break block3;
                    CompoundTag var2 = (CompoundTag)var0;
                    for (Tag var5 : var2.values()) {
                        if (!NbtPath.isTooDeep(var5, var1 + 1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(var0 instanceof ListTag)) break block4;
                ListTag var3 = (ListTag)var0;
                for (Tag var5 : var3) {
                    if (!NbtPath.isTooDeep(var5, var1 + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        public int set(Tag var0, Tag var1) throws CommandSyntaxException {
            if (NbtPath.isTooDeep(var1, this.estimatePathDepth())) {
                throw ERROR_DATA_TOO_DEEP.create();
            }
            Tag var2 = var1.copy();
            List<Tag> var32 = this.getOrCreateParents(var0);
            if (var32.isEmpty()) {
                return 0;
            }
            Node var4 = this.nodes[this.nodes.length - 1];
            MutableBoolean var5 = new MutableBoolean(false);
            return NbtPath.apply(var32, var3 -> var4.setTag((Tag)var3, () -> {
                if (var5.isFalse()) {
                    var5.setTrue();
                    return var2;
                }
                return var2.copy();
            }));
        }

        private int estimatePathDepth() {
            return this.nodes.length;
        }

        public int insert(int var0, CompoundTag var1, List<Tag> var2) throws CommandSyntaxException {
            ArrayList<Tag> var3 = new ArrayList<Tag>(var2.size());
            for (Tag var5 : var2) {
                Tag var6 = var5.copy();
                var3.add(var6);
                if (!NbtPath.isTooDeep(var6, this.estimatePathDepth())) continue;
                throw ERROR_DATA_TOO_DEEP.create();
            }
            List<Tag> var4 = this.getOrCreate(var1, ListTag::new);
            int var5 = 0;
            boolean var6 = false;
            for (Tag var8 : var4) {
                if (!(var8 instanceof CollectionTag)) {
                    throw ERROR_EXPECTED_LIST.create((Object)var8);
                }
                CollectionTag var9 = (CollectionTag)var8;
                boolean var10 = false;
                int var11 = var0 < 0 ? var9.size() + var0 + 1 : var0;
                for (Tag var13 : var3) {
                    try {
                        if (!var9.addTag(var11, var6 ? var13.copy() : var13)) continue;
                        ++var11;
                        var10 = true;
                    }
                    catch (IndexOutOfBoundsException var14) {
                        throw ERROR_INVALID_INDEX.create((Object)var11);
                    }
                }
                var6 = true;
                var5 += var10 ? 1 : 0;
            }
            return var5;
        }

        public int remove(Tag var0) {
            List<Tag> var1 = Collections.singletonList(var0);
            for (int var2 = 0; var2 < this.nodes.length - 1; ++var2) {
                var1 = this.nodes[var2].get(var1);
            }
            Node var2 = this.nodes[this.nodes.length - 1];
            return NbtPath.apply(var1, var2::removeTag);
        }

        private CommandSyntaxException createNotFoundException(Node var0) {
            int var1 = this.nodeToOriginalPosition.getInt((Object)var0);
            return ERROR_NOTHING_FOUND.create((Object)this.original.substring(0, var1));
        }

        public String toString() {
            return this.original;
        }

        public String asString() {
            return this.original;
        }
    }

    static interface Node {
        public void getTag(Tag var1, List<Tag> var2);

        public void getOrCreateTag(Tag var1, Supplier<Tag> var2, List<Tag> var3);

        public Tag createPreferredParentTag();

        public int setTag(Tag var1, Supplier<Tag> var2);

        public int removeTag(Tag var1);

        default public List<Tag> get(List<Tag> var0) {
            return this.collect(var0, this::getTag);
        }

        default public List<Tag> getOrCreate(List<Tag> var0, Supplier<Tag> var12) {
            return this.collect(var0, (var1, var2) -> this.getOrCreateTag((Tag)var1, var12, (List<Tag>)var2));
        }

        default public List<Tag> collect(List<Tag> var0, BiConsumer<Tag, List<Tag>> var1) {
            ArrayList var2 = Lists.newArrayList();
            for (Tag var4 : var0) {
                var1.accept(var4, var2);
            }
            return var2;
        }
    }

    static class MatchRootObjectNode
    implements Node {
        private final Predicate<Tag> predicate;

        public MatchRootObjectNode(CompoundTag var0) {
            this.predicate = NbtPathArgument.createTagPredicate(var0);
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            if (var0 instanceof CompoundTag && this.predicate.test(var0)) {
                var1.add(var0);
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var2) {
            this.getTag(var0, var2);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            return 0;
        }

        @Override
        public int removeTag(Tag var0) {
            return 0;
        }
    }

    static class MatchElementNode
    implements Node {
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchElementNode(CompoundTag var0) {
            this.pattern = var0;
            this.predicate = NbtPathArgument.createTagPredicate(var0);
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            if (var0 instanceof ListTag) {
                ListTag var2 = (ListTag)var0;
                var2.stream().filter(this.predicate).forEach(var1::add);
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var22) {
            MutableBoolean var3 = new MutableBoolean();
            if (var0 instanceof ListTag) {
                ListTag var4 = (ListTag)var0;
                var4.stream().filter(this.predicate).forEach(var2 -> {
                    var22.add((Tag)var2);
                    var3.setTrue();
                });
                if (var3.isFalse()) {
                    CompoundTag var5 = this.pattern.copy();
                    var4.add(var5);
                    var22.add(var5);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            int var2 = 0;
            if (var0 instanceof ListTag) {
                ListTag var3 = (ListTag)var0;
                int var4 = var3.size();
                if (var4 == 0) {
                    var3.add(var1.get());
                    ++var2;
                } else {
                    for (int var5 = 0; var5 < var4; ++var5) {
                        Tag var7;
                        Tag var6 = var3.get(var5);
                        if (!this.predicate.test(var6) || (var7 = var1.get()).equals(var6) || !var3.setTag(var5, var7)) continue;
                        ++var2;
                    }
                }
            }
            return var2;
        }

        @Override
        public int removeTag(Tag var0) {
            int var1 = 0;
            if (var0 instanceof ListTag) {
                ListTag var2 = (ListTag)var0;
                for (int var3 = var2.size() - 1; var3 >= 0; --var3) {
                    if (!this.predicate.test(var2.get(var3))) continue;
                    var2.remove(var3);
                    ++var1;
                }
            }
            return var1;
        }
    }

    static class AllElementsNode
    implements Node {
        public static final AllElementsNode INSTANCE = new AllElementsNode();

        private AllElementsNode() {
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            if (var0 instanceof CollectionTag) {
                CollectionTag var2 = (CollectionTag)var0;
                Iterables.addAll(var1, (Iterable)var2);
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var2) {
            if (var0 instanceof CollectionTag) {
                CollectionTag var3 = (CollectionTag)var0;
                if (var3.isEmpty()) {
                    Tag var4 = var1.get();
                    if (var3.addTag(0, var4)) {
                        var2.add(var4);
                    }
                } else {
                    Iterables.addAll(var2, (Iterable)var3);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            if (var0 instanceof CollectionTag) {
                CollectionTag var2 = (CollectionTag)var0;
                int var3 = var2.size();
                if (var3 == 0) {
                    var2.addTag(0, var1.get());
                    return 1;
                }
                Tag var4 = var1.get();
                int var5 = var3 - (int)var2.stream().filter((Predicate<Tag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/minecraft/nbt/Tag;)Z)((Tag)var4)).count();
                if (var5 == 0) {
                    return 0;
                }
                var2.clear();
                if (!var2.addTag(0, var4)) {
                    return 0;
                }
                for (int var6 = 1; var6 < var3; ++var6) {
                    var2.addTag(var6, var1.get());
                }
                return var5;
            }
            return 0;
        }

        @Override
        public int removeTag(Tag var0) {
            CollectionTag var1;
            int var2;
            if (var0 instanceof CollectionTag && (var2 = (var1 = (CollectionTag)var0).size()) > 0) {
                var1.clear();
                return var2;
            }
            return 0;
        }
    }

    static class IndexedElementNode
    implements Node {
        private final int index;

        public IndexedElementNode(int var0) {
            this.index = var0;
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            if (var0 instanceof CollectionTag) {
                int var4;
                CollectionTag var2 = (CollectionTag)var0;
                int var3 = var2.size();
                int n = var4 = this.index < 0 ? var3 + this.index : this.index;
                if (0 <= var4 && var4 < var3) {
                    var1.add(var2.get(var4));
                }
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var2) {
            this.getTag(var0, var2);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            if (var0 instanceof CollectionTag) {
                int var4;
                CollectionTag var2 = (CollectionTag)var0;
                int var3 = var2.size();
                int n = var4 = this.index < 0 ? var3 + this.index : this.index;
                if (0 <= var4 && var4 < var3) {
                    Tag var5 = var2.get(var4);
                    Tag var6 = var1.get();
                    if (!var6.equals(var5) && var2.setTag(var4, var6)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag var0) {
            if (var0 instanceof CollectionTag) {
                int var3;
                CollectionTag var1 = (CollectionTag)var0;
                int var2 = var1.size();
                int n = var3 = this.index < 0 ? var2 + this.index : this.index;
                if (0 <= var3 && var3 < var2) {
                    var1.remove(var3);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class MatchObjectNode
    implements Node {
        private final String name;
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchObjectNode(String var0, CompoundTag var1) {
            this.name = var0;
            this.pattern = var1;
            this.predicate = NbtPathArgument.createTagPredicate(var1);
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            Tag var2;
            if (var0 instanceof CompoundTag && this.predicate.test(var2 = ((CompoundTag)var0).get(this.name))) {
                var1.add(var2);
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var2) {
            if (var0 instanceof CompoundTag) {
                CompoundTag var3 = (CompoundTag)var0;
                Tag var4 = var3.get(this.name);
                if (var4 == null) {
                    var4 = this.pattern.copy();
                    var3.put(this.name, var4);
                    var2.add(var4);
                } else if (this.predicate.test(var4)) {
                    var2.add(var4);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            Tag var4;
            CompoundTag var2;
            Tag var3;
            if (var0 instanceof CompoundTag && this.predicate.test(var3 = (var2 = (CompoundTag)var0).get(this.name)) && !(var4 = var1.get()).equals(var3)) {
                var2.put(this.name, var4);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeTag(Tag var0) {
            CompoundTag var1;
            Tag var2;
            if (var0 instanceof CompoundTag && this.predicate.test(var2 = (var1 = (CompoundTag)var0).get(this.name))) {
                var1.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class CompoundChildNode
    implements Node {
        private final String name;

        public CompoundChildNode(String var0) {
            this.name = var0;
        }

        @Override
        public void getTag(Tag var0, List<Tag> var1) {
            Tag var2;
            if (var0 instanceof CompoundTag && (var2 = ((CompoundTag)var0).get(this.name)) != null) {
                var1.add(var2);
            }
        }

        @Override
        public void getOrCreateTag(Tag var0, Supplier<Tag> var1, List<Tag> var2) {
            if (var0 instanceof CompoundTag) {
                Tag var4;
                CompoundTag var3 = (CompoundTag)var0;
                if (var3.contains(this.name)) {
                    var4 = var3.get(this.name);
                } else {
                    var4 = var1.get();
                    var3.put(this.name, var4);
                }
                var2.add(var4);
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag var0, Supplier<Tag> var1) {
            if (var0 instanceof CompoundTag) {
                Tag var4;
                CompoundTag var2 = (CompoundTag)var0;
                Tag var3 = var1.get();
                if (!var3.equals(var4 = var2.put(this.name, var3))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag var0) {
            CompoundTag var1;
            if (var0 instanceof CompoundTag && (var1 = (CompoundTag)var0).contains(this.name)) {
                var1.remove(this.name);
                return 1;
            }
            return 0;
        }
    }
}

