/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BastionBridgePools;
import net.minecraft.data.worldgen.BastionHoglinStablePools;
import net.minecraft.data.worldgen.BastionHousingUnitsPools;
import net.minecraft.data.worldgen.BastionSharedPools;
import net.minecraft.data.worldgen.BastionTreasureRoomPools;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class BastionPieces {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("bastion/starts");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> var0) {
        HolderGetter<StructureProcessorList> var1 = var0.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> var2 = var1.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
        HolderGetter<StructureTemplatePool> var3 = var0.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> var4 = var3.getOrThrow(Pools.EMPTY);
        var0.register(START, new StructureTemplatePool(var4, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.single("bastion/units/air_base", var2), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/hoglin_stable/air_base", var2), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/treasure/big_air_full", var2), (Object)1), (Object)Pair.of(StructurePoolElement.single("bastion/bridge/starting_pieces/entrance_base", var2), (Object)1)), StructureTemplatePool.Projection.RIGID));
        BastionHousingUnitsPools.bootstrap(var0);
        BastionHoglinStablePools.bootstrap(var0);
        BastionTreasureRoomPools.bootstrap(var0);
        BastionBridgePools.bootstrap(var0);
        BastionSharedPools.bootstrap(var0);
    }
}

