/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public interface TestEnvironmentDefinition {
    public static final Codec<TestEnvironmentDefinition> DIRECT_CODEC = BuiltInRegistries.TEST_ENVIRONMENT_DEFINITION_TYPE.byNameCodec().dispatch(TestEnvironmentDefinition::codec, var0 -> var0);
    public static final Codec<Holder<TestEnvironmentDefinition>> CODEC = RegistryFileCodec.create(Registries.TEST_ENVIRONMENT, DIRECT_CODEC);

    public static MapCodec<? extends TestEnvironmentDefinition> bootstrap(Registry<MapCodec<? extends TestEnvironmentDefinition>> var0) {
        Registry.register(var0, "all_of", AllOf.CODEC);
        Registry.register(var0, "game_rules", SetGameRules.CODEC);
        Registry.register(var0, "time_of_day", TimeOfDay.CODEC);
        Registry.register(var0, "weather", Weather.CODEC);
        return Registry.register(var0, "function", Functions.CODEC);
    }

    public void setup(ServerLevel var1);

    default public void teardown(ServerLevel var0) {
    }

    public MapCodec<? extends TestEnvironmentDefinition> codec();

    public record AllOf(List<Holder<TestEnvironmentDefinition>> definitions) implements TestEnvironmentDefinition
    {
        public static final MapCodec<AllOf> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.listOf().fieldOf("definitions").forGetter(AllOf::definitions)).apply((Applicative)var0, AllOf::new));

        public AllOf(TestEnvironmentDefinition ... var0) {
            this(Arrays.stream(var0).map(Holder::direct).toList());
        }

        @Override
        public void setup(ServerLevel var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).setup(var0));
        }

        @Override
        public void teardown(ServerLevel var0) {
            this.definitions.forEach(var1 -> ((TestEnvironmentDefinition)var1.value()).teardown(var0));
        }

        public MapCodec<AllOf> codec() {
            return CODEC;
        }
    }

    public record SetGameRules(List<Entry<Boolean, GameRules.BooleanValue>> boolRules, List<Entry<Integer, GameRules.IntegerValue>> intRules) implements TestEnvironmentDefinition
    {
        public static final MapCodec<SetGameRules> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Entry.codec(GameRules.BooleanValue.class, Codec.BOOL).listOf().fieldOf("bool_rules").forGetter(SetGameRules::boolRules), (App)Entry.codec(GameRules.IntegerValue.class, Codec.INT).listOf().fieldOf("int_rules").forGetter(SetGameRules::intRules)).apply((Applicative)var0, SetGameRules::new));

        @Override
        public void setup(ServerLevel var0) {
            GameRules var1 = var0.getGameRules();
            MinecraftServer var2 = var0.getServer();
            for (Entry<Boolean, GameRules.BooleanValue> entry : this.boolRules) {
                var1.getRule(entry.key()).set(entry.value(), var2);
            }
            for (Entry<Comparable<Boolean>, GameRules.Value> entry : this.intRules) {
                ((GameRules.IntegerValue)var1.getRule(entry.key())).set((Integer)entry.value(), var2);
            }
        }

        @Override
        public void teardown(ServerLevel var0) {
            GameRules var1 = var0.getGameRules();
            MinecraftServer var2 = var0.getServer();
            for (Entry<Boolean, GameRules.BooleanValue> entry : this.boolRules) {
                var1.getRule(entry.key()).setFrom(GameRules.getType(entry.key()).createRule(), var2);
            }
            for (Entry<Comparable<Boolean>, GameRules.Value> entry : this.intRules) {
                ((GameRules.IntegerValue)var1.getRule(entry.key())).setFrom((GameRules.IntegerValue)GameRules.getType(entry.key()).createRule(), var2);
            }
        }

        public MapCodec<SetGameRules> codec() {
            return CODEC;
        }

        public static <S, T extends GameRules.Value<T>> Entry<S, T> entry(GameRules.Key<T> var0, S var1) {
            return new Entry<S, T>(var0, var1);
        }

        public record Entry<S, T extends GameRules.Value<T>>(GameRules.Key<T> key, S value) {
            public static <S, T extends GameRules.Value<T>> Codec<Entry<S, T>> codec(Class<T> var0, Codec<S> var1) {
                return RecordCodecBuilder.create(var2 -> var2.group((App)GameRules.keyCodec(var0).fieldOf("rule").forGetter(Entry::key), (App)var1.fieldOf("value").forGetter(Entry::value)).apply((Applicative)var2, Entry::new));
            }
        }
    }

    public record TimeOfDay(int time) implements TestEnvironmentDefinition
    {
        public static final MapCodec<TimeOfDay> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("time").forGetter(TimeOfDay::time)).apply((Applicative)var0, TimeOfDay::new));

        @Override
        public void setup(ServerLevel var0) {
            var0.setDayTime(this.time);
        }

        public MapCodec<TimeOfDay> codec() {
            return CODEC;
        }
    }

    public record Weather(Type weather) implements TestEnvironmentDefinition
    {
        public static final MapCodec<Weather> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Type.CODEC.fieldOf("weather").forGetter(Weather::weather)).apply((Applicative)var0, Weather::new));

        @Override
        public void setup(ServerLevel var0) {
            this.weather.apply(var0);
        }

        @Override
        public void teardown(ServerLevel var0) {
            var0.resetWeatherCycle();
        }

        public MapCodec<Weather> codec() {
            return CODEC;
        }

        public static enum Type implements StringRepresentable
        {
            CLEAR("clear", 100000, 0, false, false),
            RAIN("rain", 0, 100000, true, false),
            THUNDER("thunder", 0, 100000, true, true);

            public static final Codec<Type> CODEC;
            private final String id;
            private final int clearTime;
            private final int rainTime;
            private final boolean raining;
            private final boolean thundering;

            private Type(String var2, int var3, int var4, boolean var5, boolean var6) {
                this.id = var2;
                this.clearTime = var3;
                this.rainTime = var4;
                this.raining = var5;
                this.thundering = var6;
            }

            void apply(ServerLevel var0) {
                var0.setWeatherParameters(this.clearTime, this.rainTime, this.raining, this.thundering);
            }

            @Override
            public String getSerializedName() {
                return this.id;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
            }
        }
    }

    public record Functions(Optional<ResourceLocation> setupFunction, Optional<ResourceLocation> teardownFunction) implements TestEnvironmentDefinition
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Functions> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceLocation.CODEC.optionalFieldOf("setup").forGetter(Functions::setupFunction), (App)ResourceLocation.CODEC.optionalFieldOf("teardown").forGetter(Functions::teardownFunction)).apply((Applicative)var0, Functions::new));

        @Override
        public void setup(ServerLevel var0) {
            this.setupFunction.ifPresent(var1 -> Functions.run(var0, var1));
        }

        @Override
        public void teardown(ServerLevel var0) {
            this.teardownFunction.ifPresent(var1 -> Functions.run(var0, var1));
        }

        private static void run(ServerLevel var0, ResourceLocation var1) {
            MinecraftServer var2 = var0.getServer();
            ServerFunctionManager var3 = var2.getFunctions();
            Optional<CommandFunction<CommandSourceStack>> var4 = var3.get(var1);
            if (var4.isPresent()) {
                CommandSourceStack var5 = var2.createCommandSourceStack().withPermission(2).withSuppressedOutput().withLevel(var0);
                var3.execute(var4.get(), var5);
            } else {
                LOGGER.error("Test Batch failed for non-existent function {}", (Object)var1);
            }
        }

        public MapCodec<Functions> codec() {
            return CODEC;
        }
    }
}

