/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class ByteArrayTag
implements CollectionTag {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<ByteArrayTag> TYPE = new TagType.VariableSize<ByteArrayTag>(){

        @Override
        public ByteArrayTag load(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            return new ByteArrayTag(1.readAccounted(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NbtAccounter nbtreadlimiter) throws IOException {
            return streamtagvisitor.visit(1.readAccounted(datainput, nbtreadlimiter));
        }

        private static byte[] readAccounted(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            nbtreadlimiter.accountBytes(24L);
            int i = datainput.readInt();
            nbtreadlimiter.accountBytes(1L, i);
            byte[] abyte = new byte[i];
            datainput.readFully(abyte);
            return abyte;
        }

        @Override
        public void skip(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 1);
        }

        @Override
        public String getName() {
            return "BYTE[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] data;

    public ByteArrayTag(byte[] abyte) {
        this.data = abyte;
    }

    @Override
    public void write(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.data.length);
        dataoutput.write(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 24 + 1 * this.data.length;
    }

    @Override
    public byte getId() {
        return 7;
    }

    public TagType<ByteArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor stringtagvisitor = new StringTagVisitor();
        stringtagvisitor.visitByteArray(this);
        return stringtagvisitor.build();
    }

    @Override
    public Tag copy() {
        byte[] abyte = new byte[this.data.length];
        System.arraycopy(this.data, 0, abyte, 0, this.data.length);
        return new ByteArrayTag(abyte);
    }

    public boolean equals(Object object) {
        return this == object ? true : object instanceof ByteArrayTag && Arrays.equals(this.data, ((ByteArrayTag)object).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor tagvisitor) {
        tagvisitor.visitByteArray(this);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public ByteTag get(int i) {
        return ByteTag.valueOf(this.data[i]);
    }

    @Override
    public boolean setTag(int i, Tag nbtbase) {
        if (nbtbase instanceof NumericTag) {
            NumericTag nbtnumber = (NumericTag)nbtbase;
            this.data[i] = nbtnumber.byteValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int i, Tag nbtbase) {
        if (nbtbase instanceof NumericTag) {
            NumericTag nbtnumber = (NumericTag)nbtbase;
            this.data = ArrayUtils.add((byte[])this.data, (int)i, (byte)nbtnumber.byteValue());
            return true;
        }
        return false;
    }

    @Override
    public ByteTag remove(int i) {
        byte b0 = this.data[i];
        this.data = ArrayUtils.remove((byte[])this.data, (int)i);
        return ByteTag.valueOf(b0);
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public Optional<byte[]> asByteArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.visit(this.data);
    }
}

