/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipPacketEncoderException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder<T extends PacketListener>
extends MessageToByteEncoder<Packet<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ProtocolInfo<T> protocolInfo;

    public PacketEncoder(ProtocolInfo<T> var0) {
        this.protocolInfo = var0;
    }

    protected void encode(ChannelHandlerContext var0, Packet<T> var1, ByteBuf var2) throws Exception {
        PacketType<Packet<T>> var3 = var1.type();
        try {
            this.protocolInfo.codec().encode(var2, var1);
            int var4 = var2.readableBytes();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(Connection.PACKET_SENT_MARKER, "OUT: [{}:{}] {} -> {} bytes", new Object[]{this.protocolInfo.id().id(), var3, var1.getClass().getName(), var4});
            }
            JvmProfiler.INSTANCE.onPacketSent(this.protocolInfo.id(), var3, var0.channel().remoteAddress(), var4);
        }
        catch (Throwable var4) {
            LOGGER.error("Error sending packet {}", var3, (Object)var4);
            if (var1.isSkippable()) {
                throw new SkipPacketEncoderException(var4);
            }
            throw var4;
        }
        finally {
            ProtocolSwapHandler.handleOutboundTerminalPacket(var0, var1);
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

