/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ID_VALUE = 254;
    static final ClassTreeIdRegistry ID_REGISTRY = new ClassTreeIdRegistry();
    private final SyncedDataHolder entity;
    private final DataItem<?>[] itemsById;
    private boolean isDirty;

    SynchedEntityData(SyncedDataHolder synceddataholder, DataItem<?>[] adatawatcher_item) {
        this.entity = synceddataholder;
        this.itemsById = adatawatcher_item;
    }

    public static <T> EntityDataAccessor<T> defineId(Class<? extends SyncedDataHolder> oclass, EntityDataSerializer<T> datawatcherserializer) {
        int i;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(oclass)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{oclass, oclass1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if ((i = ID_REGISTRY.define(oclass)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is 254)");
        }
        return datawatcherserializer.createAccessor(i);
    }

    private <T> DataItem<T> getItem(EntityDataAccessor<T> datawatcherobject) {
        return this.itemsById[datawatcherobject.id()];
    }

    public <T> T get(EntityDataAccessor<T> datawatcherobject) {
        return this.getItem(datawatcherobject).getValue();
    }

    public <T> void set(EntityDataAccessor<T> datawatcherobject, T t0) {
        this.set(datawatcherobject, t0, false);
    }

    public <T> void set(EntityDataAccessor<T> datawatcherobject, T t0, boolean flag) {
        DataItem<T> datawatcher_item = this.getItem(datawatcherobject);
        if (flag || ObjectUtils.notEqual(t0, datawatcher_item.getValue())) {
            datawatcher_item.setValue(t0);
            this.entity.onSyncedDataUpdated(datawatcherobject);
            datawatcher_item.setDirty(true);
            this.isDirty = true;
        }
    }

    public <T> void markDirty(EntityDataAccessor<T> datawatcherobject) {
        this.getItem(datawatcherobject).setDirty(true);
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public List<DataValue<?>> packDirty() {
        if (!this.isDirty) {
            return null;
        }
        this.isDirty = false;
        ArrayList list = new ArrayList();
        for (DataItem<?> datawatcher_item : this.itemsById) {
            if (!datawatcher_item.isDirty()) continue;
            datawatcher_item.setDirty(false);
            list.add(datawatcher_item.value());
        }
        return list;
    }

    @Nullable
    public List<DataValue<?>> getNonDefaultValues() {
        ArrayList list = null;
        for (DataItem<?> datawatcher_item : this.itemsById) {
            if (datawatcher_item.isSetToDefault()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(datawatcher_item.value());
        }
        return list;
    }

    public void assignValues(List<DataValue<?>> list) {
        for (DataValue<?> datawatcher_c : list) {
            DataItem<?> datawatcher_item = this.itemsById[datawatcher_c.id];
            this.assignValue(datawatcher_item, datawatcher_c);
            this.entity.onSyncedDataUpdated(datawatcher_item.getAccessor());
        }
        this.entity.onSyncedDataUpdated(list);
    }

    private <T> void assignValue(DataItem<T> datawatcher_item, DataValue<?> datawatcher_c) {
        if (!Objects.equals(datawatcher_c.serializer(), datawatcher_item.accessor.serializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", datawatcher_item.accessor.id(), this.entity, datawatcher_item.value, datawatcher_item.value.getClass(), datawatcher_c.value, datawatcher_c.value.getClass()));
        }
        datawatcher_item.setValue(datawatcher_c.value);
    }

    public static class DataItem<T> {
        final EntityDataAccessor<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public DataItem(EntityDataAccessor<T> datawatcherobject, T t0) {
            this.accessor = datawatcherobject;
            this.initialValue = t0;
            this.value = t0;
        }

        public EntityDataAccessor<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T t0) {
            this.value = t0;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean flag) {
            this.dirty = flag;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public DataValue<T> value() {
            return DataValue.create(this.accessor, this.value);
        }
    }

    public record DataValue<T>(int id, EntityDataSerializer<T> serializer, T value) {
        public static <T> DataValue<T> create(EntityDataAccessor<T> datawatcherobject, T t0) {
            EntityDataSerializer<T> datawatcherserializer = datawatcherobject.serializer();
            return new DataValue<T>(datawatcherobject.id(), datawatcherserializer, datawatcherserializer.copy(t0));
        }

        public void write(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i = EntityDataSerializers.getSerializedId(this.serializer);
            if (i < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.serializer));
            }
            registryfriendlybytebuf.writeByte(this.id);
            registryfriendlybytebuf.writeVarInt(i);
            this.serializer.codec().encode(registryfriendlybytebuf, this.value);
        }

        public static DataValue<?> read(RegistryFriendlyByteBuf registryfriendlybytebuf, int i) {
            int j = registryfriendlybytebuf.readVarInt();
            EntityDataSerializer<?> datawatcherserializer = EntityDataSerializers.getSerializer(j);
            if (datawatcherserializer == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            return DataValue.read(registryfriendlybytebuf, i, datawatcherserializer);
        }

        private static <T> DataValue<T> read(RegistryFriendlyByteBuf registryfriendlybytebuf, int i, EntityDataSerializer<T> datawatcherserializer) {
            return new DataValue<T>(i, datawatcherserializer, datawatcherserializer.codec().decode(registryfriendlybytebuf));
        }
    }

    public static class Builder {
        private final SyncedDataHolder entity;
        private final DataItem<?>[] itemsById;

        public Builder(SyncedDataHolder synceddataholder) {
            this.entity = synceddataholder;
            this.itemsById = new DataItem[ID_REGISTRY.getCount(synceddataholder.getClass())];
        }

        public <T> Builder define(EntityDataAccessor<T> datawatcherobject, T t0) {
            int i = datawatcherobject.id();
            if (i > this.itemsById.length) {
                throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is " + this.itemsById.length + ")");
            }
            if (this.itemsById[i] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + i + "!");
            }
            if (EntityDataSerializers.getSerializedId(datawatcherobject.serializer()) < 0) {
                String s = String.valueOf(datawatcherobject.serializer());
                throw new IllegalArgumentException("Unregistered serializer " + s + " for " + i + "!");
            }
            this.itemsById[datawatcherobject.id()] = new DataItem<T>(datawatcherobject, t0);
            return this;
        }

        public SynchedEntityData build() {
            for (int i = 0; i < this.itemsById.length; ++i) {
                if (this.itemsById[i] != null) continue;
                String s = String.valueOf(this.entity.getClass());
                throw new IllegalStateException("Entity " + s + " has not defined synched data value " + i);
            }
            return new SynchedEntityData(this.entity, this.itemsById);
        }
    }
}

