/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.get.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.get.unknown", var0));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.modify.expected_object", var0));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_VALUE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.data.modify.expected_value", var0));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_SUBSTRING = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.data.modify.invalid_substring", var0, var1));
    public static final List<Function<String, DataProvider>> ALL_PROVIDERS = ImmutableList.of(EntityDataAccessor.PROVIDER, BlockDataAccessor.PROVIDER, StorageDataAccessor.PROVIDER);
    public static final List<DataProvider> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(var0 -> (DataProvider)var0.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(var0 -> (DataProvider)var0.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandSourceStack> var0) {
        LiteralArgumentBuilder var1 = (LiteralArgumentBuilder)Commands.literal("data").requires(Commands.hasPermission(2));
        for (DataProvider var3 : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var1.then(var3.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("merge"), var12 -> var12.then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(var1 -> DataCommands.mergeData((CommandSourceStack)var1.getSource(), var3.access((CommandContext<CommandSourceStack>)var1), CompoundTagArgument.getCompoundTag(var1, "nbt"))))))).then(var3.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("get"), var12 -> var12.executes(var1 -> DataCommands.getData((CommandSourceStack)var1.getSource(), var3.access((CommandContext<CommandSourceStack>)var1))).then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).executes(var1 -> DataCommands.getData((CommandSourceStack)var1.getSource(), var3.access((CommandContext<CommandSourceStack>)var1), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var1, "path")))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(var1 -> DataCommands.getNumeric((CommandSourceStack)var1.getSource(), var3.access((CommandContext<CommandSourceStack>)var1), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var1, "path"), DoubleArgumentType.getDouble((CommandContext)var1, (String)"scale")))))))).then(var3.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("remove"), var12 -> var12.then(Commands.argument("path", NbtPathArgument.nbtPath()).executes(var1 -> DataCommands.removeData((CommandSourceStack)var1.getSource(), var3.access((CommandContext<CommandSourceStack>)var1), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var1, "path"))))))).then(DataCommands.decorateModification((var02, var12) -> var02.then(Commands.literal("insert").then(Commands.argument("index", IntegerArgumentType.integer()).then(var12.create((var0, var1, var2, var3) -> var2.insert(IntegerArgumentType.getInteger((CommandContext)var0, (String)"index"), var1, var3))))).then(Commands.literal("prepend").then(var12.create((var0, var1, var2, var3) -> var2.insert(0, var1, var3)))).then(Commands.literal("append").then(var12.create((var0, var1, var2, var3) -> var2.insert(-1, var1, var3)))).then(Commands.literal("set").then(var12.create((var0, var1, var2, var3) -> var2.set(var1, (Tag)Iterables.getLast((Iterable)var3))))).then(Commands.literal("merge").then(var12.create((var0, var1, var2, var3) -> {
                CompoundTag var4 = new CompoundTag();
                for (Tag var6 : var3) {
                    if (NbtPathArgument.NbtPath.isTooDeep(var6, 0)) {
                        throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
                    }
                    if (var6 instanceof CompoundTag) {
                        CompoundTag var7 = (CompoundTag)var6;
                        var4.merge(var7);
                        continue;
                    }
                    throw ERROR_EXPECTED_OBJECT.create((Object)var6);
                }
                List<Tag> var5 = var2.getOrCreate(var1, CompoundTag::new);
                int var6 = 0;
                for (Tag var8 : var5) {
                    if (!(var8 instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)var8);
                    }
                    CompoundTag var9 = (CompoundTag)var8;
                    CompoundTag var10 = var9.copy();
                    var9.merge(var4);
                    var6 += var10.equals(var9) ? 0 : 1;
                }
                return var6;
            })))));
        }
        var0.register((LiteralArgumentBuilder<CommandSourceStack>)var1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAsText(Tag var0) throws CommandSyntaxException {
        Tag tag = var0;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTag.class, PrimitiveTag.class}, (Object)tag2, n)) {
            case 0: {
                String string;
                StringTag stringTag = (StringTag)tag2;
                try {
                    String string2;
                    String var4;
                    string = var4 = (string2 = stringTag.value());
                    return string;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                PrimitiveTag var5 = (PrimitiveTag)tag2;
                String string = var5.toString();
                return string;
            }
        }
        throw ERROR_EXPECTED_VALUE.create((Object)var0);
    }

    private static List<Tag> stringifyTagList(List<Tag> var0, StringProcessor var1) throws CommandSyntaxException {
        ArrayList<Tag> var2 = new ArrayList<Tag>(var0.size());
        for (Tag var4 : var0) {
            String var5 = DataCommands.getAsText(var4);
            var2.add(StringTag.valueOf(var1.process(var5)));
        }
        return var2;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> var0) {
        LiteralArgumentBuilder<CommandSourceStack> var1 = Commands.literal("modify");
        for (DataProvider var3 : TARGET_PROVIDERS) {
            var3.wrap((ArgumentBuilder<CommandSourceStack, ?>)var1, var22 -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> var3 = Commands.argument("targetPath", NbtPathArgument.nbtPath());
                for (DataProvider var5 : SOURCE_PROVIDERS) {
                    var0.accept((ArgumentBuilder<CommandSourceStack, ?>)var3, var2 -> var5.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("from"), var32 -> var32.executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)var3, var5))).then(Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)var3, var5))))));
                    var0.accept((ArgumentBuilder<CommandSourceStack, ?>)var3, var2 -> var5.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("string"), var32 -> var32.executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.stringifyTagList(DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)var3, var5), var0 -> var0))).then(((RequiredArgumentBuilder)Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)var3, var5), var0 -> var0)))).then(((RequiredArgumentBuilder)Commands.argument("start", IntegerArgumentType.integer()).executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)var3, var5), var1 -> DataCommands.substring(var1, IntegerArgumentType.getInteger((CommandContext)var3, (String)"start")))))).then(Commands.argument("end", IntegerArgumentType.integer()).executes(var3 -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)var3, var3, var2, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)var3, var5), var1 -> DataCommands.substring(var1, IntegerArgumentType.getInteger((CommandContext)var3, (String)"start"), IntegerArgumentType.getInteger((CommandContext)var3, (String)"end"))))))))));
                }
                var0.accept((ArgumentBuilder<CommandSourceStack, ?>)var3, var1 -> Commands.literal("value").then(Commands.argument("value", NbtTagArgument.nbtTag()).executes(var2 -> {
                    List<Tag> var3 = Collections.singletonList(NbtTagArgument.getNbtTag(var2, "value"));
                    return DataCommands.manipulateData((CommandContext<CommandSourceStack>)var2, var3, var1, var3);
                })));
                return var22.then(var3);
            });
        }
        return var1;
    }

    private static String validatedSubstring(String var0, int var1, int var2) throws CommandSyntaxException {
        if (var1 < 0 || var2 > var0.length() || var1 > var2) {
            throw ERROR_INVALID_SUBSTRING.create((Object)var1, (Object)var2);
        }
        return var0.substring(var1, var2);
    }

    private static String substring(String var0, int var1, int var2) throws CommandSyntaxException {
        int var3 = var0.length();
        int var4 = DataCommands.getOffset(var1, var3);
        int var5 = DataCommands.getOffset(var2, var3);
        return DataCommands.validatedSubstring(var0, var4, var5);
    }

    private static String substring(String var0, int var1) throws CommandSyntaxException {
        int var2 = var0.length();
        return DataCommands.validatedSubstring(var0, DataCommands.getOffset(var1, var2), var2);
    }

    private static int getOffset(int var0, int var1) {
        return var0 >= 0 ? var0 : var1 + var0;
    }

    private static List<Tag> getSingletonSource(CommandContext<CommandSourceStack> var0, DataProvider var1) throws CommandSyntaxException {
        DataAccessor var2 = var1.access(var0);
        return Collections.singletonList(var2.getData());
    }

    private static List<Tag> resolveSourcePath(CommandContext<CommandSourceStack> var0, DataProvider var1) throws CommandSyntaxException {
        DataAccessor var2 = var1.access(var0);
        NbtPathArgument.NbtPath var3 = NbtPathArgument.getPath(var0, "sourcePath");
        return var3.get(var2.getData());
    }

    private static int manipulateData(CommandContext<CommandSourceStack> var0, DataProvider var1, DataManipulator var2, List<Tag> var3) throws CommandSyntaxException {
        DataAccessor var4 = var1.access(var0);
        NbtPathArgument.NbtPath var5 = NbtPathArgument.getPath(var0, "targetPath");
        CompoundTag var6 = var4.getData();
        int var7 = var2.modify(var0, var6, var5, var3);
        if (var7 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var4.setData(var6);
        ((CommandSourceStack)var0.getSource()).sendSuccess(() -> var4.getModifiedSuccess(), true);
        return var7;
    }

    private static int removeData(CommandSourceStack var0, DataAccessor var1, NbtPathArgument.NbtPath var2) throws CommandSyntaxException {
        CompoundTag var3 = var1.getData();
        int var4 = var2.remove(var3);
        if (var4 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var1.setData(var3);
        var0.sendSuccess(() -> var1.getModifiedSuccess(), true);
        return var4;
    }

    public static Tag getSingleTag(NbtPathArgument.NbtPath var0, DataAccessor var1) throws CommandSyntaxException {
        List<Tag> var2 = var0.get(var1.getData());
        Iterator var3 = var2.iterator();
        Tag var4 = (Tag)var3.next();
        if (var3.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return var4;
    }

    /*
     * Loose catch block
     */
    private static int getData(CommandSourceStack var0, DataAccessor var1, NbtPathArgument.NbtPath var2) throws CommandSyntaxException {
        Tag var3;
        Tag tag = var3 = DataCommands.getSingleTag(var2, var1);
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        int var4 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumericTag.class, CollectionTag.class, CompoundTag.class, StringTag.class, EndTag.class}, (Object)tag2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NumericTag var7 = (NumericTag)tag2;
                yield Mth.floor(var7.doubleValue());
            }
            case 1 -> {
                CollectionTag var8 = (CollectionTag)tag2;
                yield var8.size();
            }
            case 2 -> {
                CompoundTag var9 = (CompoundTag)tag2;
                yield var9.size();
            }
            case 3 -> {
                String var12_11;
                StringTag var10_10 = (StringTag)tag2;
                String var11 = var12_11 = var10_10.value();
                yield var11.length();
            }
            case 4 -> {
                EndTag var12 = (EndTag)tag2;
                throw ERROR_GET_NON_EXISTENT.create((Object)var2.toString());
            }
        };
        var0.sendSuccess(() -> var3.getPrintSuccess(var3), false);
        return var4;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static int getNumeric(CommandSourceStack var0, DataAccessor var1, NbtPathArgument.NbtPath var2, double var3) throws CommandSyntaxException {
        Tag var5 = DataCommands.getSingleTag(var2, var1);
        if (!(var5 instanceof NumericTag)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)var2.toString());
        }
        int var6 = Mth.floor(((NumericTag)var5).doubleValue() * var3);
        var0.sendSuccess(() -> var1.getPrintSuccess(var2, var3, var6), false);
        return var6;
    }

    private static int getData(CommandSourceStack var0, DataAccessor var1) throws CommandSyntaxException {
        CompoundTag var2 = var1.getData();
        var0.sendSuccess(() -> var1.getPrintSuccess(var2), false);
        return 1;
    }

    private static int mergeData(CommandSourceStack var0, DataAccessor var1, CompoundTag var2) throws CommandSyntaxException {
        CompoundTag var3 = var1.getData();
        if (NbtPathArgument.NbtPath.isTooDeep(var2, 0)) {
            throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
        }
        CompoundTag var4 = var3.copy().merge(var2);
        if (var3.equals(var4)) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        var1.setData(var4);
        var0.sendSuccess(() -> var1.getModifiedSuccess(), true);
        return 1;
    }

    public static interface DataProvider {
        public DataAccessor access(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }

    @FunctionalInterface
    static interface StringProcessor {
        public String process(String var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulator {
        public int modify(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> create(DataManipulator var1);
    }
}

