/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftGameRuleServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public GameRulesService.TypedRule updateGameRule(GameRulesService.UntypedRule var0, ClientInfo var1) {
        Object var5;
        GameRules.Value<?> var2 = this.getRuleValue(var0.key());
        String var3 = var2.serialize();
        if (var2 instanceof GameRules.BooleanValue) {
            var5 = (GameRules.BooleanValue)var2;
            var5.set(Boolean.parseBoolean(var0.value()), (MinecraftServer)this.server);
        } else if (var2 instanceof GameRules.IntegerValue) {
            GameRules.IntegerValue var4 = (GameRules.IntegerValue)var2;
            var4.set(Integer.parseInt(var0.value()), this.server);
        } else {
            throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + var0.key());
        }
        var5 = this.getTypedRule(var0.key(), var2);
        this.jsonrpcLogger.log(var1, "Game rule '{}' updated from '{}' to '{}'", ((GameRulesService.TypedRule)var5).key(), var3, ((GameRulesService.TypedRule)var5).value());
        this.server.onGameRuleChanged(var0.key(), var2);
        return var5;
    }

    @Override
    public <T extends GameRules.Value<T>> T getRule(GameRules.Key<T> var0) {
        return this.server.getGameRules().getRule(var0);
    }

    @Override
    public GameRulesService.TypedRule getTypedRule(String var0, GameRules.Value<?> var1) {
        GameRules.Value<?> value = var1;
        Objects.requireNonNull(value);
        GameRules.Value<?> value2 = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.BooleanValue.class, GameRules.IntegerValue.class}, value2, n)) {
            case 0 -> {
                GameRules.BooleanValue var4 = (GameRules.BooleanValue)value2;
                yield new GameRulesService.TypedRule(var0, String.valueOf(var4.get()), GameRulesService.RuleType.BOOL);
            }
            case 1 -> {
                GameRules.IntegerValue var5 = (GameRules.IntegerValue)value2;
                yield new GameRulesService.TypedRule(var0, String.valueOf(var5.get()), GameRulesService.RuleType.INT);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> getAvailableGameRules() {
        FeatureFlagSet var0 = this.server.getWorldData().getLevelSettings().getDataConfiguration().enabledFeatures();
        return GameRules.availableRules(var0);
    }

    private Optional<GameRules.Key<?>> getRuleKey(String var0) {
        Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> var12 = this.getAvailableGameRules();
        return var12.filter(var1 -> ((GameRules.Key)var1.getKey()).getId().equals(var0)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.Value<?> getRuleValue(String var0) {
        GameRules.Key<?> var1 = this.getRuleKey(var0).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + var0 + "' does not exist"));
        return this.server.getGameRules().getRule(var1);
    }
}

