/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.jsonrpc.IncomingRpcMethod;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.api.SchemaComponent;

public class DiscoveryService {
    public static DiscoverResponse discover(List<SchemaComponent> var0) {
        ArrayList<MethodInfo.Named> var12 = new ArrayList<MethodInfo.Named>(BuiltInRegistries.INCOMING_RPC_METHOD.size() + BuiltInRegistries.OUTGOING_RPC_METHOD.size());
        BuiltInRegistries.INCOMING_RPC_METHOD.listElements().forEach(var1 -> {
            if (((IncomingRpcMethod)var1.value()).attributes().discoverable()) {
                var12.add(((IncomingRpcMethod)var1.value()).info().named(var1.key().location()));
            }
        });
        BuiltInRegistries.OUTGOING_RPC_METHOD.listElements().forEach(var1 -> {
            if (((OutgoingRpcMethod)var1.value()).attributes().discoverable()) {
                var12.add(((OutgoingRpcMethod)var1.value()).info().named(var1.key().location()));
            }
        });
        HashMap<String, Schema> var2 = new HashMap<String, Schema>();
        for (SchemaComponent var4 : var0) {
            var2.put(var4.name(), var4.schema());
        }
        DiscoverInfo var3 = new DiscoverInfo("Minecraft Server JSON-RPC", "1.0.0");
        return new DiscoverResponse("1.3.2", var3, var12, new DiscoverComponents(var2));
    }

    public record DiscoverInfo(String title, String version) {
        public static final MapCodec<DiscoverInfo> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("title").forGetter(DiscoverInfo::title), (App)Codec.STRING.fieldOf("version").forGetter(DiscoverInfo::version)).apply((Applicative)var0, DiscoverInfo::new));
    }

    public record DiscoverResponse(String jsonRpcProtocolVersion, DiscoverInfo discoverInfo, List<MethodInfo.Named> methods, DiscoverComponents components) {
        public static final MapCodec<DiscoverResponse> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("openrpc").forGetter(DiscoverResponse::jsonRpcProtocolVersion), (App)DiscoverInfo.CODEC.codec().fieldOf("info").forGetter(DiscoverResponse::discoverInfo), (App)Codec.list(MethodInfo.Named.CODEC).fieldOf("methods").forGetter(DiscoverResponse::methods), (App)DiscoverComponents.CODEC.codec().fieldOf("components").forGetter(DiscoverResponse::components)).apply((Applicative)var0, DiscoverResponse::new));
    }

    public record DiscoverComponents(Map<String, Schema> schemas) {
        public static final MapCodec<DiscoverComponents> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.unboundedMap((Codec)Codec.STRING, Schema.CODEC).fieldOf("schemas").forGetter(DiscoverComponents::schemas)).apply((Applicative)var0, DiscoverComponents::new));
    }
}

