/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.jsonrpc.methods.PlayerService;
import net.minecraft.server.level.ServerPlayer;

public class ServerStateService {
    public static ServerState status(MinecraftApi var0) {
        if (!var0.serverStateService().isReady()) {
            return ServerState.NOT_STARTED;
        }
        return new ServerState(true, PlayerService.get(var0), ServerStatus.Version.current());
    }

    public static boolean save(MinecraftApi var0, boolean var1, ClientInfo var2) {
        return var0.serverStateService().saveEverything(true, var1, true, var2);
    }

    public static boolean stop(MinecraftApi var0, ClientInfo var1) {
        var0.submit(() -> var0.serverStateService().halt(false, var1));
        return true;
    }

    public static boolean systemMessage(MinecraftApi var0, SystemMessage var1, ClientInfo var2) {
        Component var3 = var1.message().asComponent().orElse(null);
        if (var3 == null) {
            return false;
        }
        if (var1.receivingPlayers().isPresent()) {
            if (var1.receivingPlayers().get().isEmpty()) {
                return false;
            }
            for (PlayerDto var5 : var1.receivingPlayers().get()) {
                ServerPlayer var6;
                if (var5.id().isPresent()) {
                    var6 = var0.playerListService().getPlayer(var5.id().get());
                } else {
                    if (!var5.name().isPresent()) continue;
                    var6 = var0.playerListService().getPlayerByName(var5.name().get());
                }
                if (var6 == null) continue;
                var6.sendSystemMessage(var3, var1.overlay());
            }
        } else {
            var0.serverStateService().broadcastSystemMessage(var3, var1.overlay(), var2);
        }
        return true;
    }

    public record ServerState(boolean started, List<PlayerDto> players, ServerStatus.Version version) {
        public static final Codec<ServerState> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.fieldOf("started").forGetter(ServerState::started), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("players", List.of()).forGetter(ServerState::players), (App)ServerStatus.Version.CODEC.fieldOf("version").forGetter(ServerState::version)).apply((Applicative)var0, ServerState::new));
        public static final ServerState NOT_STARTED = new ServerState(false, List.of(), ServerStatus.Version.current());
    }

    public record SystemMessage(Message message, boolean overlay, Optional<List<PlayerDto>> receivingPlayers) {
        public static final Codec<SystemMessage> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Message.CODEC.fieldOf("message").forGetter(SystemMessage::message), (App)Codec.BOOL.fieldOf("overlay").forGetter(SystemMessage::overlay), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("receivingPlayers").forGetter(SystemMessage::receivingPlayers)).apply((Applicative)var0, SystemMessage::new));
    }
}

