/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.apache.logging.log4j.LogManager;

public class ServerHandshakePacketListenerImpl
implements ServerHandshakePacketListener {
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final Component IGNORE_STATUS_REASON = Component.translatable("disconnect.ignoring_status_request");
    private final MinecraftServer server;
    private final Connection connection;

    public ServerHandshakePacketListenerImpl(MinecraftServer minecraftserver, Connection networkmanager) {
        this.server = minecraftserver;
        this.connection = networkmanager;
    }

    @Override
    public void handleIntention(ClientIntentionPacket packethandshakinginsetprotocol) {
        this.connection.hostname = packethandshakinginsetprotocol.hostName() + ":" + packethandshakinginsetprotocol.port();
        switch (packethandshakinginsetprotocol.intention()) {
            case LOGIN: {
                this.beginLogin(packethandshakinginsetprotocol, false);
                break;
            }
            case STATUS: {
                ServerStatus serverping = this.server.getStatus();
                this.connection.setupOutboundProtocol(StatusProtocols.CLIENTBOUND);
                if (this.server.repliesToStatus() && serverping != null) {
                    this.connection.setupInboundProtocol(StatusProtocols.SERVERBOUND, new ServerStatusPacketListenerImpl(serverping, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            case TRANSFER: {
                if (!this.server.acceptsTransfers()) {
                    this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
                    MutableComponent ichatbasecomponent = Component.translatable("multiplayer.disconnect.transfers_disabled");
                    this.connection.send(new ClientboundLoginDisconnectPacket(ichatbasecomponent));
                    this.connection.disconnect(ichatbasecomponent);
                    break;
                }
                this.beginLogin(packethandshakinginsetprotocol, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)packethandshakinginsetprotocol.intention()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLogin(ClientIntentionPacket packethandshakinginsetprotocol, boolean flag) {
        this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
        try {
            long currentTime = System.currentTimeMillis();
            long connectionThrottle = this.server.server.getConnectionThrottle();
            InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
            HashMap<InetAddress, Long> hashMap = throttleTracker;
            synchronized (hashMap) {
                if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                    throttleTracker.put(address, currentTime);
                    MutableComponent chatmessage = Component.literal("Connection throttled! Please wait before reconnecting.");
                    this.connection.send(new ClientboundLoginDisconnectPacket(chatmessage));
                    this.connection.disconnect(chatmessage);
                    return;
                }
                throttleTracker.put(address, currentTime);
                if (++throttleCounter > 200) {
                    throttleCounter = 0;
                    Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<InetAddress, Long> entry = iter.next();
                        if (entry.getValue() <= connectionThrottle) continue;
                        iter.remove();
                    }
                }
            }
        }
        catch (Throwable t) {
            LogManager.getLogger().debug("Failed to check connection throttle", t);
        }
        if (packethandshakinginsetprotocol.protocolVersion() != SharedConstants.getCurrentVersion().protocolVersion()) {
            MutableComponent ichatbasecomponent = packethandshakinginsetprotocol.protocolVersion() < 754 ? Component.translatable("multiplayer.disconnect.outdated_client", SharedConstants.getCurrentVersion().name()) : Component.translatable("multiplayer.disconnect.incompatible", SharedConstants.getCurrentVersion().name());
            this.connection.send(new ClientboundLoginDisconnectPacket(ichatbasecomponent));
            this.connection.disconnect(ichatbasecomponent);
        } else {
            this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, new ServerLoginPacketListenerImpl(this.server, this.connection, flag));
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

