/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    private final BuiltInMetadata metadata;
    private final Set<String> namespaces;
    private final List<Path> rootPaths;
    private final Map<PackType, List<Path>> pathsForType;

    VanillaPackResources(PackLocationInfo var0, BuiltInMetadata var1, Set<String> var2, List<Path> var3, Map<PackType, List<Path>> var4) {
        this.location = var0;
        this.metadata = var1;
        this.namespaces = var2;
        this.rootPaths = var3;
        this.pathsForType = var4;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var0) {
        FileUtil.validatePath(var0);
        List<String> var1 = List.of(var0);
        for (Path var3 : this.rootPaths) {
            Path var4 = FileUtil.resolvePath(var3, var1);
            if (!Files.exists(var4, new LinkOption[0]) || !PathPackResources.validatePath(var4)) continue;
            return IoSupplier.create(var4);
        }
        return null;
    }

    public void listRawPaths(PackType var0, ResourceLocation var12, Consumer<Path> var2) {
        FileUtil.decomposePath(var12.getPath()).ifSuccess(var3 -> {
            String var4 = var12.getNamespace();
            for (Path var6 : this.pathsForType.get((Object)var0)) {
                Path var7 = var6.resolve(var4);
                var2.accept(FileUtil.resolvePath(var7, var3));
            }
        }).ifError(var1 -> LOGGER.error("Invalid path {}: {}", (Object)var12, (Object)var1.message()));
    }

    @Override
    public void listResources(PackType var0, String var12, String var2, PackResources.ResourceOutput var32) {
        FileUtil.decomposePath(var2).ifSuccess(var3 -> {
            List<Path> var4 = this.pathsForType.get((Object)var0);
            int var5 = var4.size();
            if (var5 == 1) {
                VanillaPackResources.getResources(var32, var12, var4.get(0), var3);
            } else if (var5 > 1) {
                HashMap<ResourceLocation, IoSupplier<InputStream>> var6 = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                for (int var7 = 0; var7 < var5 - 1; ++var7) {
                    VanillaPackResources.getResources(var6::putIfAbsent, var12, var4.get(var7), var3);
                }
                Path var7 = var4.get(var5 - 1);
                if (var6.isEmpty()) {
                    VanillaPackResources.getResources(var32, var12, var7, var3);
                } else {
                    VanillaPackResources.getResources(var6::putIfAbsent, var12, var7, var3);
                    var6.forEach(var32);
                }
            }
        }).ifError(var1 -> LOGGER.error("Invalid path {}: {}", (Object)var2, (Object)var1.message()));
    }

    private static void getResources(PackResources.ResourceOutput var0, String var1, Path var2, List<String> var3) {
        Path var4 = var2.resolve(var1);
        PathPackResources.listPath(var1, var4, var3, var0);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(PackType var0, ResourceLocation var12) {
        return (IoSupplier)FileUtil.decomposePath(var12.getPath()).mapOrElse(var2 -> {
            String var3 = var12.getNamespace();
            for (Path var5 : this.pathsForType.get((Object)var0)) {
                Path var6 = FileUtil.resolvePath(var5.resolve(var3), var2);
                if (!Files.exists(var6, new LinkOption[0]) || !PathPackResources.validatePath(var6)) continue;
                return IoSupplier.create(var6);
            }
            return null;
        }, var1 -> {
            LOGGER.error("Invalid path {}: {}", (Object)var12, (Object)var1.message());
            return null;
        });
    }

    @Override
    public Set<String> getNamespaces(PackType var0) {
        return this.namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> var0) {
        IoSupplier<InputStream> var1 = this.getRootResource("pack.mcmeta");
        if (var1 == null) return this.metadata.get(var0);
        try (InputStream var2 = var1.get();){
            T var3 = AbstractPackResources.getMetadataFromStream(var0, var2, this.location);
            if (var3 == null) return this.metadata.get(var0);
            T t = var3;
            return t;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.metadata.get(var0);
    }

    @Override
    public PackLocationInfo location() {
        return this.location;
    }

    @Override
    public void close() {
    }

    public ResourceProvider asProvider() {
        return var02 -> Optional.ofNullable(this.getResource(PackType.CLIENT_RESOURCES, var02)).map(var0 -> new Resource(this, (IoSupplier<InputStream>)var0));
    }
}

