/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.LinkFSFileStore;
import net.minecraft.server.packs.linkfs.LinkFSPath;
import net.minecraft.server.packs.linkfs.LinkFSProvider;
import net.minecraft.server.packs.linkfs.PathContents;

public class LinkFileSystem
extends FileSystem {
    private static final Set<String> VIEWS = Set.of("basic");
    public static final String PATH_SEPARATOR = "/";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private final FileStore store;
    private final FileSystemProvider provider = new LinkFSProvider();
    private final LinkFSPath root;

    LinkFileSystem(String var0, DirectoryEntry var1) {
        this.store = new LinkFSFileStore(var0);
        this.root = LinkFileSystem.buildPath(var1, this, "", null);
    }

    private static LinkFSPath buildPath(DirectoryEntry var0, LinkFileSystem var1, String var2, @Nullable LinkFSPath var32) {
        Object2ObjectOpenHashMap var42 = new Object2ObjectOpenHashMap();
        LinkFSPath var5 = new LinkFSPath(var1, var2, var32, new PathContents.DirectoryContents((Map<String, LinkFSPath>)var42));
        var0.files.forEach((var3, var4) -> var42.put(var3, (Object)new LinkFSPath(var1, (String)var3, var5, new PathContents.FileContents((Path)var4))));
        var0.children.forEach((var3, var4) -> var42.put(var3, (Object)LinkFileSystem.buildPath(var4, var1, var3, var5)));
        var42.trim();
        return var5;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return PATH_SEPARATOR;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of(this.store);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return VIEWS;
    }

    @Override
    public Path getPath(String var0, String ... var1) {
        String var3;
        Stream<String> var2 = Stream.of(var0);
        if (var1.length > 0) {
            var2 = Stream.concat(var2, Stream.of(var1));
        }
        if ((var3 = var2.collect(Collectors.joining(PATH_SEPARATOR))).equals(PATH_SEPARATOR)) {
            return this.root;
        }
        if (var3.startsWith(PATH_SEPARATOR)) {
            LinkFSPath var4 = this.root;
            for (String var6 : PATH_SPLITTER.split((CharSequence)var3.substring(1))) {
                if (var6.isEmpty()) {
                    throw new IllegalArgumentException("Empty paths not allowed");
                }
                var4 = var4.resolveName(var6);
            }
            return var4;
        }
        LinkFSPath var4 = null;
        for (String var6 : PATH_SPLITTER.split((CharSequence)var3)) {
            if (var6.isEmpty()) {
                throw new IllegalArgumentException("Empty paths not allowed");
            }
            var4 = new LinkFSPath(this, var6, var4, PathContents.RELATIVE);
        }
        if (var4 == null) {
            throw new IllegalArgumentException("Empty paths not allowed");
        }
        return var4;
    }

    @Override
    public PathMatcher getPathMatcher(String var0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public FileStore store() {
        return this.store;
    }

    public LinkFSPath rootPath() {
        return this.root;
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class DirectoryEntry
    extends Record {
        final Map<String, DirectoryEntry> children;
        final Map<String, Path> files;

        public DirectoryEntry() {
            this(new HashMap<String, DirectoryEntry>(), new HashMap<String, Path>());
        }

        private DirectoryEntry(Map<String, DirectoryEntry> var0, Map<String, Path> var1) {
            this.children = var0;
            this.files = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DirectoryEntry.class, "children;files", "children", "files"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DirectoryEntry.class, "children;files", "children", "files"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DirectoryEntry.class, "children;files", "children", "files"}, this, var0);
        }

        public Map<String, DirectoryEntry> children() {
            return this.children;
        }

        public Map<String, Path> files() {
            return this.files;
        }
    }

    public static class Builder {
        private final DirectoryEntry root = new DirectoryEntry();

        public Builder put(List<String> var02, String var1, Path var2) {
            DirectoryEntry var3 = this.root;
            for (String var5 : var02) {
                var3 = var3.children.computeIfAbsent(var5, var0 -> new DirectoryEntry());
            }
            var3.files.put(var1, var2);
            return this;
        }

        public Builder put(List<String> var0, Path var1) {
            if (var0.isEmpty()) {
                throw new IllegalArgumentException("Path can't be empty");
            }
            int var2 = var0.size() - 1;
            return this.put(var0.subList(0, var2), var0.get(var2), var1);
        }

        public FileSystem build(String var0) {
            return new LinkFileSystem(var0, this.root);
        }
    }
}

