/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class MultiPackResourceManager
implements CloseableResourceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, FallbackResourceManager> namespacedManagers;
    private final List<PackResources> packs;

    public MultiPackResourceManager(PackType var0, List<PackResources> var12) {
        this.packs = List.copyOf(var12);
        HashMap<String, FallbackResourceManager> var2 = new HashMap<String, FallbackResourceManager>();
        List var3 = var12.stream().flatMap(var1 -> var1.getNamespaces(var0).stream()).distinct().toList();
        for (PackResources var5 : var12) {
            ResourceFilterSection var6 = this.getPackFilterSection(var5);
            Set<String> var7 = var5.getNamespaces(var0);
            Predicate<ResourceLocation> var8 = var6 != null ? var1 -> var6.isPathFiltered(var1.getPath()) : null;
            for (String var10 : var3) {
                boolean var122;
                boolean var11 = var7.contains(var10);
                boolean bl = var122 = var6 != null && var6.isNamespaceFiltered(var10);
                if (!var11 && !var122) continue;
                FallbackResourceManager var13 = (FallbackResourceManager)var2.get(var10);
                if (var13 == null) {
                    var13 = new FallbackResourceManager(var0, var10);
                    var2.put(var10, var13);
                }
                if (var11 && var122) {
                    var13.push(var5, var8);
                    continue;
                }
                if (var11) {
                    var13.push(var5);
                    continue;
                }
                var13.pushFilterOnly(var5.packId(), var8);
            }
        }
        this.namespacedManagers = var2;
    }

    @Nullable
    private ResourceFilterSection getPackFilterSection(PackResources var0) {
        try {
            return var0.getMetadataSection(ResourceFilterSection.TYPE);
        }
        catch (IOException var1) {
            LOGGER.error("Failed to get filter section from pack {}", (Object)var0.packId());
            return null;
        }
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespacedManagers.keySet();
    }

    @Override
    public Optional<Resource> getResource(ResourceLocation var0) {
        ResourceManager var1 = this.namespacedManagers.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResource(var0);
        }
        return Optional.empty();
    }

    @Override
    public List<Resource> getResourceStack(ResourceLocation var0) {
        ResourceManager var1 = this.namespacedManagers.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResourceStack(var0);
        }
        return List.of();
    }

    @Override
    public Map<ResourceLocation, Resource> listResources(String var0, Predicate<ResourceLocation> var1) {
        MultiPackResourceManager.checkTrailingDirectoryPath(var0);
        TreeMap<ResourceLocation, Resource> var2 = new TreeMap<ResourceLocation, Resource>();
        for (FallbackResourceManager var4 : this.namespacedManagers.values()) {
            var2.putAll(var4.listResources(var0, var1));
        }
        return var2;
    }

    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String var0, Predicate<ResourceLocation> var1) {
        MultiPackResourceManager.checkTrailingDirectoryPath(var0);
        TreeMap<ResourceLocation, List<Resource>> var2 = new TreeMap<ResourceLocation, List<Resource>>();
        for (FallbackResourceManager var4 : this.namespacedManagers.values()) {
            var2.putAll(var4.listResourceStacks(var0, var1));
        }
        return var2;
    }

    private static void checkTrailingDirectoryPath(String var0) {
        if (var0.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + var0);
        }
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.packs.stream();
    }

    @Override
    public void close() {
        this.packs.forEach(PackResources::close);
    }
}

