/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider EMPTY = var0 -> Optional.empty();

    public Optional<Resource> getResource(ResourceLocation var1);

    default public Resource getResourceOrThrow(ResourceLocation var0) throws FileNotFoundException {
        return this.getResource(var0).orElseThrow(() -> new FileNotFoundException(var0.toString()));
    }

    default public InputStream open(ResourceLocation var0) throws IOException {
        return this.getResourceOrThrow(var0).open();
    }

    default public BufferedReader openAsReader(ResourceLocation var0) throws IOException {
        return this.getResourceOrThrow(var0).openAsReader();
    }

    public static ResourceProvider fromMap(Map<ResourceLocation, Resource> var0) {
        return var1 -> Optional.ofNullable((Resource)var0.get(var1));
    }
}

