/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;

public record NameAndId(UUID id, String name) {
    public static final Codec<NameAndId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(NameAndId::id), (App)Codec.STRING.fieldOf("name").forGetter(NameAndId::name)).apply((Applicative)instance, NameAndId::new));

    public NameAndId(GameProfile gameprofile) {
        this(gameprofile.id(), gameprofile.name());
    }

    public NameAndId(com.mojang.authlib.yggdrasil.response.NameAndId com_mojang_authlib_yggdrasil_response_nameandid) {
        this(com_mojang_authlib_yggdrasil_response_nameandid.id(), com_mojang_authlib_yggdrasil_response_nameandid.name());
    }

    @Nullable
    public static NameAndId fromJson(JsonObject jsonobject) {
        if (jsonobject.has("uuid") && jsonobject.has("name")) {
            UUID uuid;
            String s = jsonobject.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s);
            }
            catch (Throwable throwable) {
                return null;
            }
            return new NameAndId(uuid, jsonobject.get("name").getAsString());
        }
        return null;
    }

    public void appendTo(JsonObject jsonobject) {
        jsonobject.addProperty("uuid", this.id().toString());
        jsonobject.addProperty("name", this.name());
    }

    public static NameAndId createOffline(String s) {
        UUID uuid = UUIDUtil.createOfflinePlayerUUID(s);
        return new NameAndId(uuid, s);
    }
}

