/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.waypoints;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.waypoints.WaypointManager;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class ServerWaypointManager
implements WaypointManager<WaypointTransmitter> {
    private final Set<WaypointTransmitter> waypoints = new HashSet<WaypointTransmitter>();
    private final Set<ServerPlayer> players = new HashSet<ServerPlayer>();
    private final Table<ServerPlayer, WaypointTransmitter, WaypointTransmitter.Connection> connections = HashBasedTable.create();

    @Override
    public void trackWaypoint(WaypointTransmitter waypointtransmitter) {
        this.waypoints.add(waypointtransmitter);
        for (ServerPlayer entityplayer : this.players) {
            this.createConnection(entityplayer, waypointtransmitter);
        }
    }

    @Override
    public void updateWaypoint(WaypointTransmitter waypointtransmitter) {
        if (this.waypoints.contains(waypointtransmitter)) {
            Map map = Tables.transpose(this.connections).row((Object)waypointtransmitter);
            Sets.SetView sets_setview = Sets.difference(this.players, map.keySet());
            for (Map.Entry map_entry : ImmutableSet.copyOf(map.entrySet())) {
                this.updateConnection((ServerPlayer)map_entry.getKey(), waypointtransmitter, (WaypointTransmitter.Connection)map_entry.getValue());
            }
            for (ServerPlayer entityplayer : sets_setview) {
                this.createConnection(entityplayer, waypointtransmitter);
            }
        }
    }

    @Override
    public void untrackWaypoint(WaypointTransmitter waypointtransmitter) {
        this.connections.column((Object)waypointtransmitter).forEach((entityplayer, waypointtransmitter_c) -> waypointtransmitter_c.disconnect());
        Tables.transpose(this.connections).row((Object)waypointtransmitter).clear();
        this.waypoints.remove(waypointtransmitter);
    }

    public void addPlayer(ServerPlayer entityplayer) {
        this.players.add(entityplayer);
        for (WaypointTransmitter waypointtransmitter : this.waypoints) {
            this.createConnection(entityplayer, waypointtransmitter);
        }
        if (entityplayer.isTransmittingWaypoint()) {
            this.trackWaypoint(entityplayer);
        }
    }

    public void updatePlayer(ServerPlayer entityplayer) {
        Map map = this.connections.row((Object)entityplayer);
        Sets.SetView sets_setview = Sets.difference(this.waypoints, map.keySet());
        for (Map.Entry map_entry : ImmutableSet.copyOf(map.entrySet())) {
            this.updateConnection(entityplayer, (WaypointTransmitter)map_entry.getKey(), (WaypointTransmitter.Connection)map_entry.getValue());
        }
        for (WaypointTransmitter waypointtransmitter : sets_setview) {
            this.createConnection(entityplayer, waypointtransmitter);
        }
    }

    public void removePlayer(ServerPlayer entityplayer) {
        this.connections.row((Object)entityplayer).values().removeIf(waypointtransmitter_c -> {
            waypointtransmitter_c.disconnect();
            return true;
        });
        this.untrackWaypoint(entityplayer);
        this.players.remove(entityplayer);
    }

    public void breakAllConnections() {
        this.connections.values().forEach(WaypointTransmitter.Connection::disconnect);
        this.connections.clear();
    }

    public void remakeConnections(WaypointTransmitter waypointtransmitter) {
        for (ServerPlayer entityplayer : this.players) {
            this.createConnection(entityplayer, waypointtransmitter);
        }
    }

    public Set<WaypointTransmitter> transmitters() {
        return this.waypoints;
    }

    private static boolean isLocatorBarEnabledFor(ServerPlayer entityplayer) {
        return entityplayer.level().getGameRules().getBoolean(GameRules.RULE_LOCATOR_BAR);
    }

    private void createConnection(ServerPlayer entityplayer, WaypointTransmitter waypointtransmitter) {
        if (entityplayer != waypointtransmitter && ServerWaypointManager.isLocatorBarEnabledFor(entityplayer)) {
            waypointtransmitter.makeWaypointConnectionWith(entityplayer).ifPresentOrElse(waypointtransmitter_c -> {
                this.connections.put((Object)entityplayer, (Object)waypointtransmitter, waypointtransmitter_c);
                waypointtransmitter_c.connect();
            }, () -> {
                WaypointTransmitter.Connection waypointtransmitter_c = (WaypointTransmitter.Connection)this.connections.remove((Object)entityplayer, (Object)waypointtransmitter);
                if (waypointtransmitter_c != null) {
                    waypointtransmitter_c.disconnect();
                }
            });
        }
    }

    private void updateConnection(ServerPlayer entityplayer, WaypointTransmitter waypointtransmitter, WaypointTransmitter.Connection waypointtransmitter_c) {
        if (entityplayer != waypointtransmitter && ServerWaypointManager.isLocatorBarEnabledFor(entityplayer)) {
            if (!waypointtransmitter_c.isBroken()) {
                waypointtransmitter_c.update();
            } else {
                waypointtransmitter.makeWaypointConnectionWith(entityplayer).ifPresentOrElse(waypointtransmitter_c1 -> {
                    waypointtransmitter_c1.connect();
                    this.connections.put((Object)entityplayer, (Object)waypointtransmitter, waypointtransmitter_c1);
                }, () -> {
                    waypointtransmitter_c.disconnect();
                    this.connections.remove((Object)entityplayer, (Object)waypointtransmitter);
                });
            }
        }
    }
}

