/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import net.minecraft.world.phys.Vec3;

public enum EntityAttachment {
    PASSENGER(Fallback.AT_HEIGHT),
    VEHICLE(Fallback.AT_FEET),
    NAME_TAG(Fallback.AT_HEIGHT),
    WARDEN_CHEST(Fallback.AT_CENTER);

    private final Fallback fallback;

    private EntityAttachment(Fallback var2) {
        this.fallback = var2;
    }

    public List<Vec3> createFallbackPoints(float var0, float var1) {
        return this.fallback.create(var0, var1);
    }

    public static interface Fallback {
        public static final List<Vec3> ZERO = List.of(Vec3.ZERO);
        public static final Fallback AT_FEET = (var0, var1) -> ZERO;
        public static final Fallback AT_HEIGHT = (var0, var1) -> List.of(new Vec3(0.0, var1, 0.0));
        public static final Fallback AT_CENTER = (var0, var1) -> List.of(new Vec3(0.0, (double)var1 / 2.0, 0.0));

        public List<Vec3> create(float var1, float var2);
    }
}

