/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class TradeWithVillager
extends Behavior<Villager> {
    private Set<Item> trades = ImmutableSet.of();

    public TradeWithVillager() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.INTERACTION_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        return BehaviorUtils.targetIsValid(var1.getBrain(), MemoryModuleType.INTERACTION_TARGET, EntityType.VILLAGER);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void start(ServerLevel var0, Villager var1, long var2) {
        Villager var4 = (Villager)var1.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        BehaviorUtils.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        this.trades = TradeWithVillager.figureOutWhatIAmWillingToTrade(var1, var4);
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        Villager var4 = (Villager)var1.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        if (var1.distanceToSqr(var4) > 5.0) {
            return;
        }
        BehaviorUtils.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        var1.gossip(var0, var4, var2);
        boolean var5 = var1.getVillagerData().profession().is(VillagerProfession.FARMER);
        if (var1.hasExcessFood() && (var5 || var4.wantsMoreFood())) {
            TradeWithVillager.throwHalfStack(var1, Villager.FOOD_POINTS.keySet(), var4);
        }
        if (var5 && var1.getInventory().countItem(Items.WHEAT) > Items.WHEAT.getDefaultMaxStackSize() / 2) {
            TradeWithVillager.throwHalfStack(var1, (Set<Item>)ImmutableSet.of((Object)Items.WHEAT), var4);
        }
        if (!this.trades.isEmpty() && var1.getInventory().hasAnyOf(this.trades)) {
            TradeWithVillager.throwHalfStack(var1, this.trades, var4);
        }
    }

    @Override
    protected void stop(ServerLevel var0, Villager var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
    }

    private static Set<Item> figureOutWhatIAmWillingToTrade(Villager var0, Villager var12) {
        ImmutableSet<Item> var2 = var12.getVillagerData().profession().value().requestedItems();
        ImmutableSet<Item> var3 = var0.getVillagerData().profession().value().requestedItems();
        return var2.stream().filter(var1 -> !var3.contains(var1)).collect(Collectors.toSet());
    }

    private static void throwHalfStack(Villager var0, Set<Item> var1, LivingEntity var2) {
        SimpleContainer var3 = var0.getInventory();
        ItemStack var4 = ItemStack.EMPTY;
        for (int var5 = 0; var5 < var3.getContainerSize(); ++var5) {
            int var8;
            Item var7;
            ItemStack var6 = var3.getItem(var5);
            if (var6.isEmpty() || !var1.contains(var7 = var6.getItem())) continue;
            if (var6.getCount() > var6.getMaxStackSize() / 2) {
                var8 = var6.getCount() / 2;
            } else {
                if (var6.getCount() <= 24) continue;
                var8 = var6.getCount() - 24;
            }
            var6.shrink(var8);
            var4 = new ItemStack(var7, var8);
            break;
        }
        if (!var4.isEmpty()) {
            BehaviorUtils.throwItem(var0, var4, var2.position());
        }
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

