/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class StrollThroughVillageGoal
extends Goal {
    private static final int DISTANCE_THRESHOLD = 10;
    private final PathfinderMob mob;
    private final int interval;
    @Nullable
    private BlockPos wantedPos;

    public StrollThroughVillageGoal(PathfinderMob var0, int var1) {
        this.mob = var0;
        this.interval = StrollThroughVillageGoal.reducedTickDelay(var1);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean canUse() {
        BlockPos var12;
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        if (this.mob.level().isBrightOutside()) {
            return false;
        }
        if (this.mob.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        ServerLevel var0 = (ServerLevel)this.mob.level();
        if (!var0.isCloseToVillage(var12 = this.mob.blockPosition(), 6)) {
            return false;
        }
        Vec3 var2 = LandRandomPos.getPos(this.mob, 15, 7, var1 -> -var0.sectionsToVillage(SectionPos.of(var1)));
        this.wantedPos = var2 == null ? null : BlockPos.containing(var2);
        return this.wantedPos != null;
    }

    @Override
    public boolean canContinueToUse() {
        return this.wantedPos != null && !this.mob.getNavigation().isDone() && this.mob.getNavigation().getTargetPos().equals(this.wantedPos);
    }

    @Override
    public void tick() {
        if (this.wantedPos == null) {
            return;
        }
        PathNavigation var0 = this.mob.getNavigation();
        if (var0.isDone() && !this.wantedPos.closerToCenterThan(this.mob.position(), 10.0)) {
            Vec3 var1 = Vec3.atBottomCenterOf(this.wantedPos);
            Vec3 var2 = this.mob.position();
            Vec3 var3 = var2.subtract(var1);
            var1 = var3.scale(0.4).add(var1);
            Vec3 var4 = var1.subtract(var2).normalize().scale(10.0).add(var2);
            BlockPos var5 = BlockPos.containing(var4);
            var5 = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var5);
            if (!var0.moveTo(var5.getX(), var5.getY(), var5.getZ(), 1.0)) {
                this.moveRandomly();
            }
        }
    }

    private void moveRandomly() {
        RandomSource var0 = this.mob.getRandom();
        BlockPos var1 = this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.blockPosition().offset(-8 + var0.nextInt(16), 0, -8 + var0.nextInt(16)));
        this.mob.getNavigation().moveTo(var1.getX(), var1.getY(), var1.getZ(), 1.0);
    }
}

