/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class TemptGoal
extends Goal {
    private static final TargetingConditions TEMPT_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private static final double DEFAULT_STOP_DISTANCE = 2.5;
    private final TargetingConditions targetingConditions;
    protected final Mob mob;
    protected final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected LivingEntity c;
    private int calmDown;
    private boolean isRunning;
    private final Predicate<ItemStack> items;
    private final boolean canScare;
    private final double stopDistance;

    public TemptGoal(PathfinderMob entitycreature, double d0, Predicate<ItemStack> predicate, boolean flag) {
        this((Mob)entitycreature, d0, predicate, flag, 2.5);
    }

    public TemptGoal(PathfinderMob entitycreature, double d0, Predicate<ItemStack> predicate, boolean flag, double d1) {
        this((Mob)entitycreature, d0, predicate, flag, d1);
    }

    TemptGoal(Mob entityinsentient, double d0, Predicate<ItemStack> predicate, boolean flag, double d1) {
        this.mob = entityinsentient;
        this.speedModifier = d0;
        this.items = predicate;
        this.canScare = flag;
        this.stopDistance = d1;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMPT_TARGETING.copy().selector((entityliving, worldserver) -> this.shouldFollow(entityliving));
    }

    @Override
    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.c = TemptGoal.getServerLevel(this.mob).getNearestPlayer(this.targetingConditions.range(this.mob.getAttributeValue(Attributes.TEMPT_RANGE)), this.mob);
        if (this.c != null) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this.mob, this.c, EntityTargetEvent.TargetReason.TEMPT);
            if (event.isCancelled()) {
                return false;
            }
            this.c = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
        }
        return this.c != null;
    }

    private boolean shouldFollow(LivingEntity entityliving) {
        return this.items.test(entityliving.getMainHandItem()) || this.items.test(entityliving.getOffhandItem());
    }

    @Override
    public boolean canContinueToUse() {
        if (this.canScare()) {
            if (this.mob.distanceToSqr(this.c) < 36.0) {
                if (this.c.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.c.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.c.getYRot() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.c.getX();
                this.py = this.c.getY();
                this.pz = this.c.getZ();
            }
            this.pRotX = this.c.getXRot();
            this.pRotY = this.c.getYRot();
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    @Override
    public void start() {
        this.px = this.c.getX();
        this.py = this.c.getY();
        this.pz = this.c.getZ();
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.c = null;
        this.stopNavigation();
        this.calmDown = TemptGoal.reducedTickDelay(100);
        this.isRunning = false;
    }

    @Override
    public void tick() {
        this.mob.getLookControl().setLookAt(this.c, this.mob.getMaxHeadYRot() + 20, this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr(this.c) < this.stopDistance * this.stopDistance) {
            this.stopNavigation();
        } else {
            this.navigateTowards(this.c);
        }
    }

    protected void stopNavigation() {
        this.mob.getNavigation().stop();
    }

    protected void navigateTowards(Player entityhuman) {
        this.navigateTowards((Entity)entityhuman);
    }

    protected void navigateTowards(Entity entity) {
        this.mob.getNavigation().moveTo(entity, this.speedModifier);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static class ForNonPathfinders
    extends TemptGoal {
        public ForNonPathfinders(Mob entityinsentient, double d0, Predicate<ItemStack> predicate, boolean flag, double d1) {
            super(entityinsentient, d0, predicate, flag, d1);
        }

        @Override
        protected void stopNavigation() {
            this.mob.getMoveControl().setWait();
        }

        @Override
        protected void navigateTowards(Player entityhuman) {
            Vec3 vec3d = entityhuman.getEyePosition().subtract(this.mob.position()).scale(this.mob.getRandom().nextDouble()).add(this.mob.position());
            this.mob.getMoveControl().setWantedPosition(vec3d.x, vec3d.y, vec3d.z, this.speedModifier);
        }
    }
}

