/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class AxolotlAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    public static final float TARGET_DETECTION_DISTANCE = 8.0f;

    @Override
    protected boolean isMatchingEntity(ServerLevel var0, LivingEntity var1, LivingEntity var2) {
        return this.isClose(var1, var2) && var2.isInWater() && (this.isHostileTarget(var2) || this.isHuntTarget(var1, var2)) && Sensor.isEntityAttackable(var0, var1, var2);
    }

    private boolean isHuntTarget(LivingEntity var0, LivingEntity var1) {
        return !var0.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && var1.getType().is(EntityTypeTags.AXOLOTL_HUNT_TARGETS);
    }

    private boolean isHostileTarget(LivingEntity var0) {
        return var0.getType().is(EntityTypeTags.AXOLOTL_ALWAYS_HOSTILES);
    }

    private boolean isClose(LivingEntity var0, LivingEntity var1) {
        return var1.distanceToSqr(var0) <= 64.0;
    }

    @Override
    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }
}

