/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class HurtBySensor
extends Sensor<LivingEntity> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY);
    }

    @Override
    protected void doTick(ServerLevel var0, LivingEntity var1) {
        Brain<?> var22 = var1.getBrain();
        DamageSource var3 = var1.getLastDamageSource();
        if (var3 != null) {
            var22.setMemory(MemoryModuleType.HURT_BY, var1.getLastDamageSource());
            Entity var4 = var3.getEntity();
            if (var4 instanceof LivingEntity) {
                var22.setMemory(MemoryModuleType.HURT_BY_ENTITY, (LivingEntity)var4);
            }
        } else {
            var22.eraseMemory(MemoryModuleType.HURT_BY);
        }
        var22.getMemory(MemoryModuleType.HURT_BY_ENTITY).ifPresent(var2 -> {
            if (!var2.isAlive() || var2.level() != var0) {
                var22.eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
            }
        });
    }
}

