/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DragonSittingScanningPhase
extends AbstractDragonSittingPhase {
    private static final int SITTING_SCANNING_IDLE_TICKS = 100;
    private static final int SITTING_ATTACK_Y_VIEW_RANGE = 10;
    private static final int SITTING_ATTACK_VIEW_RANGE = 20;
    private static final int SITTING_CHARGE_VIEW_RANGE = 150;
    private static final TargetingConditions CHARGE_TARGETING = TargetingConditions.forCombat().range(150.0);
    private final TargetingConditions scanTargeting = TargetingConditions.forCombat().range(20.0).selector((var1, var2) -> Math.abs(var1.getY() - var0.getY()) <= 10.0);
    private int scanningTime;

    public DragonSittingScanningPhase(EnderDragon var0) {
        super(var0);
    }

    @Override
    public void doServerTick(ServerLevel var0) {
        ++this.scanningTime;
        Player var1 = var0.getNearestPlayer(this.scanTargeting, this.dragon, this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var1 != null) {
            if (this.scanningTime > 25) {
                this.dragon.getPhaseManager().setPhase(EnderDragonPhase.SITTING_ATTACKING);
            } else {
                Vec3 var2 = new Vec3(var1.getX() - this.dragon.getX(), 0.0, var1.getZ() - this.dragon.getZ()).normalize();
                Vec3 var3 = new Vec3(Mth.sin(this.dragon.getYRot() * ((float)Math.PI / 180)), 0.0, -Mth.cos(this.dragon.getYRot() * ((float)Math.PI / 180))).normalize();
                float var4 = (float)var3.dot(var2);
                float var5 = (float)(Math.acos(var4) * 57.2957763671875) + 0.5f;
                if (var5 < 0.0f || var5 > 10.0f) {
                    float var12;
                    double var6 = var1.getX() - this.dragon.head.getX();
                    double var8 = var1.getZ() - this.dragon.head.getZ();
                    double var10 = Mth.clamp(Mth.wrapDegrees(180.0 - Mth.atan2(var6, var8) * 57.2957763671875 - (double)this.dragon.getYRot()), -100.0, 100.0);
                    this.dragon.yRotA *= 0.8f;
                    float var13 = var12 = (float)Math.sqrt(var6 * var6 + var8 * var8) + 1.0f;
                    if (var12 > 40.0f) {
                        var12 = 40.0f;
                    }
                    this.dragon.yRotA += (float)var10 * (0.7f / var12 / var13);
                    this.dragon.setYRot(this.dragon.getYRot() + this.dragon.yRotA);
                }
            }
        } else if (this.scanningTime >= 100) {
            var1 = var0.getNearestPlayer(CHARGE_TARGETING, this.dragon, this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
            this.dragon.getPhaseManager().setPhase(EnderDragonPhase.TAKEOFF);
            if (var1 != null) {
                this.dragon.getPhaseManager().setPhase(EnderDragonPhase.CHARGING_PLAYER);
                this.dragon.getPhaseManager().getPhase(EnderDragonPhase.CHARGING_PLAYER).setTarget(new Vec3(var1.getX(), var1.getY(), var1.getZ()));
            }
        }
    }

    @Override
    public void begin() {
        this.scanningTime = 0;
    }

    public EnderDragonPhase<DragonSittingScanningPhase> getPhase() {
        return EnderDragonPhase.SITTING_SCANNING;
    }
}

