/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class WitherBoss
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private static final int DEFAULT_INVULNERABLE_TICKS = 0;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    public final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final TargetingConditions.Selector LIVING_ENTITY_SELECTOR = (entityliving, worldserver) -> !entityliving.getType().is(EntityTypeTags.WITHER_FRIENDS) && entityliving.attackable();
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);

    public WitherBoss(EntityType<? extends WitherBoss> entitytypes, Level world) {
        super((EntityType<? extends Monster>)entitytypes, world);
        this.moveControl = new FlyingMoveControl(this, 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Override
    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation navigationflying = new FlyingPathNavigation(this, world);
        navigationflying.setCanOpenDoors(false);
        navigationflying.setCanFloat(true);
        return navigationflying;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new WitherDoNothingGoal());
        this.goalSelector.addGoal(2, new RangedAttackGoal(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new WaterAvoidingRandomFlyingGoal(this, 1.0));
        this.goalSelector.addGoal(6, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_TARGET_A, 0);
        datawatcher_a.define(DATA_TARGET_B, 0);
        datawatcher_a.define(DATA_TARGET_C, 0);
        datawatcher_a.define(DATA_ID_INV, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putInt("Invul", this.getInvulnerableTicks());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.setInvulnerableTicks(valueinput.getIntOr("Invul", 0));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomName(@Nullable Component ichatbasecomponent) {
        super.setCustomName(ichatbasecomponent);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.WITHER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        Entity entity;
        Vec3 vec3d = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide() && this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d0 = vec3d.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3(vec3d.x, d0, vec3d.z);
            Vec3 vec3d1 = new Vec3(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec3d1.horizontalDistanceSqr() > 9.0) {
                Vec3 vec3d2 = vec3d1.normalize();
                vec3d = vec3d.add(vec3d2.x * 0.3 - vec3d.x * 0.6, 0.0, vec3d2.z * 0.3 - vec3d.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3d);
        if (vec3d.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)Mth.atan2(vec3d.z, vec3d.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getAlternativeTarget(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.level().getEntity(k);
            }
            if (entity1 != null) {
                double d1 = this.getHeadX(j + 1);
                double d2 = this.getHeadY(j + 1);
                double d3 = this.getHeadZ(j + 1);
                double d4 = entity1.getX() - d1;
                double d5 = entity1.getEyeY() - d2;
                double d6 = entity1.getZ() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(Mth.atan2(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.atan2(d5, d7) * 57.2957763671875));
                this.xRotHeads[j] = this.rotlerp(this.xRotHeads[j], f1, 40.0f);
                this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], f, 10.0f);
                continue;
            }
            this.yRotHeads[j] = this.rotlerp(this.yRotHeads[j], this.yBodyRot, 10.0f);
        }
        boolean flag = this.isPowered();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.getHeadX(l);
            double d9 = this.getHeadY(l);
            double d10 = this.getHeadZ(l);
            float f2 = 0.3f * this.getScale();
            this.level().addParticle(ParticleTypes.SMOKE, d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.5f), d8 + this.random.nextGaussian() * (double)f2, d9 + this.random.nextGaussian() * (double)f2, d10 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float f3 = 3.3f * this.getScale();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * f3), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void customServerAiStep(ServerLevel worldserver) {
        if (this.getInvulnerableTicks() > 0) {
            int i = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)i / 220.0f);
            if (i <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    worldserver.explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.MOB);
                }
                if (!this.isSilent()) {
                    int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                    for (ServerPlayer player : MinecraftServer.getServer().getPlayerList().players) {
                        double deltaZ;
                        double deltaX = this.getX() - player.getX();
                        double distanceSquared = deltaX * deltaX + (deltaZ = this.getZ() - player.getZ()) * deltaZ;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                            player.connection.send(new ClientboundLevelEventPacket(1023, new BlockPos((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.connection.send(new ClientboundLevelEventPacket(1023, this.blockPosition(), 0, true));
                    }
                }
            }
            this.setInvulnerableTicks(i);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            super.customServerAiStep(worldserver);
            for (int j = 1; j < 3; ++j) {
                LivingEntity entityliving1;
                int i1;
                if (this.tickCount < this.nextHeadUpdate[j - 1]) continue;
                this.nextHeadUpdate[j - 1] = this.tickCount + 10 + this.random.nextInt(10);
                if (worldserver.getDifficulty() == Difficulty.NORMAL || worldserver.getDifficulty() == Difficulty.HARD) {
                    int k = j - 1;
                    int l = this.idleHeadUpdates[j - 1];
                    this.idleHeadUpdates[k] = this.idleHeadUpdates[j - 1] + 1;
                    if (l > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = Mth.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                        double d1 = Mth.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                        double d2 = Mth.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                        this.performRangedAttack(j + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[j - 1] = 0;
                    }
                }
                if ((i1 = this.getAlternativeTarget(j)) > 0) {
                    LivingEntity entityliving = (LivingEntity)worldserver.getEntity(i1);
                    if (entityliving != null && this.canAttack(entityliving) && this.distanceToSqr(entityliving) <= 900.0 && this.hasLineOfSight(entityliving)) {
                        this.performRangedAttack(j + 1, entityliving);
                        this.nextHeadUpdate[j - 1] = this.tickCount + 40 + this.random.nextInt(20);
                        this.idleHeadUpdates[j - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(j, 0);
                    continue;
                }
                List<LivingEntity> list = worldserver.getNearbyEntities(LivingEntity.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.random.nextInt(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.setAlternativeTarget(j, entityliving1.getId());
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    boolean flag = false;
                    int j1 = Mth.floor(this.getBbWidth() / 2.0f + 1.0f);
                    int k1 = Mth.floor(this.getBbHeight());
                    for (BlockPos blockposition : BlockPos.betweenClosed(this.getBlockX() - j1, this.getBlockY(), this.getBlockZ() - j1, this.getBlockX() + j1, this.getBlockY() + k1, this.getBlockZ() + j1)) {
                        BlockState iblockdata = worldserver.getBlockState(blockposition);
                        if (!WitherBoss.canDestroy(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.AIR.defaultBlockState())) continue;
                        flag = worldserver.destroyBlock(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        worldserver.levelEvent(null, 1022, this.blockPosition(), 0);
                    }
                }
            }
            if (this.tickCount % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroy(BlockState iblockdata) {
        return !iblockdata.isAir() && !iblockdata.is(BlockTags.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(BlockState iblockdata, Vec3 vec3d) {
    }

    @Override
    public void startSeenByPlayer(ServerPlayer entityplayer) {
        super.startSeenByPlayer(entityplayer);
        this.bossEvent.addPlayer(entityplayer);
    }

    @Override
    public void stopSeenByPlayer(ServerPlayer entityplayer) {
        super.stopSeenByPlayer(entityplayer);
        this.bossEvent.removePlayer(entityplayer);
    }

    private double getHeadX(int i) {
        if (i <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (i - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.cos(f);
        return this.getX() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int i) {
        float f = i <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f * this.getScale());
    }

    private double getHeadZ(int i) {
        if (i <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (i - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.sin(f);
        return this.getZ() + (double)f1 * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float f, float f1, float f2) {
        float f3 = Mth.wrapDegrees(f1 - f);
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    private void performRangedAttack(int i, LivingEntity entityliving) {
        this.performRangedAttack(i, entityliving.getX(), entityliving.getY() + (double)entityliving.getEyeHeight() * 0.5, entityliving.getZ(), i == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int i, double d0, double d1, double d2, boolean flag) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double d3 = this.getHeadX(i);
        double d4 = this.getHeadY(i);
        double d5 = this.getHeadZ(i);
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        Vec3 vec3d = new Vec3(d6, d7, d8);
        WitherSkull entitywitherskull = new WitherSkull(this.level(), this, vec3d.normalize());
        entitywitherskull.setOwner(this);
        if (flag) {
            entitywitherskull.setDangerous(true);
        }
        entitywitherskull.setPos(d3, d4, d5);
        this.level().addFreshEntity(entitywitherskull);
    }

    @Override
    public void performRangedAttack(LivingEntity entityliving, float f) {
        this.performRangedAttack(0, entityliving);
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableTo(worldserver, damagesource)) {
            return false;
        }
        if (!damagesource.is(DamageTypeTags.WITHER_IMMUNE_TO) && !(damagesource.getEntity() instanceof WitherBoss)) {
            Entity entity;
            if (this.getInvulnerableTicks() > 0 && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return false;
            }
            if (this.isPowered() && ((entity = damagesource.getDirectEntity()) instanceof AbstractArrow || entity instanceof WindCharge)) {
                return false;
            }
            Entity entity1 = damagesource.getEntity();
            if (entity1 != null && entity1.getType().is(EntityTypeTags.WITHER_FRIENDS)) {
                return false;
            }
            if (this.destroyBlocksTick <= 0) {
                this.destroyBlocksTick = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.hurtServer(worldserver, damagesource, f);
        }
        return false;
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel worldserver, DamageSource damagesource, boolean flag) {
        super.dropCustomDeathLoot(worldserver, damagesource, flag);
        ItemEntity entityitem = this.spawnAtLocation(worldserver, Items.NETHER_STAR);
        if (entityitem != null) {
            entityitem.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && !this.getType().isAllowedInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.6f).add(Attributes.FLYING_SPEED, 0.6f).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0);
    }

    public float[] getHeadYRots() {
        return this.yRotHeads;
    }

    public float[] getHeadXRots() {
        return this.xRotHeads;
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int i) {
        this.entityData.set(DATA_ID_INV, i);
    }

    public int getAlternativeTarget(int i) {
        return this.entityData.get(DATA_TARGETS.get(i));
    }

    public void setAlternativeTarget(int i, int j) {
        this.entityData.set(DATA_TARGETS.get(i), j);
    }

    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    protected boolean canRide(Entity entity) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return false;
    }

    @Override
    public boolean canBeAffected(MobEffectInstance mobeffect) {
        return mobeffect.is(MobEffects.WITHER) ? false : super.canBeAffected(mobeffect);
    }

    private class WitherDoNothingGoal
    extends Goal {
        public WitherDoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return WitherBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

