/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Mannequin
extends Avatar {
    protected static final EntityDataAccessor<ResolvableProfile> DATA_PROFILE = SynchedEntityData.defineId(Mannequin.class, EntityDataSerializers.RESOLVABLE_PROFILE);
    private static final EntityDataAccessor<Boolean> DATA_IMMOVABLE = SynchedEntityData.defineId(Mannequin.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<Component>> DATA_DESCRIPTION = SynchedEntityData.defineId(Mannequin.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final byte ALL_LAYERS = (byte)Arrays.stream(PlayerModelPart.values()).mapToInt(PlayerModelPart::getMask).reduce(0, (var0, var1) -> var0 | var1);
    public static final Set<Pose> VALID_POSES = Set.of(Pose.STANDING, Pose.CROUCHING, Pose.SWIMMING, Pose.FALL_FLYING, Pose.SLEEPING);
    public static final Codec<Pose> POSE_CODEC = Pose.CODEC.validate(var0 -> VALID_POSES.contains(var0) ? DataResult.success((Object)var0) : DataResult.error(() -> "Invalid pose: " + var0.getSerializedName()));
    private static final Codec<Byte> LAYERS_CODEC = PlayerModelPart.CODEC.listOf().xmap(var02 -> (byte)var02.stream().mapToInt(PlayerModelPart::getMask).reduce(ALL_LAYERS, (var0, var1) -> var0 & ~var1), var0 -> Arrays.stream(PlayerModelPart.values()).filter(var1 -> (var0 & var1.getMask()) == 0).toList());
    public static final ResolvableProfile DEFAULT_PROFILE = ResolvableProfile.Static.EMPTY;
    public static final Component DEFAULT_DESCRIPTION = Component.translatable("entity.minecraft.mannequin.label");
    protected static EntityType.EntityFactory<Mannequin> constructor = Mannequin::new;
    private static final String PROFILE_FIELD = "profile";
    private static final String HIDDEN_LAYERS_FIELD = "hidden_layers";
    private static final String MAIN_HAND_FIELD = "main_hand";
    private static final String POSE_FIELD = "pose";
    private static final String IMMOVABLE_FIELD = "immovable";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String HIDE_DESCRIPTION_FIELD = "hide_description";
    public Component description = DEFAULT_DESCRIPTION;
    public boolean hideDescription = false;

    public Mannequin(EntityType<Mannequin> var0, Level var1) {
        super((EntityType<? extends LivingEntity>)var0, var1);
        this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, ALL_LAYERS);
    }

    protected Mannequin(Level var0) {
        this(EntityType.MANNEQUIN, var0);
    }

    @Nullable
    public static Mannequin create(EntityType<Mannequin> var0, Level var1) {
        return constructor.create(var0, var1);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_PROFILE, DEFAULT_PROFILE);
        var0.define(DATA_IMMOVABLE, false);
        var0.define(DATA_DESCRIPTION, Optional.of(DEFAULT_DESCRIPTION));
    }

    public ResolvableProfile getProfile() {
        return this.entityData.get(DATA_PROFILE);
    }

    public void setProfile(ResolvableProfile var0) {
        this.entityData.set(DATA_PROFILE, var0);
    }

    public boolean getImmovable() {
        return this.entityData.get(DATA_IMMOVABLE);
    }

    public void setImmovable(boolean var0) {
        this.entityData.set(DATA_IMMOVABLE, var0);
    }

    @Nullable
    public Component getDescription() {
        return this.entityData.get(DATA_DESCRIPTION).orElse(null);
    }

    public void setDescription(Component var0) {
        this.description = var0;
        this.updateDescription();
    }

    public void setHideDescription(boolean var0) {
        this.hideDescription = var0;
        this.updateDescription();
    }

    private void updateDescription() {
        this.entityData.set(DATA_DESCRIPTION, this.hideDescription ? Optional.empty() : Optional.of(this.description));
    }

    @Override
    protected boolean isImmobile() {
        return this.getImmovable() || super.isImmobile();
    }

    @Override
    public boolean isEffectiveAi() {
        return !this.getImmovable() && super.isEffectiveAi();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store(PROFILE_FIELD, ResolvableProfile.CODEC, this.getProfile());
        var0.store(HIDDEN_LAYERS_FIELD, LAYERS_CODEC, (Byte)this.entityData.get(DATA_PLAYER_MODE_CUSTOMISATION));
        var0.store(MAIN_HAND_FIELD, HumanoidArm.CODEC, this.getMainArm());
        var0.store(POSE_FIELD, POSE_CODEC, this.getPose());
        var0.putBoolean(IMMOVABLE_FIELD, this.getImmovable());
        Component var1 = this.getDescription();
        if (var1 != null) {
            if (!var1.equals(DEFAULT_DESCRIPTION)) {
                var0.store(DESCRIPTION_FIELD, ComponentSerialization.CODEC, var1);
            }
        } else {
            var0.putBoolean(HIDE_DESCRIPTION_FIELD, true);
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        var0.read(PROFILE_FIELD, ResolvableProfile.CODEC).ifPresent(this::setProfile);
        this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, var0.read(HIDDEN_LAYERS_FIELD, LAYERS_CODEC).orElse(ALL_LAYERS));
        this.setMainArm(var0.read(MAIN_HAND_FIELD, HumanoidArm.CODEC).orElse(DEFAULT_MAIN_HAND));
        this.setPose(var0.read(POSE_FIELD, POSE_CODEC).orElse(Pose.STANDING));
        this.setImmovable(var0.getBooleanOr(IMMOVABLE_FIELD, false));
        this.setHideDescription(var0.getBooleanOr(HIDE_DESCRIPTION_FIELD, false));
        this.setDescription(var0.read(DESCRIPTION_FIELD, ComponentSerialization.CODEC).orElse(DEFAULT_DESCRIPTION));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.PROFILE) {
            return Mannequin.castComponentValue(var0, this.getProfile());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.PROFILE);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.PROFILE) {
            this.setProfile(Mannequin.castComponentValue(DataComponents.PROFILE, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }
}

