/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BreezeUtil {
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 50.0;

    public static Vec3 randomPointBehindTarget(LivingEntity var0, RandomSource var1) {
        int var2 = 90;
        float var3 = var0.yHeadRot + 180.0f + (float)var1.nextGaussian() * 90.0f / 2.0f;
        float var4 = Mth.lerp(var1.nextFloat(), 4.0f, 8.0f);
        Vec3 var5 = Vec3.directionFromRotation(0.0f, var3).scale(var4);
        return var0.position().add(var5);
    }

    public static boolean hasLineOfSight(Breeze var0, Vec3 var1) {
        Vec3 var2 = new Vec3(var0.getX(), var0.getY(), var0.getZ());
        if (var1.distanceTo(var2) > BreezeUtil.getMaxLineOfSightTestRange(var0)) {
            return false;
        }
        return var0.level().clip(new ClipContext(var2, var1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, var0)).getType() == HitResult.Type.MISS;
    }

    private static double getMaxLineOfSightTestRange(Breeze var0) {
        return Math.max(50.0, var0.getAttributeValue(Attributes.FOLLOW_RANGE));
    }
}

