/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        BlockPos blockposition;
        Level world = itemactioncontext.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (iblockdata.is(Blocks.END_PORTAL_FRAME) && !iblockdata.getValue(EndPortalFrameBlock.HAS_EYE).booleanValue()) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(EndPortalFrameBlock.HAS_EYE, true);
            Block.pushEntitiesUp(iblockdata, iblockdata1, world, blockposition);
            world.setBlock(blockposition, iblockdata1, 2);
            world.updateNeighbourForOutputSignal(blockposition, Blocks.END_PORTAL_FRAME);
            itemactioncontext.getItemInHand().shrink(1);
            world.levelEvent(1503, blockposition, 0);
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection = EndPortalFrameBlock.getOrCreatePortalShape().find(world, blockposition);
            if (shapedetector_shapedetectorcollection != null) {
                BlockPos blockposition1 = shapedetector_shapedetectorcollection.getFrontTopLeft().offset(-3, 0, -3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        BlockPos blockposition2 = blockposition1.offset(i, 0, j);
                        world.destroyBlock(blockposition2, true, null);
                        world.setBlock(blockposition2, Blocks.END_PORTAL.defaultBlockState(), 2);
                    }
                }
                world.globalLevelEvent(1038, blockposition1.offset(1, 0, 1), 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack itemstack, LivingEntity entityliving) {
        return 0;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        BlockHitResult movingobjectpositionblock = EnderEyeItem.getPlayerPOVHitResult(world, entityhuman, ClipContext.Fluid.NONE);
        if (movingobjectpositionblock.getType() == HitResult.Type.BLOCK && world.getBlockState(movingobjectpositionblock.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResult.PASS;
        }
        entityhuman.startUsingItem(enumhand);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = worldserver.findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, entityhuman.blockPosition(), 100, false);
            if (blockposition == null) {
                return InteractionResult.CONSUME;
            }
            EyeOfEnder entityendersignal = new EyeOfEnder(world, entityhuman.getX(), entityhuman.getY(0.5), entityhuman.getZ());
            entityendersignal.setItem(itemstack);
            entityendersignal.signalTo(Vec3.atLowerCornerOf(blockposition));
            world.gameEvent(GameEvent.PROJECTILE_SHOOT, entityendersignal.position(), GameEvent.Context.of(entityhuman));
            if (!world.addFreshEntity(entityendersignal)) {
                return InteractionResult.FAIL;
            }
            if (entityhuman instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                CriteriaTriggers.USED_ENDER_EYE.trigger(entityplayer, blockposition);
            }
            float f = Mth.lerp(world.random.nextFloat(), 0.33f, 0.5f);
            world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 1.0f, f);
            itemstack.consume(1, entityhuman);
            entityhuman.awardStat(Stats.ITEM_USED.get(this));
        }
        return InteractionResult.SUCCESS_SERVER;
    }
}

