/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;

public class StandingAndWallBlockItem
extends BlockItem {
    public final net.minecraft.world.level.block.Block wallBlock;
    private final Direction attachmentDirection;

    public StandingAndWallBlockItem(net.minecraft.world.level.block.Block block, net.minecraft.world.level.block.Block block1, Direction enumdirection, Item.Properties item_info) {
        super(block, item_info);
        this.wallBlock = block1;
        this.attachmentDirection = enumdirection;
    }

    protected boolean canPlace(LevelReader iworldreader, BlockState iblockdata, BlockPos blockposition) {
        return iblockdata.canSurvive(iworldreader, blockposition);
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = this.wallBlock.getStateForPlacement(blockactioncontext);
        BlockState iblockdata1 = null;
        Level iworldreader = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        for (Direction enumdirection : blockactioncontext.getNearestLookingDirections()) {
            BlockState iblockdata2;
            if (enumdirection == this.attachmentDirection.getOpposite()) continue;
            BlockState blockState = iblockdata2 = enumdirection == this.attachmentDirection ? this.getBlock().getStateForPlacement(blockactioncontext) : iblockdata;
            if (iblockdata2 == null || !this.canPlace(iworldreader, iblockdata2, blockposition)) continue;
            iblockdata1 = iblockdata2;
            break;
        }
        if (iblockdata1 != null) {
            boolean defaultReturn = iworldreader.isUnobstructed(iblockdata1, blockposition, CollisionContext.empty());
            Player player = blockactioncontext.getPlayer() instanceof ServerPlayer ? (Player)blockactioncontext.getPlayer().getBukkitEntity() : null;
            BlockCanBuildEvent event = new BlockCanBuildEvent((Block)CraftBlock.at(blockactioncontext.getLevel(), blockposition), player, (BlockData)CraftBlockData.fromData(iblockdata1), defaultReturn);
            blockactioncontext.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
            return event.isBuildable() ? iblockdata1 : null;
        }
        return null;
    }

    @Override
    public void registerBlocks(Map<net.minecraft.world.level.block.Block, Item> map, Item item) {
        super.registerBlocks(map, item);
        map.put(this.wallBlock, item);
    }
}

