/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents EMPTY = new BundleContents(List.of());
    public static final Codec<BundleContents> CODEC = ItemStack.CODEC.listOf().flatXmap(BundleContents::checkAndCreate, var0 -> DataResult.success(var0.items));
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BundleContents::new, var0 -> var0.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    private static final int NO_STACK_INDEX = -1;
    public static final int NO_SELECTED_ITEM_INDEX = -1;
    final List<ItemStack> items;
    final Fraction weight;
    final int selectedItem;

    BundleContents(List<ItemStack> var0, Fraction var1, int var2) {
        this.items = var0;
        this.weight = var1;
        this.selectedItem = var2;
    }

    private static DataResult<BundleContents> checkAndCreate(List<ItemStack> var0) {
        try {
            Fraction var1 = BundleContents.computeContentWeight(var0);
            return DataResult.success((Object)new BundleContents(var0, var1, -1));
        }
        catch (ArithmeticException var1) {
            return DataResult.error(() -> "Excessive total bundle weight");
        }
    }

    public BundleContents(List<ItemStack> var0) {
        this(var0, BundleContents.computeContentWeight(var0), -1);
    }

    private static Fraction computeContentWeight(List<ItemStack> var0) {
        Fraction var1 = Fraction.ZERO;
        for (ItemStack var3 : var0) {
            var1 = var1.add(BundleContents.getWeight(var3).multiplyBy(Fraction.getFraction((int)var3.getCount(), (int)1)));
        }
        return var1;
    }

    static Fraction getWeight(ItemStack var0) {
        BundleContents var1 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var1 != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add(var1.weight());
        }
        List<BeehiveBlockEntity.Occupant> var2 = var0.getOrDefault(DataComponents.BEES, Bees.EMPTY).bees();
        if (!var2.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)var0.getMaxStackSize());
    }

    public static boolean canItemBeInBundle(ItemStack var0) {
        return !var0.isEmpty() && var0.getItem().canFitInsideContainerItems();
    }

    public int getNumberOfItemsToShow() {
        int var0 = this.size();
        int var1 = var0 > 12 ? 11 : 12;
        int var2 = var0 % 4;
        int var3 = var2 == 0 ? 0 : 4 - var2;
        return Math.min(var0, var1 - var3);
    }

    public ItemStack getItemUnsafe(int var0) {
        return this.items.get(var0);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BundleContents) {
            BundleContents var1 = (BundleContents)var0;
            return this.weight.equals((Object)var1.weight) && ItemStack.listMatches(this.items, var1.items);
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "BundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;
        private int selectedItem;

        public Mutable(BundleContents var0) {
            this.items = new ArrayList<ItemStack>(var0.items);
            this.weight = var0.weight;
            this.selectedItem = var0.selectedItem;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            this.selectedItem = -1;
            return this;
        }

        private int findStackIndex(ItemStack var0) {
            if (!var0.isStackable()) {
                return -1;
            }
            for (int var1 = 0; var1 < this.items.size(); ++var1) {
                if (!ItemStack.isSameItemSameComponents(this.items.get(var1), var0)) continue;
                return var1;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack var0) {
            Fraction var1 = Fraction.ONE.subtract(this.weight);
            return Math.max(var1.divideBy(BundleContents.getWeight(var0)).intValue(), 0);
        }

        public int tryInsert(ItemStack var0) {
            if (!BundleContents.canItemBeInBundle(var0)) {
                return 0;
            }
            int var1 = Math.min(var0.getCount(), this.getMaxAmountToAdd(var0));
            if (var1 == 0) {
                return 0;
            }
            this.weight = this.weight.add(BundleContents.getWeight(var0).multiplyBy(Fraction.getFraction((int)var1, (int)1)));
            int var2 = this.findStackIndex(var0);
            if (var2 != -1) {
                ItemStack var3 = this.items.remove(var2);
                ItemStack var4 = var3.copyWithCount(var3.getCount() + var1);
                var0.shrink(var1);
                this.items.add(0, var4);
            } else {
                this.items.add(0, var0.split(var1));
            }
            return var1;
        }

        public int tryTransfer(Slot var0, Player var1) {
            ItemStack var2 = var0.getItem();
            int var3 = this.getMaxAmountToAdd(var2);
            return BundleContents.canItemBeInBundle(var2) ? this.tryInsert(var0.safeTake(var2.getCount(), var3, var1)) : 0;
        }

        public void toggleSelectedItem(int var0) {
            this.selectedItem = this.selectedItem == var0 || this.indexIsOutsideAllowedBounds(var0) ? -1 : var0;
        }

        private boolean indexIsOutsideAllowedBounds(int var0) {
            return var0 < 0 || var0 >= this.items.size();
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            int var0 = this.indexIsOutsideAllowedBounds(this.selectedItem) ? 0 : this.selectedItem;
            ItemStack var1 = this.items.remove(var0).copy();
            this.weight = this.weight.subtract(BundleContents.getWeight(var1).multiplyBy(Fraction.getFraction((int)var1.getCount(), (int)1)));
            this.toggleSelectedItem(-1);
            return var1;
        }

        public Fraction weight() {
            return this.weight;
        }

        public BundleContents toImmutable() {
            return new BundleContents(List.copyOf(this.items), this.weight, this.selectedItem);
        }
    }
}

