/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnchantmentHelper {
    public static int getItemEnchantmentLevel(Holder<Enchantment> var0, ItemStack var1) {
        ItemEnchantments var2 = var1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return var2.getLevel(var0);
    }

    public static ItemEnchantments updateEnchantments(ItemStack var0, Consumer<ItemEnchantments.Mutable> var1) {
        DataComponentType<ItemEnchantments> var2 = EnchantmentHelper.getComponentType(var0);
        ItemEnchantments var3 = var0.get(var2);
        if (var3 == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable var4 = new ItemEnchantments.Mutable(var3);
        var1.accept(var4);
        ItemEnchantments var5 = var4.toImmutable();
        var0.set(var2, var5);
        return var5;
    }

    public static boolean canStoreEnchantments(ItemStack var0) {
        return var0.has(EnchantmentHelper.getComponentType(var0));
    }

    public static void setEnchantments(ItemStack var0, ItemEnchantments var1) {
        var0.set(EnchantmentHelper.getComponentType(var0), var1);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack var0) {
        return var0.getOrDefault(EnchantmentHelper.getComponentType(var0), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack var0) {
        return var0.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack var0) {
        return !var0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !var0.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static int processDurabilityChange(ServerLevel var0, ItemStack var1, int var2) {
        MutableFloat var32 = new MutableFloat((float)var2);
        EnchantmentHelper.runIterationOnItem(var1, (var3, var4) -> ((Enchantment)var3.value()).modifyDurabilityChange(var0, var4, var1, var32));
        return var32.intValue();
    }

    public static int processAmmoUse(ServerLevel var0, ItemStack var1, ItemStack var2, int var32) {
        MutableFloat var42 = new MutableFloat((float)var32);
        EnchantmentHelper.runIterationOnItem(var1, (var3, var4) -> ((Enchantment)var3.value()).modifyAmmoCount(var0, var4, var2, var42));
        return var42.intValue();
    }

    public static int processBlockExperience(ServerLevel var0, ItemStack var1, int var2) {
        MutableFloat var32 = new MutableFloat((float)var2);
        EnchantmentHelper.runIterationOnItem(var1, (var3, var4) -> ((Enchantment)var3.value()).modifyBlockExperience(var0, var4, var1, var32));
        return var32.intValue();
    }

    public static int processMobExperience(ServerLevel var0, @Nullable Entity var1, Entity var2, int var32) {
        if (var1 instanceof LivingEntity) {
            LivingEntity var42 = (LivingEntity)var1;
            MutableFloat var52 = new MutableFloat((float)var32);
            EnchantmentHelper.runIterationOnEquipment(var42, (var3, var4, var5) -> ((Enchantment)var3.value()).modifyMobExperience(var0, var4, var5.itemStack(), var2, var52));
            return var52.intValue();
        }
        return var32;
    }

    public static ItemStack createBook(EnchantmentInstance var0) {
        ItemStack var1 = new ItemStack(Items.ENCHANTED_BOOK);
        var1.enchant(var0.enchantment(), var0.level());
        return var1;
    }

    private static void runIterationOnItem(ItemStack var0, EnchantmentVisitor var1) {
        ItemEnchantments var2 = var0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var2.entrySet()) {
            var1.accept((Holder)var4.getKey(), var4.getIntValue());
        }
    }

    private static void runIterationOnItem(ItemStack var0, EquipmentSlot var1, LivingEntity var2, EnchantmentInSlotVisitor var3) {
        if (var0.isEmpty()) {
            return;
        }
        ItemEnchantments var4 = var0.get(DataComponents.ENCHANTMENTS);
        if (var4 == null || var4.isEmpty()) {
            return;
        }
        EnchantedItemInUse var5 = new EnchantedItemInUse(var0, var1, var2);
        for (Object2IntMap.Entry<Holder<Enchantment>> var7 : var4.entrySet()) {
            Holder var8 = (Holder)var7.getKey();
            if (!((Enchantment)var8.value()).matchingSlot(var1)) continue;
            var3.accept(var8, var7.getIntValue(), var5);
        }
    }

    private static void runIterationOnEquipment(LivingEntity var0, EnchantmentInSlotVisitor var1) {
        for (EquipmentSlot var3 : EquipmentSlot.VALUES) {
            EnchantmentHelper.runIterationOnItem(var0.getItemBySlot(var3), var3, var0, var1);
        }
    }

    public static boolean isImmuneToDamage(ServerLevel var0, LivingEntity var1, DamageSource var2) {
        MutableBoolean var3 = new MutableBoolean();
        EnchantmentHelper.runIterationOnEquipment(var1, (var4, var5, var6) -> var3.setValue(var3.isTrue() || ((Enchantment)var4.value()).isImmuneToDamage(var0, var5, var1, var2)));
        return var3.isTrue();
    }

    public static float getDamageProtection(ServerLevel var0, LivingEntity var1, DamageSource var2) {
        MutableFloat var3 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnEquipment(var1, (var4, var5, var6) -> ((Enchantment)var4.value()).modifyDamageProtection(var0, var5, var6.itemStack(), var1, var2, var3));
        return var3.floatValue();
    }

    public static float modifyDamage(ServerLevel var0, ItemStack var1, Entity var2, DamageSource var3, float var4) {
        MutableFloat var52 = new MutableFloat(var4);
        EnchantmentHelper.runIterationOnItem(var1, (var5, var6) -> ((Enchantment)var5.value()).modifyDamage(var0, var6, var1, var2, var3, var52));
        return var52.floatValue();
    }

    public static float modifyFallBasedDamage(ServerLevel var0, ItemStack var1, Entity var2, DamageSource var3, float var4) {
        MutableFloat var52 = new MutableFloat(var4);
        EnchantmentHelper.runIterationOnItem(var1, (var5, var6) -> ((Enchantment)var5.value()).modifyFallBasedDamage(var0, var6, var1, var2, var3, var52));
        return var52.floatValue();
    }

    public static float modifyArmorEffectiveness(ServerLevel var0, ItemStack var1, Entity var2, DamageSource var3, float var4) {
        MutableFloat var52 = new MutableFloat(var4);
        EnchantmentHelper.runIterationOnItem(var1, (var5, var6) -> ((Enchantment)var5.value()).modifyArmorEffectivness(var0, var6, var1, var2, var3, var52));
        return var52.floatValue();
    }

    public static float modifyKnockback(ServerLevel var0, ItemStack var1, Entity var2, DamageSource var3, float var4) {
        MutableFloat var52 = new MutableFloat(var4);
        EnchantmentHelper.runIterationOnItem(var1, (var5, var6) -> ((Enchantment)var5.value()).modifyKnockback(var0, var6, var1, var2, var3, var52));
        return var52.floatValue();
    }

    public static void doPostAttackEffects(ServerLevel var0, Entity var1, DamageSource var2) {
        Entity entity = var2.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity var3 = (LivingEntity)entity;
            EnchantmentHelper.doPostAttackEffectsWithItemSource(var0, var1, var2, var3.getWeaponItem());
        } else {
            EnchantmentHelper.doPostAttackEffectsWithItemSource(var0, var1, var2, null);
        }
    }

    public static void doPostAttackEffectsWithItemSource(ServerLevel var0, Entity var1, DamageSource var2, @Nullable ItemStack var3) {
        EnchantmentHelper.doPostAttackEffectsWithItemSourceOnBreak(var0, var1, var2, var3, null);
    }

    public static void doPostAttackEffectsWithItemSourceOnBreak(ServerLevel var0, Entity var1, DamageSource var2, @Nullable ItemStack var32, @Nullable Consumer<Item> var42) {
        LivingEntity var52;
        if (var1 instanceof LivingEntity) {
            var52 = (LivingEntity)var1;
            EnchantmentHelper.runIterationOnEquipment(var52, (var3, var4, var5) -> ((Enchantment)var3.value()).doPostAttack(var0, var4, var5, EnchantmentTarget.VICTIM, var1, var2));
        }
        if (var32 != null) {
            Entity entity = var2.getEntity();
            if (entity instanceof LivingEntity) {
                var52 = (LivingEntity)entity;
                EnchantmentHelper.runIterationOnItem(var32, EquipmentSlot.MAINHAND, var52, (var3, var4, var5) -> ((Enchantment)var3.value()).doPostAttack(var0, var4, var5, EnchantmentTarget.ATTACKER, var1, var2));
            } else if (var42 != null) {
                EnchantedItemInUse var6 = new EnchantedItemInUse(var32, null, null, var42);
                EnchantmentHelper.runIterationOnItem(var32, (var4, var5) -> ((Enchantment)var4.value()).doPostAttack(var0, var5, var6, EnchantmentTarget.ATTACKER, var1, var2));
            }
        }
    }

    public static void runLocationChangedEffects(ServerLevel var0, LivingEntity var1) {
        EnchantmentHelper.runIterationOnEquipment(var1, (var2, var3, var4) -> ((Enchantment)var2.value()).runLocationChangedEffects(var0, var3, var4, var1));
    }

    public static void runLocationChangedEffects(ServerLevel var0, ItemStack var1, LivingEntity var22, EquipmentSlot var32) {
        EnchantmentHelper.runIterationOnItem(var1, var32, var22, (var2, var3, var4) -> ((Enchantment)var2.value()).runLocationChangedEffects(var0, var3, var4, var22));
    }

    public static void stopLocationBasedEffects(LivingEntity var0) {
        EnchantmentHelper.runIterationOnEquipment(var0, (var1, var2, var3) -> ((Enchantment)var1.value()).stopLocationBasedEffects(var2, var3, var0));
    }

    public static void stopLocationBasedEffects(ItemStack var0, LivingEntity var12, EquipmentSlot var22) {
        EnchantmentHelper.runIterationOnItem(var0, var22, var12, (var1, var2, var3) -> ((Enchantment)var1.value()).stopLocationBasedEffects(var2, var3, var12));
    }

    public static void tickEffects(ServerLevel var0, LivingEntity var1) {
        EnchantmentHelper.runIterationOnEquipment(var1, (var2, var3, var4) -> ((Enchantment)var2.value()).tick(var0, var3, var4, var1));
    }

    public static int getEnchantmentLevel(Holder<Enchantment> var0, LivingEntity var1) {
        Collection<ItemStack> var2 = var0.value().getSlotItems(var1).values();
        int var3 = 0;
        for (ItemStack var5 : var2) {
            int var6 = EnchantmentHelper.getItemEnchantmentLevel(var0, var5);
            if (var6 <= var3) continue;
            var3 = var6;
        }
        return var3;
    }

    public static int processProjectileCount(ServerLevel var0, ItemStack var1, Entity var2, int var3) {
        MutableFloat var42 = new MutableFloat((float)var3);
        EnchantmentHelper.runIterationOnItem(var1, (var4, var5) -> ((Enchantment)var4.value()).modifyProjectileCount(var0, var5, var1, var2, var42));
        return Math.max(0, var42.intValue());
    }

    public static float processProjectileSpread(ServerLevel var0, ItemStack var1, Entity var2, float var3) {
        MutableFloat var42 = new MutableFloat(var3);
        EnchantmentHelper.runIterationOnItem(var1, (var4, var5) -> ((Enchantment)var4.value()).modifyProjectileSpread(var0, var5, var1, var2, var42));
        return Math.max(0.0f, var42.floatValue());
    }

    public static int getPiercingCount(ServerLevel var0, ItemStack var1, ItemStack var2) {
        MutableFloat var32 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(var1, (var3, var4) -> ((Enchantment)var3.value()).modifyPiercingCount(var0, var4, var2, var32));
        return Math.max(0, var32.intValue());
    }

    public static void onProjectileSpawned(ServerLevel var0, ItemStack var1, Projectile var2, Consumer<Item> var3) {
        LivingEntity livingEntity;
        Object var5;
        Entity entity = var2.getOwner();
        if (entity instanceof LivingEntity) {
            var5 = (LivingEntity)entity;
            livingEntity = var5;
        } else {
            livingEntity = null;
        }
        LivingEntity var4 = livingEntity;
        var5 = new EnchantedItemInUse(var1, null, var4, var3);
        EnchantmentHelper.runIterationOnItem(var1, (arg_0, arg_1) -> EnchantmentHelper.lambda$onProjectileSpawned$21(var0, (EnchantedItemInUse)var5, var2, arg_0, arg_1));
    }

    public static void onHitBlock(ServerLevel var0, ItemStack var1, @Nullable LivingEntity var2, Entity var3, @Nullable EquipmentSlot var4, Vec3 var52, BlockState var62, Consumer<Item> var7) {
        EnchantedItemInUse var8 = new EnchantedItemInUse(var1, var4, var2, var7);
        EnchantmentHelper.runIterationOnItem(var1, (var5, var6) -> ((Enchantment)var5.value()).onHitBlock(var0, var6, var8, var3, var52, var62));
    }

    public static int modifyDurabilityToRepairFromXp(ServerLevel var0, ItemStack var1, int var2) {
        MutableFloat var32 = new MutableFloat((float)var2);
        EnchantmentHelper.runIterationOnItem(var1, (var3, var4) -> ((Enchantment)var3.value()).modifyDurabilityToRepairFromXp(var0, var4, var1, var32));
        return Math.max(0, var32.intValue());
    }

    public static float processEquipmentDropChance(ServerLevel var0, LivingEntity var1, DamageSource var2, float var3) {
        MutableFloat var4 = new MutableFloat(var3);
        RandomSource var52 = var1.getRandom();
        EnchantmentHelper.runIterationOnEquipment(var1, (var5, var6, var7) -> {
            LootContext var8 = Enchantment.damageContext(var0, var6, var1, var2);
            ((Enchantment)var5.value()).getEffects(EnchantmentEffectComponents.EQUIPMENT_DROPS).forEach(var4 -> {
                if (var4.enchanted() == EnchantmentTarget.VICTIM && var4.affected() == EnchantmentTarget.VICTIM && var4.matches(var8)) {
                    var4.setValue(((EnchantmentValueEffect)var4.effect()).process(var6, var52, var4.floatValue()));
                }
            });
        });
        Entity var62 = var2.getEntity();
        if (var62 instanceof LivingEntity) {
            LivingEntity var72 = (LivingEntity)var62;
            EnchantmentHelper.runIterationOnEquipment(var72, (var5, var6, var7) -> {
                LootContext var8 = Enchantment.damageContext(var0, var6, var1, var2);
                ((Enchantment)var5.value()).getEffects(EnchantmentEffectComponents.EQUIPMENT_DROPS).forEach(var4 -> {
                    if (var4.enchanted() == EnchantmentTarget.ATTACKER && var4.affected() == EnchantmentTarget.VICTIM && var4.matches(var8)) {
                        var4.setValue(((EnchantmentValueEffect)var4.effect()).process(var6, var52, var4.floatValue()));
                    }
                });
            });
        }
        return var4.floatValue();
    }

    public static void forEachModifier(ItemStack var0, EquipmentSlotGroup var1, BiConsumer<Holder<Attribute>, AttributeModifier> var22) {
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> ((Enchantment)var2.value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(var4 -> {
            if (((Enchantment)var2.value()).definition().slots().contains(var1)) {
                var22.accept(var4.attribute(), var4.getModifier(var3, var1));
            }
        }));
    }

    public static void forEachModifier(ItemStack var0, EquipmentSlot var1, BiConsumer<Holder<Attribute>, AttributeModifier> var22) {
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> ((Enchantment)var2.value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(var4 -> {
            if (((Enchantment)var2.value()).matchingSlot(var1)) {
                var22.accept(var4.attribute(), var4.getModifier(var3, var1));
            }
        }));
    }

    public static int getFishingLuckBonus(ServerLevel var0, ItemStack var1, Entity var2) {
        MutableFloat var3 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(var1, (var4, var5) -> ((Enchantment)var4.value()).modifyFishingLuckBonus(var0, var5, var1, var2, var3));
        return Math.max(0, var3.intValue());
    }

    public static float getFishingTimeReduction(ServerLevel var0, ItemStack var1, Entity var2) {
        MutableFloat var3 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(var1, (var4, var5) -> ((Enchantment)var4.value()).modifyFishingTimeReduction(var0, var5, var1, var2, var3));
        return Math.max(0.0f, var3.floatValue());
    }

    public static int getTridentReturnToOwnerAcceleration(ServerLevel var0, ItemStack var1, Entity var2) {
        MutableFloat var3 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(var1, (var4, var5) -> ((Enchantment)var4.value()).modifyTridentReturnToOwnerAcceleration(var0, var5, var1, var2, var3));
        return Math.max(0, var3.intValue());
    }

    public static float modifyCrossbowChargingTime(ItemStack var0, LivingEntity var1, float var22) {
        MutableFloat var32 = new MutableFloat(var22);
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> ((Enchantment)var2.value()).modifyCrossbowChargeTime(var1.getRandom(), var3, var32));
        return Math.max(0.0f, var32.floatValue());
    }

    public static float getTridentSpinAttackStrength(ItemStack var0, LivingEntity var1) {
        MutableFloat var22 = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> ((Enchantment)var2.value()).modifyTridentSpinAttackStrength(var1.getRandom(), var3, var22));
        return var22.floatValue();
    }

    public static boolean hasTag(ItemStack var0, TagKey<Enchantment> var1) {
        ItemEnchantments var2 = var0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var2.entrySet()) {
            Holder var5 = (Holder)var4.getKey();
            if (!var5.is(var1)) continue;
            return true;
        }
        return false;
    }

    public static boolean has(ItemStack var0, DataComponentType<?> var1) {
        MutableBoolean var22 = new MutableBoolean(false);
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> {
            if (((Enchantment)var2.value()).effects().has(var1)) {
                var22.setTrue();
            }
        });
        return var22.booleanValue();
    }

    public static <T> Optional<T> pickHighestLevel(ItemStack var0, DataComponentType<List<T>> var1) {
        Pair<List<T>, Integer> var2 = EnchantmentHelper.getHighestLevel(var0, var1);
        if (var2 != null) {
            List var3 = (List)var2.getFirst();
            int var4 = (Integer)var2.getSecond();
            return Optional.of(var3.get(Math.min(var4, var3.size()) - 1));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T> Pair<T, Integer> getHighestLevel(ItemStack var0, DataComponentType<T> var1) {
        MutableObject var22 = new MutableObject();
        EnchantmentHelper.runIterationOnItem(var0, (var2, var3) -> {
            Object var4;
            if ((var22.getValue() == null || (Integer)((Pair)var22.getValue()).getSecond() < var3) && (var4 = ((Enchantment)var2.value()).effects().get(var1)) != null) {
                var22.setValue((Object)Pair.of(var4, (Object)var3));
            }
        });
        return (Pair)var22.getValue();
    }

    public static Optional<EnchantedItemInUse> getRandomItemWith(DataComponentType<?> var0, LivingEntity var1, Predicate<ItemStack> var2) {
        ArrayList<EnchantedItemInUse> var3 = new ArrayList<EnchantedItemInUse>();
        for (EquipmentSlot var5 : EquipmentSlot.VALUES) {
            ItemStack var6 = var1.getItemBySlot(var5);
            if (!var2.test(var6)) continue;
            ItemEnchantments var7 = var6.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
            for (Object2IntMap.Entry<Holder<Enchantment>> var9 : var7.entrySet()) {
                Holder var10 = (Holder)var9.getKey();
                if (!((Enchantment)var10.value()).effects().has(var0) || !((Enchantment)var10.value()).matchingSlot(var5)) continue;
                var3.add(new EnchantedItemInUse(var6, var5, var1));
            }
        }
        return Util.getRandomSafe(var3, var1.getRandom());
    }

    public static int getEnchantmentCost(RandomSource var0, int var1, int var2, ItemStack var3) {
        Enchantable var4 = var3.get(DataComponents.ENCHANTABLE);
        if (var4 == null) {
            return 0;
        }
        if (var2 > 15) {
            var2 = 15;
        }
        int var5 = var0.nextInt(8) + 1 + (var2 >> 1) + var0.nextInt(var2 + 1);
        if (var1 == 0) {
            return Math.max(var5 / 3, 1);
        }
        if (var1 == 1) {
            return var5 * 2 / 3 + 1;
        }
        return Math.max(var5, var2 * 2);
    }

    public static ItemStack enchantItem(RandomSource var0, ItemStack var1, int var2, RegistryAccess var3, Optional<? extends HolderSet<Enchantment>> var4) {
        return EnchantmentHelper.enchantItem(var0, var1, var2, var4.map(HolderSet::stream).orElseGet(() -> var3.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(var0 -> var0)));
    }

    public static ItemStack enchantItem(RandomSource var0, ItemStack var1, int var2, Stream<Holder<Enchantment>> var3) {
        List<EnchantmentInstance> var4 = EnchantmentHelper.selectEnchantment(var0, var1, var2, var3);
        if (var1.is(Items.BOOK)) {
            var1 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance var6 : var4) {
            var1.enchant(var6.enchantment(), var6.level());
        }
        return var1;
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource var0, ItemStack var1, int var2, Stream<Holder<Enchantment>> var3) {
        ArrayList var4 = Lists.newArrayList();
        Enchantable var5 = var1.get(DataComponents.ENCHANTABLE);
        if (var5 == null) {
            return var4;
        }
        var2 += 1 + var0.nextInt(var5.value() / 4 + 1) + var0.nextInt(var5.value() / 4 + 1);
        float var6 = (var0.nextFloat() + var0.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> var7 = EnchantmentHelper.getAvailableEnchantmentResults(var2 = Mth.clamp(Math.round((float)var2 + (float)var2 * var6), 1, Integer.MAX_VALUE), var1, var3);
        if (!var7.isEmpty()) {
            WeightedRandom.getRandomItem(var0, var7, EnchantmentInstance::weight).ifPresent(var4::add);
            while (var0.nextInt(50) <= var2) {
                if (!var4.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments(var7, (EnchantmentInstance)Util.lastOf(var4));
                }
                if (var7.isEmpty()) break;
                WeightedRandom.getRandomItem(var0, var7, EnchantmentInstance::weight).ifPresent(var4::add);
                var2 /= 2;
            }
        }
        return var4;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> var0, EnchantmentInstance var12) {
        var0.removeIf(var1 -> !Enchantment.areCompatible(var12.enchantment(), var1.enchantment()));
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> var0, Holder<Enchantment> var1) {
        for (Holder<Enchantment> var3 : var0) {
            if (Enchantment.areCompatible(var3, var1)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int var0, ItemStack var1, Stream<Holder<Enchantment>> var22) {
        ArrayList var3 = Lists.newArrayList();
        boolean var4 = var1.is(Items.BOOK);
        var22.filter(var2 -> ((Enchantment)var2.value()).isPrimaryItem(var1) || var4).forEach(var2 -> {
            Enchantment var3 = (Enchantment)var2.value();
            for (int var4 = var3.getMaxLevel(); var4 >= var3.getMinLevel(); --var4) {
                if (var0 < var3.getMinCost(var4) || var0 > var3.getMaxCost(var4)) continue;
                var3.add(new EnchantmentInstance((Holder<Enchantment>)var2, var4));
                break;
            }
        });
        return var3;
    }

    public static void enchantItemFromProvider(ItemStack var0, RegistryAccess var1, ResourceKey<EnchantmentProvider> var2, DifficultyInstance var3, RandomSource var42) {
        EnchantmentProvider var5 = var1.lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).getValue(var2);
        if (var5 != null) {
            EnchantmentHelper.updateEnchantments(var0, var4 -> var5.enchant(var0, (ItemEnchantments.Mutable)var4, var42, var3));
        }
    }

    private static /* synthetic */ void lambda$onProjectileSpawned$21(ServerLevel var0, EnchantedItemInUse var1, Projectile var2, Holder var3, int var4) {
        ((Enchantment)var3.value()).onProjectileSpawned(var0, var4, var1, var2);
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Holder<Enchantment> var1, int var2);
    }

    @FunctionalInterface
    static interface EnchantmentInSlotVisitor {
        public void accept(Holder<Enchantment> var1, int var2, EnchantedItemInUse var3);
    }
}

