/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.phys.Vec3;

public record EnchantmentAttributeEffect(ResourceLocation id, Holder<Attribute> attribute, LevelBasedValue amount, AttributeModifier.Operation operation) implements EnchantmentLocationBasedEffect
{
    public static final MapCodec<EnchantmentAttributeEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(EnchantmentAttributeEffect::id), (App)Attribute.CODEC.fieldOf("attribute").forGetter(EnchantmentAttributeEffect::attribute), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(EnchantmentAttributeEffect::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(EnchantmentAttributeEffect::operation)).apply((Applicative)var0, EnchantmentAttributeEffect::new));

    private ResourceLocation idForSlot(StringRepresentable var0) {
        return this.id.withSuffix("/" + var0.getSerializedName());
    }

    public AttributeModifier getModifier(int var0, StringRepresentable var1) {
        return new AttributeModifier(this.idForSlot(var1), this.amount().calculate(var0), this.operation());
    }

    @Override
    public void onChangedBlock(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4, boolean var5) {
        if (var5 && var3 instanceof LivingEntity) {
            LivingEntity var6 = (LivingEntity)var3;
            var6.getAttributes().addTransientAttributeModifiers((Multimap<Holder<Attribute>, AttributeModifier>)this.makeAttributeMap(var1, var2.inSlot()));
        }
    }

    @Override
    public void onDeactivated(EnchantedItemInUse var0, Entity var1, Vec3 var2, int var3) {
        if (var1 instanceof LivingEntity) {
            LivingEntity var4 = (LivingEntity)var1;
            var4.getAttributes().removeAttributeModifiers((Multimap<Holder<Attribute>, AttributeModifier>)this.makeAttributeMap(var3, var0.inSlot()));
        }
    }

    private HashMultimap<Holder<Attribute>, AttributeModifier> makeAttributeMap(int var0, EquipmentSlot var1) {
        HashMultimap var2 = HashMultimap.create();
        var2.put(this.attribute, (Object)this.getModifier(var0, var1));
        return var2;
    }

    public MapCodec<EnchantmentAttributeEffect> codec() {
        return CODEC;
    }
}

