/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record PlaySoundEffect(Holder<SoundEvent> soundEvent, FloatProvider volume, FloatProvider pitch) implements EnchantmentEntityEffect
{
    public static final MapCodec<PlaySoundEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)SoundEvent.CODEC.fieldOf("sound").forGetter(PlaySoundEffect::soundEvent), (App)FloatProvider.codec(1.0E-5f, 10.0f).fieldOf("volume").forGetter(PlaySoundEffect::volume), (App)FloatProvider.codec(1.0E-5f, 2.0f).fieldOf("pitch").forGetter(PlaySoundEffect::pitch)).apply((Applicative)var0, PlaySoundEffect::new));

    @Override
    public void apply(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4) {
        RandomSource var5 = var3.getRandom();
        if (!var3.isSilent()) {
            var0.playSound(null, var4.x(), var4.y(), var4.z(), this.soundEvent, var3.getSoundSource(), this.volume.sample(var5), this.pitch.sample(var5));
        }
    }

    public MapCodec<PlaySoundEffect> codec() {
        return CODEC;
    }
}

