/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class NaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    public static final int INSCRIBED_SQUARE_SPAWN_DISTANCE_CHUNK = Mth.floor(8.0f / Mth.SQRT_OF_TWO);
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final MobCategory[] SPAWNING_CATEGORIES = (MobCategory[])Stream.of(MobCategory.values()).filter(enumcreaturetype -> enumcreaturetype != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState createState(int i, Iterable<Entity> iterable, ChunkGetter spawnercreature_b, LocalMobCapCalculator localmobcapcalculator) {
        PotentialCalculator spawnercreatureprobabilities = new PotentialCalculator();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : iterable) {
            MobCategory enumcreaturetype;
            Mob entityinsentient;
            if (entity instanceof Mob && ((entityinsentient = (Mob)entity).isPersistenceRequired() || entityinsentient.requiresCustomPersistence()) || (enumcreaturetype = entity.getType().getCategory()) == MobCategory.MISC) continue;
            BlockPos blockposition = entity.blockPosition();
            spawnercreature_b.query(ChunkPos.asLong(blockposition), chunk -> {
                MobSpawnSettings.MobSpawnCost biomesettingsmobs_b = NaturalSpawner.getRoughBiome(blockposition, chunk).getMobSettings().getMobSpawnCost(entity.getType());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.addCharge(entity.blockPosition(), biomesettingsmobs_b.charge());
                }
                if (entity instanceof Mob) {
                    localmobcapcalculator.addMob(chunk.getPos(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
            });
        }
        return new SpawnState(i, (Object2IntOpenHashMap<MobCategory>)object2intopenhashmap, spawnercreatureprobabilities, localmobcapcalculator);
    }

    static Biome getRoughBiome(BlockPos blockposition, ChunkAccess ichunkaccess) {
        return ichunkaccess.getNoiseBiome(QuartPos.fromBlock(blockposition.getX()), QuartPos.fromBlock(blockposition.getY()), QuartPos.fromBlock(blockposition.getZ())).value();
    }

    public static List<MobCategory> getFilteredSpawningCategories(SpawnState spawnercreature_d, boolean flag, boolean flag1, boolean flag2, ServerLevel worldserver) {
        LevelData worlddata = worldserver.getLevelData();
        ArrayList<MobCategory> list = new ArrayList<MobCategory>(SPAWNING_CATEGORIES.length);
        for (MobCategory enumcreaturetype : SPAWNING_CATEGORIES) {
            boolean spawnThisTick = true;
            int limit = enumcreaturetype.getMaxInstancesPerChunk();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.getGameTime() % worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = worldserver.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !flag && enumcreaturetype.isFriendly() || !flag1 && !enumcreaturetype.isFriendly() || !flag2 && enumcreaturetype.isPersistent() || !spawnercreature_d.canSpawnForCategoryGlobal(enumcreaturetype, limit)) continue;
            list.add(enumcreaturetype);
        }
        return list;
    }

    public static void spawnForChunk(ServerLevel worldserver, LevelChunk chunk, SpawnState spawnercreature_d, List<MobCategory> list) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("spawner");
        for (MobCategory enumcreaturetype : list) {
            if (!spawnercreature_d.canSpawnForCategoryLocal(enumcreaturetype, chunk.getPos())) continue;
            Objects.requireNonNull(spawnercreature_d);
            SpawnPredicate spawnercreature_c = spawnercreature_d::canSpawn;
            Objects.requireNonNull(spawnercreature_d);
            NaturalSpawner.spawnCategoryForChunk(enumcreaturetype, worldserver, chunk, spawnercreature_c, spawnercreature_d::afterSpawn);
        }
        gameprofilerfiller.pop();
    }

    public static void spawnCategoryForChunk(MobCategory enumcreaturetype, ServerLevel worldserver, LevelChunk chunk, SpawnPredicate spawnercreature_c, AfterSpawnCallback spawnercreature_a) {
        BlockPos blockposition = NaturalSpawner.getRandomPosWithin(worldserver, chunk);
        if (blockposition.getY() >= worldserver.getMinY() + 1) {
            NaturalSpawner.spawnCategoryForPosition(enumcreaturetype, worldserver, chunk, blockposition, spawnercreature_c, spawnercreature_a);
        }
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(MobCategory enumcreaturetype, ServerLevel worldserver, BlockPos blockposition) {
        NaturalSpawner.spawnCategoryForPosition(enumcreaturetype, worldserver, worldserver.getChunk(blockposition), blockposition, (entitytypes, blockposition1, ichunkaccess) -> true, (entityinsentient, ichunkaccess) -> {});
    }

    public static void spawnCategoryForPosition(MobCategory enumcreaturetype, ServerLevel worldserver, ChunkAccess ichunkaccess, BlockPos blockposition, SpawnPredicate spawnercreature_c, AfterSpawnCallback spawnercreature_a) {
        StructureManager structuremanager = worldserver.structureManager();
        ChunkGenerator chunkgenerator = worldserver.getChunkSource().getGenerator();
        int i = blockposition.getY();
        BlockState iblockdata = ichunkaccess.getBlockState(blockposition);
        if (!iblockdata.isRedstoneConductor(ichunkaccess, blockposition)) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            int j = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int l = blockposition.getX();
                int i1 = blockposition.getZ();
                int j1 = 6;
                MobSpawnSettings.SpawnerData biomesettingsmobs_c = null;
                SpawnGroupData groupdataentity = null;
                int k1 = Mth.ceil(worldserver.random.nextFloat() * 4.0f);
                int l1 = 0;
                for (int i2 = 0; i2 < k1; ++i2) {
                    double d2;
                    blockposition_mutableblockposition.set(l += worldserver.random.nextInt(6) - worldserver.random.nextInt(6), i, i1 += worldserver.random.nextInt(6) - worldserver.random.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    Player entityhuman = worldserver.getNearestPlayer(d0, (double)i, d1, -1.0, false);
                    if (entityhuman == null || !NaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(worldserver, ichunkaccess, blockposition_mutableblockposition, d2 = entityhuman.distanceToSqr(d0, i, d1))) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = NaturalSpawner.getRandomSpawnMobAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, worldserver.random, blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        k1 = biomesettingsmobs_c.minCount() + worldserver.random.nextInt(1 + biomesettingsmobs_c.maxCount() - biomesettingsmobs_c.minCount());
                    }
                    if (!NaturalSpawner.isValidSpawnPostitionForType(worldserver, enumcreaturetype, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2) || !spawnercreature_c.test(biomesettingsmobs_c.type(), blockposition_mutableblockposition, ichunkaccess)) continue;
                    Mob entityinsentient = NaturalSpawner.getMobForSpawn(worldserver, biomesettingsmobs_c.type());
                    if (entityinsentient == null) {
                        return;
                    }
                    entityinsentient.snapTo(d0, i, d1, worldserver.random.nextFloat() * 360.0f, 0.0f);
                    if (!NaturalSpawner.isValidPositionForMob(worldserver, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entityinsentient.blockPosition()), EntitySpawnReason.NATURAL, groupdataentity);
                    worldserver.addFreshEntityWithPassengers(entityinsentient, entityinsentient instanceof Ocelot && !((Ageable)entityinsentient.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.isRemoved()) {
                        ++j;
                        ++l1;
                        spawnercreature_a.run(entityinsentient, ichunkaccess);
                    }
                    if (j >= entityinsentient.getMaxSpawnClusterSize()) {
                        return;
                    }
                    if (entityinsentient.isMaxGroupSizeReached(l1)) continue block0;
                }
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel worldserver, ChunkAccess ichunkaccess, BlockPos.MutableBlockPos blockposition_mutableblockposition, double d0) {
        if (d0 <= 576.0) {
            return false;
        }
        LevelData.RespawnData worlddata_a = worldserver.getRespawnData();
        if (worlddata_a.dimension() == worldserver.dimension() && worlddata_a.pos().closerToCenterThan(new Vec3((double)blockposition_mutableblockposition.getX() + 0.5, blockposition_mutableblockposition.getY(), (double)blockposition_mutableblockposition.getZ() + 0.5), 24.0)) {
            return false;
        }
        ChunkPos chunkcoordintpair = new ChunkPos(blockposition_mutableblockposition);
        return Objects.equals(chunkcoordintpair, ichunkaccess.getPos()) || worldserver.canSpawnEntitiesInChunk(chunkcoordintpair);
    }

    private static boolean isValidSpawnPostitionForType(ServerLevel worldserver, MobCategory enumcreaturetype, StructureManager structuremanager, ChunkGenerator chunkgenerator, MobSpawnSettings.SpawnerData biomesettingsmobs_c, BlockPos.MutableBlockPos blockposition_mutableblockposition, double d0) {
        EntityType<?> entitytypes = biomesettingsmobs_c.type();
        return entitytypes.getCategory() == MobCategory.MISC ? false : (!entitytypes.canSpawnFarFromPlayer() && d0 > (double)(entitytypes.getCategory().getDespawnDistance() * entitytypes.getCategory().getDespawnDistance()) ? false : (entitytypes.canSummon() && NaturalSpawner.canSpawnMobAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, biomesettingsmobs_c, blockposition_mutableblockposition) ? (!SpawnPlacements.isSpawnPositionOk(entitytypes, worldserver, blockposition_mutableblockposition) ? false : (!SpawnPlacements.checkSpawnRules(entitytypes, worldserver, EntitySpawnReason.NATURAL, blockposition_mutableblockposition, worldserver.random) ? false : worldserver.noCollision(entitytypes.getSpawnAABB((double)blockposition_mutableblockposition.getX() + 0.5, blockposition_mutableblockposition.getY(), (double)blockposition_mutableblockposition.getZ() + 0.5)))) : false));
    }

    @Nullable
    private static Mob getMobForSpawn(ServerLevel worldserver, EntityType<?> entitytypes) {
        try {
            Object entity = entitytypes.create(worldserver, EntitySpawnReason.NATURAL);
            if (entity instanceof Mob) {
                Mob entityinsentient = (Mob)entity;
                return entityinsentient;
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entitytypes));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
        }
        return null;
    }

    private static boolean isValidPositionForMob(ServerLevel worldserver, Mob entityinsentient, double d0) {
        return d0 > (double)(entityinsentient.getType().getCategory().getDespawnDistance() * entityinsentient.getType().getCategory().getDespawnDistance()) && entityinsentient.removeWhenFarAway(d0) ? false : entityinsentient.checkSpawnRules(worldserver, EntitySpawnReason.NATURAL) && entityinsentient.checkSpawnObstruction(worldserver);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, MobCategory enumcreaturetype, RandomSource randomsource, BlockPos blockposition) {
        Holder<Biome> holder = worldserver.getBiome(blockposition);
        return enumcreaturetype == MobCategory.WATER_AMBIENT && holder.is(BiomeTags.REDUCED_WATER_AMBIENT_SPAWNS) && randomsource.nextFloat() < 0.98f ? Optional.empty() : NaturalSpawner.mobsAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, holder).getRandom(randomsource);
    }

    private static boolean canSpawnMobAt(ServerLevel worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, MobCategory enumcreaturetype, MobSpawnSettings.SpawnerData biomesettingsmobs_c, BlockPos blockposition) {
        return NaturalSpawner.mobsAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, null).contains(biomesettingsmobs_c);
    }

    private static WeightedList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, MobCategory enumcreaturetype, BlockPos blockposition, @Nullable Holder<Biome> holder) {
        return NaturalSpawner.isInNetherFortressBounds(blockposition, worldserver, enumcreaturetype, structuremanager) ? NetherFortressStructure.FORTRESS_ENEMIES : chunkgenerator.getMobsAt(holder != null ? holder : worldserver.getBiome(blockposition), structuremanager, enumcreaturetype, blockposition);
    }

    public static boolean isInNetherFortressBounds(BlockPos blockposition, ServerLevel worldserver, MobCategory enumcreaturetype, StructureManager structuremanager) {
        if (enumcreaturetype == MobCategory.MONSTER && worldserver.getBlockState(blockposition.below()).is(Blocks.NETHER_BRICKS)) {
            Structure structure = structuremanager.registryAccess().lookupOrThrow(Registries.STRUCTURE).getValue(BuiltinStructures.FORTRESS);
            return structure == null ? false : structuremanager.getStructureAt(blockposition, structure).isValid();
        }
        return false;
    }

    private static BlockPos getRandomPosWithin(Level world, LevelChunk chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        int i = chunkcoordintpair.getMinBlockX() + world.random.nextInt(16);
        int j = chunkcoordintpair.getMinBlockZ() + world.random.nextInt(16);
        int k = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = Mth.randomBetweenInclusive(world.random, world.getMinY(), k);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, FluidState fluid, EntityType<?> entitytypes) {
        return iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition) ? false : (iblockdata.isSignalSource() ? false : (!fluid.isEmpty() ? false : (iblockdata.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE) ? false : !entitytypes.isBlockDangerous(iblockdata))));
    }

    public static void spawnMobsForChunkGeneration(ServerLevelAccessor worldaccess, Holder<Biome> holder, ChunkPos chunkcoordintpair, RandomSource randomsource) {
        MobSpawnSettings biomesettingsmobs = holder.value().getMobSettings();
        WeightedList<MobSpawnSettings.SpawnerData> weightedlist = biomesettingsmobs.getMobs(MobCategory.CREATURE);
        if (!weightedlist.isEmpty()) {
            int i = chunkcoordintpair.getMinBlockX();
            int j = chunkcoordintpair.getMinBlockZ();
            while (randomsource.nextFloat() < biomesettingsmobs.getCreatureProbability()) {
                Optional<MobSpawnSettings.SpawnerData> optional = weightedlist.getRandom(randomsource);
                if (optional.isEmpty()) continue;
                MobSpawnSettings.SpawnerData biomesettingsmobs_c = optional.get();
                int k = biomesettingsmobs_c.minCount() + randomsource.nextInt(1 + biomesettingsmobs_c.maxCount() - biomesettingsmobs_c.minCount());
                SpawnGroupData groupdataentity = null;
                int l = i + randomsource.nextInt(16);
                int i1 = j + randomsource.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockposition = NaturalSpawner.getTopNonCollidingPos(worldaccess, biomesettingsmobs_c.type(), l, i1);
                        if (biomesettingsmobs_c.type().canSummon() && SpawnPlacements.isSpawnPositionOk(biomesettingsmobs_c.type(), worldaccess, blockposition)) {
                            Mob entityinsentient;
                            Object entity;
                            float f = biomesettingsmobs_c.type().getWidth();
                            double d0 = Mth.clamp((double)l, (double)i + (double)f, (double)i + 16.0 - (double)f);
                            double d1 = Mth.clamp((double)i1, (double)j + (double)f, (double)j + 16.0 - (double)f);
                            if (!worldaccess.noCollision(biomesettingsmobs_c.type().getSpawnAABB(d0, blockposition.getY(), d1)) || !SpawnPlacements.checkSpawnRules(biomesettingsmobs_c.type(), worldaccess, EntitySpawnReason.CHUNK_GENERATION, BlockPos.containing(d0, blockposition.getY(), d1), worldaccess.getRandom())) continue;
                            try {
                                entity = biomesettingsmobs_c.type().create(worldaccess.getLevel(), EntitySpawnReason.NATURAL);
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).snapTo(d0, blockposition.getY(), d1, randomsource.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof Mob && (entityinsentient = (Mob)entity).checkSpawnRules(worldaccess, EntitySpawnReason.CHUNK_GENERATION) && entityinsentient.checkSpawnObstruction(worldaccess)) {
                                groupdataentity = entityinsentient.finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(entityinsentient.blockPosition()), EntitySpawnReason.CHUNK_GENERATION, groupdataentity);
                                worldaccess.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l += randomsource.nextInt(5) - randomsource.nextInt(5);
                        i1 += randomsource.nextInt(5) - randomsource.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + randomsource.nextInt(5) - randomsource.nextInt(5);
                            i1 = k1 + randomsource.nextInt(5) - randomsource.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(LevelReader iworldreader, EntityType<?> entitytypes, int i, int j) {
        int k = iworldreader.getHeight(SpawnPlacements.getHeightmapType(entitytypes), i, j);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(i, k, j);
        if (iworldreader.dimensionType().hasCeiling()) {
            do {
                blockposition_mutableblockposition.move(Direction.DOWN);
            } while (!iworldreader.getBlockState(blockposition_mutableblockposition).isAir());
            do {
                blockposition_mutableblockposition.move(Direction.DOWN);
            } while (iworldreader.getBlockState(blockposition_mutableblockposition).isAir() && blockposition_mutableblockposition.getY() > iworldreader.getMinY());
        }
        return SpawnPlacements.getPlacementType(entitytypes).adjustSpawnPosition(iworldreader, blockposition_mutableblockposition.immutable());
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<LevelChunk> var3);
    }

    public static class SpawnState {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
        private final PotentialCalculator spawnPotential;
        private final Object2IntMap<MobCategory> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPos lastCheckedPos;
        @Nullable
        private EntityType<?> lastCheckedType;
        private double lastCharge;

        SpawnState(int i, Object2IntOpenHashMap<MobCategory> object2intopenhashmap, PotentialCalculator spawnercreatureprobabilities, LocalMobCapCalculator localmobcapcalculator) {
            this.spawnableChunkCount = i;
            this.mobCategoryCounts = object2intopenhashmap;
            this.spawnPotential = spawnercreatureprobabilities;
            this.localMobCapCalculator = localmobcapcalculator;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(object2intopenhashmap);
        }

        private boolean canSpawn(EntityType<?> entitytypes, BlockPos blockposition, ChunkAccess ichunkaccess) {
            double d0;
            this.lastCheckedPos = blockposition;
            this.lastCheckedType = entitytypes;
            MobSpawnSettings.MobSpawnCost biomesettingsmobs_b = NaturalSpawner.getRoughBiome(blockposition, ichunkaccess).getMobSettings().getMobSpawnCost(entitytypes);
            if (biomesettingsmobs_b == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = d0 = biomesettingsmobs_b.charge();
            double d1 = this.spawnPotential.getPotentialEnergyChange(blockposition, d0);
            return d1 <= biomesettingsmobs_b.energyBudget();
        }

        private void afterSpawn(Mob entityinsentient, ChunkAccess ichunkaccess) {
            MobSpawnSettings.MobSpawnCost biomesettingsmobs_b;
            EntityType<?> entitytypes = entityinsentient.getType();
            BlockPos blockposition = entityinsentient.blockPosition();
            double d0 = blockposition.equals(this.lastCheckedPos) && entitytypes == this.lastCheckedType ? this.lastCharge : ((biomesettingsmobs_b = NaturalSpawner.getRoughBiome(blockposition, ichunkaccess).getMobSettings().getMobSpawnCost(entitytypes)) != null ? biomesettingsmobs_b.charge() : 0.0);
            this.spawnPotential.addCharge(blockposition, d0);
            MobCategory enumcreaturetype = entitytypes.getCategory();
            this.mobCategoryCounts.addTo((Object)enumcreaturetype, 1);
            this.localMobCapCalculator.addMob(new ChunkPos(blockposition), enumcreaturetype);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<MobCategory> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategoryGlobal(MobCategory enumcreaturetype, int limit) {
            int i = limit * this.spawnableChunkCount / MAGIC_NUMBER;
            return this.mobCategoryCounts.getInt((Object)enumcreaturetype) < i;
        }

        boolean canSpawnForCategoryLocal(MobCategory enumcreaturetype, ChunkPos chunkcoordintpair) {
            return this.localMobCapCalculator.canSpawn(enumcreaturetype, chunkcoordintpair) || SharedConstants.DEBUG_IGNORE_LOCAL_MOB_CAP;
        }
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean test(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void run(Mob var1, ChunkAccess var2);
    }
}

