/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;

public class BiomeSpecialEffects {
    public static final Codec<BiomeSpecialEffects> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("fog_color").forGetter(var0 -> var0.fogColor), (App)Codec.INT.fieldOf("water_color").forGetter(var0 -> var0.waterColor), (App)Codec.INT.fieldOf("water_fog_color").forGetter(var0 -> var0.waterFogColor), (App)Codec.INT.fieldOf("sky_color").forGetter(var0 -> var0.skyColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(var0 -> var0.foliageColorOverride), (App)Codec.INT.optionalFieldOf("dry_foliage_color").forGetter(var0 -> var0.dryFoliageColorOverride), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(var0 -> var0.grassColorOverride), (App)GrassColorModifier.CODEC.optionalFieldOf("grass_color_modifier", (Object)GrassColorModifier.NONE).forGetter(var0 -> var0.grassColorModifier), (App)AmbientParticleSettings.CODEC.optionalFieldOf("particle").forGetter(var0 -> var0.ambientParticleSettings), (App)SoundEvent.CODEC.optionalFieldOf("ambient_sound").forGetter(var0 -> var0.ambientLoopSoundEvent), (App)AmbientMoodSettings.CODEC.optionalFieldOf("mood_sound").forGetter(var0 -> var0.ambientMoodSettings), (App)AmbientAdditionsSettings.CODEC.optionalFieldOf("additions_sound").forGetter(var0 -> var0.ambientAdditionsSettings), (App)WeightedList.codec(Music.CODEC).optionalFieldOf("music").forGetter(var0 -> var0.backgroundMusic), (App)Codec.FLOAT.fieldOf("music_volume").orElse((Object)Float.valueOf(1.0f)).forGetter(var0 -> Float.valueOf(var0.backgroundMusicVolume))).apply((Applicative)var02, BiomeSpecialEffects::new));
    private final int fogColor;
    private final int waterColor;
    private final int waterFogColor;
    private final int skyColor;
    private final Optional<Integer> foliageColorOverride;
    private final Optional<Integer> dryFoliageColorOverride;
    private final Optional<Integer> grassColorOverride;
    private final GrassColorModifier grassColorModifier;
    private final Optional<AmbientParticleSettings> ambientParticleSettings;
    private final Optional<Holder<SoundEvent>> ambientLoopSoundEvent;
    private final Optional<AmbientMoodSettings> ambientMoodSettings;
    private final Optional<AmbientAdditionsSettings> ambientAdditionsSettings;
    private final Optional<WeightedList<Music>> backgroundMusic;
    private final float backgroundMusicVolume;

    BiomeSpecialEffects(int var0, int var1, int var2, int var3, Optional<Integer> var4, Optional<Integer> var5, Optional<Integer> var6, GrassColorModifier var7, Optional<AmbientParticleSettings> var8, Optional<Holder<SoundEvent>> var9, Optional<AmbientMoodSettings> var10, Optional<AmbientAdditionsSettings> var11, Optional<WeightedList<Music>> var12, float var13) {
        this.fogColor = var0;
        this.waterColor = var1;
        this.waterFogColor = var2;
        this.skyColor = var3;
        this.foliageColorOverride = var4;
        this.dryFoliageColorOverride = var5;
        this.grassColorOverride = var6;
        this.grassColorModifier = var7;
        this.ambientParticleSettings = var8;
        this.ambientLoopSoundEvent = var9;
        this.ambientMoodSettings = var10;
        this.ambientAdditionsSettings = var11;
        this.backgroundMusic = var12;
        this.backgroundMusicVolume = var13;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public Optional<Integer> getFoliageColorOverride() {
        return this.foliageColorOverride;
    }

    public Optional<Integer> getDryFoliageColorOverride() {
        return this.dryFoliageColorOverride;
    }

    public Optional<Integer> getGrassColorOverride() {
        return this.grassColorOverride;
    }

    public GrassColorModifier getGrassColorModifier() {
        return this.grassColorModifier;
    }

    public Optional<AmbientParticleSettings> getAmbientParticleSettings() {
        return this.ambientParticleSettings;
    }

    public Optional<Holder<SoundEvent>> getAmbientLoopSoundEvent() {
        return this.ambientLoopSoundEvent;
    }

    public Optional<AmbientMoodSettings> getAmbientMoodSettings() {
        return this.ambientMoodSettings;
    }

    public Optional<AmbientAdditionsSettings> getAmbientAdditionsSettings() {
        return this.ambientAdditionsSettings;
    }

    public Optional<WeightedList<Music>> getBackgroundMusic() {
        return this.backgroundMusic;
    }

    public float getBackgroundMusicVolume() {
        return this.backgroundMusicVolume;
    }

    public static enum GrassColorModifier implements StringRepresentable
    {
        NONE("none"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return var4;
            }
        }
        ,
        DARK_FOREST("dark_forest"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                return (var4 & 0xFEFEFE) + 2634762 >> 1;
            }
        }
        ,
        SWAMP("swamp"){

            @Override
            public int modifyColor(double var0, double var2, int var4) {
                double var5 = Biome.BIOME_INFO_NOISE.getValue(var0 * 0.0225, var2 * 0.0225, false);
                if (var5 < -0.1) {
                    return 5011004;
                }
                return 6975545;
            }
        };

        private final String name;
        public static final Codec<GrassColorModifier> CODEC;

        public abstract int modifyColor(double var1, double var3, int var5);

        GrassColorModifier(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(GrassColorModifier::values);
        }
    }

    public static class Builder {
        private OptionalInt fogColor = OptionalInt.empty();
        private OptionalInt waterColor = OptionalInt.empty();
        private OptionalInt waterFogColor = OptionalInt.empty();
        private OptionalInt skyColor = OptionalInt.empty();
        private Optional<Integer> foliageColorOverride = Optional.empty();
        private Optional<Integer> dryFoliageColorOverride = Optional.empty();
        private Optional<Integer> grassColorOverride = Optional.empty();
        private GrassColorModifier grassColorModifier = GrassColorModifier.NONE;
        private Optional<AmbientParticleSettings> ambientParticle = Optional.empty();
        private Optional<Holder<SoundEvent>> ambientLoopSoundEvent = Optional.empty();
        private Optional<AmbientMoodSettings> ambientMoodSettings = Optional.empty();
        private Optional<AmbientAdditionsSettings> ambientAdditionsSettings = Optional.empty();
        private Optional<WeightedList<Music>> backgroundMusic = Optional.empty();
        private float backgroundMusicVolume = 1.0f;

        public Builder fogColor(int var0) {
            this.fogColor = OptionalInt.of(var0);
            return this;
        }

        public Builder waterColor(int var0) {
            this.waterColor = OptionalInt.of(var0);
            return this;
        }

        public Builder waterFogColor(int var0) {
            this.waterFogColor = OptionalInt.of(var0);
            return this;
        }

        public Builder skyColor(int var0) {
            this.skyColor = OptionalInt.of(var0);
            return this;
        }

        public Builder foliageColorOverride(int var0) {
            this.foliageColorOverride = Optional.of(var0);
            return this;
        }

        public Builder dryFoliageColorOverride(int var0) {
            this.dryFoliageColorOverride = Optional.of(var0);
            return this;
        }

        public Builder grassColorOverride(int var0) {
            this.grassColorOverride = Optional.of(var0);
            return this;
        }

        public Builder grassColorModifier(GrassColorModifier var0) {
            this.grassColorModifier = var0;
            return this;
        }

        public Builder ambientParticle(AmbientParticleSettings var0) {
            this.ambientParticle = Optional.of(var0);
            return this;
        }

        public Builder ambientLoopSound(Holder<SoundEvent> var0) {
            this.ambientLoopSoundEvent = Optional.of(var0);
            return this;
        }

        public Builder ambientMoodSound(AmbientMoodSettings var0) {
            this.ambientMoodSettings = Optional.of(var0);
            return this;
        }

        public Builder ambientAdditionsSound(AmbientAdditionsSettings var0) {
            this.ambientAdditionsSettings = Optional.of(var0);
            return this;
        }

        public Builder backgroundMusic(@Nullable Music var0) {
            if (var0 == null) {
                this.backgroundMusic = Optional.empty();
                return this;
            }
            this.backgroundMusic = Optional.of(WeightedList.of(var0));
            return this;
        }

        public Builder silenceAllBackgroundMusic() {
            return this.backgroundMusic(WeightedList.of()).backgroundMusicVolume(0.0f);
        }

        public Builder backgroundMusic(WeightedList<Music> var0) {
            this.backgroundMusic = Optional.of(var0);
            return this;
        }

        public Builder backgroundMusicVolume(float var0) {
            this.backgroundMusicVolume = var0;
            return this;
        }

        public BiomeSpecialEffects build() {
            return new BiomeSpecialEffects(this.fogColor.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.waterColor.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.waterFogColor.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.skyColor.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.foliageColorOverride, this.dryFoliageColorOverride, this.grassColorOverride, this.grassColorModifier, this.ambientParticle, this.ambientLoopSoundEvent, this.ambientMoodSettings, this.ambientAdditionsSettings, this.backgroundMusic, this.backgroundMusicVolume);
        }
    }
}

