/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractBannerBlock
extends BaseEntityBlock {
    private final DyeColor color;

    protected AbstractBannerBlock(DyeColor var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.color = var0;
    }

    protected abstract MapCodec<? extends AbstractBannerBlock> codec();

    @Override
    public boolean isPossibleToRespawnInThis(BlockState var0) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new BannerBlockEntity(var0, var1, this.color);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        BlockEntity blockEntity = var0.getBlockEntity(var1);
        if (blockEntity instanceof BannerBlockEntity) {
            BannerBlockEntity var4 = (BannerBlockEntity)blockEntity;
            return var4.getItem();
        }
        return super.getCloneItemStack(var0, var1, var2, var3);
    }

    public DyeColor getColor() {
        return this.color;
    }
}

