/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class FireflyBushBlock
extends VegetationBlock
implements BonemealableBlock {
    private static final double FIREFLY_CHANCE_PER_TICK = 0.7;
    private static final double FIREFLY_HORIZONTAL_RANGE = 10.0;
    private static final double FIREFLY_VERTICAL_RANGE = 5.0;
    private static final int FIREFLY_SPAWN_MAX_BRIGHTNESS_LEVEL = 13;
    private static final int FIREFLY_AMBIENT_SOUND_CHANCE_ONE_IN = 30;
    public static final MapCodec<FireflyBushBlock> CODEC = FireflyBushBlock.simpleCodec(FireflyBushBlock::new);

    public FireflyBushBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    protected MapCodec<? extends FireflyBushBlock> codec() {
        return CODEC;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (var3.nextInt(30) == 0 && var1.isMoonVisible() && var1.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var2) <= var2.getY()) {
            var1.playLocalSound(var2, SoundEvents.FIREFLY_BUSH_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        if (var1.getMaxLocalRawBrightness(var2) <= 13 && var3.nextDouble() <= 0.7) {
            double var4 = (double)var2.getX() + var3.nextDouble() * 10.0 - 5.0;
            double var6 = (double)var2.getY() + var3.nextDouble() * 5.0;
            double var8 = (double)var2.getZ() + var3.nextDouble() * 10.0 - 5.0;
            var1.addParticle(ParticleTypes.FIREFLY, var4, var6, var8, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return BonemealableBlock.hasSpreadableNeighbourPos(var0, var1, var2);
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var12, BlockPos var2, BlockState var3) {
        BonemealableBlock.findSpreadableNeighbourPos(var0, var2, var3).ifPresent(var1 -> var0.setBlockAndUpdate((BlockPos)var1, this.defaultBlockState()));
    }
}

