/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerBedBlock
extends VegetationBlock
implements BonemealableBlock,
SegmentableBlock {
    public static final MapCodec<FlowerBedBlock> CODEC = FlowerBedBlock.simpleCodec(FlowerBedBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = BlockStateProperties.FLOWER_AMOUNT;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<FlowerBedBlock> codec() {
        return CODEC;
    }

    protected FlowerBedBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(AMOUNT, 1));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, AMOUNT));
    }

    @Override
    public BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        if (this.canBeReplaced(var0, var1, AMOUNT)) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public double getShapeHeight() {
        return 3.0;
    }

    @Override
    public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return this.getStateForPlacement(var0, this, AMOUNT, FACING);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, AMOUNT);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        int var4 = var3.getValue(AMOUNT);
        if (var4 < 4) {
            var0.setBlock(var2, (BlockState)var3.setValue(AMOUNT, var4 + 1), 2);
        } else {
            FlowerBedBlock.popResource((Level)var0, var2, new ItemStack(this));
        }
    }
}

