/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public abstract class GrowingPlantHeadBlock
extends GrowingPlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected GrowingPlantHeadBlock(BlockBehaviour.Properties blockbase_info, Direction enumdirection, VoxelShape voxelshape, boolean flag, double d0) {
        super(blockbase_info, enumdirection, voxelshape, flag);
        this.growPerTickProbability = d0;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    protected abstract MapCodec<? extends GrowingPlantHeadBlock> codec();

    @Override
    public BlockState getStateForPlacement(RandomSource randomsource) {
        return (BlockState)this.defaultBlockState().setValue(AGE, randomsource.nextInt(25));
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 25;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        BlockPos blockposition1;
        if (iblockdata.getValue(AGE) < 25 && randomsource.nextDouble() < this.growPerTickProbability && this.canGrowInto(worldserver.getBlockState(blockposition1 = blockposition.relative(this.growthDirection)))) {
            CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, this.getGrowIntoState(iblockdata, worldserver.random));
        }
    }

    protected BlockState getGrowIntoState(BlockState iblockdata, RandomSource randomsource) {
        return (BlockState)iblockdata.cycle(AGE);
    }

    public BlockState getMaxAgeState(BlockState iblockdata) {
        return (BlockState)iblockdata.setValue(AGE, 25);
    }

    public boolean isMaxAge(BlockState iblockdata) {
        return iblockdata.getValue(AGE) == 25;
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState iblockdata, BlockState iblockdata1) {
        return iblockdata1;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection == this.growthDirection.getOpposite()) {
            if (!iblockdata.canSurvive(iworldreader, blockposition)) {
                scheduledtickaccess.scheduleTick(blockposition, this, 1);
            } else {
                BlockState iblockdata2 = iworldreader.getBlockState(blockposition.relative(this.growthDirection));
                if (iblockdata2.is(this) || iblockdata2.is(this.getBodyBlock())) {
                    return this.updateBodyAfterConvertedFromHead(iblockdata, this.getBodyBlock().defaultBlockState());
                }
            }
        }
        if (enumdirection != this.growthDirection || !iblockdata1.is(this) && !iblockdata1.is(this.getBodyBlock())) {
            if (this.scheduleFluidTicks) {
                scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
            }
            return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
        }
        return this.updateBodyAfterConvertedFromHead(iblockdata, this.getBodyBlock().defaultBlockState());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return this.canGrowInto(iworldreader.getBlockState(blockposition.relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        BlockPos blockposition1 = blockposition.relative(this.growthDirection);
        int i = Math.min(iblockdata.getValue(AGE) + 1, 25);
        int j = this.getBlocksToGrowWhenBonemealed(randomsource);
        for (int k = 0; k < j && this.canGrowInto(worldserver.getBlockState(blockposition1)); ++k) {
            worldserver.setBlockAndUpdate(blockposition1, (BlockState)iblockdata.setValue(AGE, i));
            blockposition1 = blockposition1.relative(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected GrowingPlantHeadBlock getHeadBlock() {
        return this;
    }
}

