/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.slf4j.Logger;

public class NetherPortalBlock
extends Block
implements Portal {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NetherPortalBlock> CODEC = NetherPortalBlock.simpleCodec(NetherPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = Shapes.rotateHorizontalAxis(Block.column(4.0, 16.0, 0.0, 16.0));

    public MapCodec<NetherPortalBlock> codec() {
        return CODEC;
    }

    public NetherPortalBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, Direction.Axis.X));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(iblockdata.getValue(AXIS));
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.dimensionType().natural() && worldserver.isSpawningMonsters() && randomsource.nextInt(2000) < worldserver.getDifficulty().getId() && worldserver.anyPlayerCloseEnoughForSpawning(blockposition)) {
            ZombifiedPiglin entity;
            while (worldserver.getBlockState(blockposition).is(this)) {
                blockposition = blockposition.below();
            }
            if (worldserver.getBlockState(blockposition).isValidSpawn(worldserver, blockposition, EntityType.ZOMBIFIED_PIGLIN) && (entity = EntityType.ZOMBIFIED_PIGLIN.spawn(worldserver, blockposition.above(), EntitySpawnReason.STRUCTURE, CreatureSpawnEvent.SpawnReason.NETHER_PORTAL)) != null) {
                entity.setPortalCooldown();
                net.minecraft.world.entity.Entity entity1 = entity.getVehicle();
                if (entity1 != null) {
                    entity1.setPortalCooldown();
                }
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        Direction.Axis enumdirection_enumaxis1 = iblockdata.getValue(AXIS);
        boolean flag = enumdirection_enumaxis1 != enumdirection_enumaxis && enumdirection_enumaxis.isHorizontal();
        return !flag && !iblockdata1.is(this) && !PortalShape.findAnyShape(iworldreader, blockposition, enumdirection_enumaxis1).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (entity.canUsePortal(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((World)world.getWorld(), (double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ()));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            entity.setAsInsidePortal(this, blockposition);
        }
    }

    @Override
    public int getPortalTransitionTime(ServerLevel worldserver, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            return Math.max(0, worldserver.getGameRules().getInt(entityhuman.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel worldserver, net.minecraft.world.entity.Entity entity, BlockPos blockposition) {
        ResourceKey<Level> resourcekey = worldserver.getTypeKey() == LevelStem.NETHER ? Level.OVERWORLD : Level.NETHER;
        ServerLevel worldserver1 = worldserver.getServer().getLevel(resourcekey);
        if (worldserver1 == null) {
            return new TeleportTransition(PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
        }
        boolean flag = worldserver1.getTypeKey() == LevelStem.NETHER;
        WorldBorder worldborder = worldserver1.getWorldBorder();
        double d0 = DimensionType.getTeleportationScale(worldserver.dimensionType(), worldserver1.dimensionType());
        BlockPos blockposition1 = worldborder.clampToBounds(entity.getX() * d0, entity.getY(), entity.getZ() * d0);
        CraftPortalEvent event = entity.callPortalEvent(entity, CraftLocation.toBukkit(blockposition1, (World)worldserver1.getWorld()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, flag ? 16 : 128, 16);
        if (event == null) {
            return null;
        }
        worldserver1 = ((CraftWorld)event.getTo().getWorld()).getHandle();
        worldborder = worldserver1.getWorldBorder();
        blockposition1 = worldborder.clampToBounds(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
        return this.getExitPortal(worldserver1, entity, blockposition, blockposition1, flag, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius());
    }

    @Nullable
    private TeleportTransition getExitPortal(ServerLevel worldserver, net.minecraft.world.entity.Entity entity, BlockPos blockposition, BlockPos blockposition1, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        TeleportTransition.PostTeleportTransition teleporttransition_a;
        BlockUtil.FoundRectangle blockutil_rectangle;
        Optional<BlockPos> optional = worldserver.getPortalForcer().findClosestPortalPosition(blockposition1, worldborder, searchRadius);
        if (optional.isPresent()) {
            BlockPos blockposition2 = optional.get();
            BlockState iblockdata = worldserver.getBlockState(blockposition2);
            blockutil_rectangle = BlockUtil.getLargestRectangleAround(blockposition2, iblockdata.getValue(BlockStateProperties.HORIZONTAL_AXIS), 21, Direction.Axis.Y, 21, blockposition3 -> worldserver.getBlockState((BlockPos)blockposition3) == iblockdata);
            teleporttransition_a = TeleportTransition.PLAY_PORTAL_SOUND.then(entity1 -> entity1.placePortalTicket(blockposition2));
        } else if (canCreatePortal) {
            Direction.Axis enumdirection_enumaxis = entity.level().getBlockState(blockposition).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> optional1 = worldserver.getPortalForcer().createPortal(blockposition1, enumdirection_enumaxis, entity, createRadius);
            if (optional1.isEmpty()) {
                return null;
            }
            blockutil_rectangle = optional1.get();
            teleporttransition_a = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        } else {
            return null;
        }
        return NetherPortalBlock.getDimensionTransitionFromExit(entity, blockposition, blockutil_rectangle, worldserver, teleporttransition_a);
    }

    private static TeleportTransition getDimensionTransitionFromExit(net.minecraft.world.entity.Entity entity, BlockPos blockposition, BlockUtil.FoundRectangle blockutil_rectangle, ServerLevel worldserver, TeleportTransition.PostTeleportTransition teleporttransition_a) {
        Vec3 vec3d;
        Direction.Axis enumdirection_enumaxis;
        BlockState iblockdata = entity.level().getBlockState(blockposition);
        if (iblockdata.hasProperty(BlockStateProperties.HORIZONTAL_AXIS)) {
            enumdirection_enumaxis = iblockdata.getValue(BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle blockutil_rectangle1 = BlockUtil.getLargestRectangleAround(blockposition, enumdirection_enumaxis, 21, Direction.Axis.Y, 21, blockposition1 -> entity.level().getBlockState((BlockPos)blockposition1) == iblockdata);
            vec3d = entity.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle1);
        } else {
            enumdirection_enumaxis = Direction.Axis.X;
            vec3d = new Vec3(0.5, 0.0, 0.0);
        }
        return NetherPortalBlock.createDimensionTransition(worldserver, blockutil_rectangle, enumdirection_enumaxis, vec3d, entity, teleporttransition_a);
    }

    private static TeleportTransition createDimensionTransition(ServerLevel worldserver, BlockUtil.FoundRectangle blockutil_rectangle, Direction.Axis enumdirection_enumaxis, Vec3 vec3d, net.minecraft.world.entity.Entity entity, TeleportTransition.PostTeleportTransition teleporttransition_a) {
        BlockPos blockposition = blockutil_rectangle.minCorner;
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        Direction.Axis enumdirection_enumaxis1 = iblockdata.getOptionalValue(BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double d0 = blockutil_rectangle.axis1Size;
        double d1 = blockutil_rectangle.axis2Size;
        EntityDimensions entitysize = entity.getDimensions(entity.getPose());
        int i = enumdirection_enumaxis == enumdirection_enumaxis1 ? 0 : 90;
        double d2 = (double)entitysize.width() / 2.0 + (d0 - (double)entitysize.width()) * vec3d.x();
        double d3 = (d1 - (double)entitysize.height()) * vec3d.y();
        double d4 = 0.5 + vec3d.z();
        boolean flag = enumdirection_enumaxis1 == Direction.Axis.X;
        Vec3 vec3d1 = new Vec3((double)blockposition.getX() + (flag ? d2 : d4), (double)blockposition.getY() + d3, (double)blockposition.getZ() + (flag ? d4 : d2));
        Vec3 vec3d2 = PortalShape.findCollisionFreePosition(vec3d1, worldserver, entity, entitysize);
        return new TeleportTransition(worldserver, vec3d2, Vec3.ZERO, i, 0.0f, Relative.union(Relative.DELTA, Relative.ROTATION), teleporttransition_a, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
    }

    @Override
    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (randomsource.nextInt(100) == 0) {
            world.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, randomsource.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)blockposition.getX() + randomsource.nextDouble();
            double d1 = (double)blockposition.getY() + randomsource.nextDouble();
            double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
            double d3 = ((double)randomsource.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)randomsource.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)randomsource.nextFloat() - 0.5) * 0.5;
            int j = randomsource.nextInt(2) * 2 - 1;
            if (!world.getBlockState(blockposition.west()).is(this) && !world.getBlockState(blockposition.east()).is(this)) {
                d0 = (double)blockposition.getX() + 0.5 + 0.25 * (double)j;
                d3 = randomsource.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)blockposition.getZ() + 0.5 + 0.25 * (double)j;
                d5 = randomsource.nextFloat() * 2.0f * (float)j;
            }
            world.addParticle(ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return ItemStack.EMPTY;
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (iblockdata.getValue(AXIS)) {
                    case X: {
                        return (BlockState)iblockdata.setValue(AXIS, Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)iblockdata.setValue(AXIS, Direction.Axis.X);
                    }
                }
                return iblockdata;
            }
        }
        return iblockdata;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AXIS);
    }
}

