/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    public final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    public EntityReference<LivingEntity> destroyTarget;
    private long nextAmbientSoundActivation;

    public ConduitBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.CONDUIT, blockposition, iblockdata);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.destroyTarget = EntityReference.read(valueinput, "Target");
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        EntityReference.store(this.destroyTarget, valueoutput, "Target");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    public static void clientTick(Level world, BlockPos blockposition, BlockState iblockdata, ConduitBlockEntity tileentityconduit) {
        ++tileentityconduit.tickCount;
        long i = world.getGameTime();
        List<BlockPos> list = tileentityconduit.effectBlocks;
        if (i % 40L == 0L) {
            tileentityconduit.isActive = ConduitBlockEntity.updateShape(world, blockposition, list);
            ConduitBlockEntity.updateHunting(tileentityconduit, list);
        }
        LivingEntity entityliving = EntityReference.getLivingEntity(tileentityconduit.destroyTarget, world);
        ConduitBlockEntity.animationTick(world, blockposition, list, entityliving, tileentityconduit.tickCount);
        if (tileentityconduit.isActive()) {
            tileentityconduit.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, ConduitBlockEntity tileentityconduit) {
        ++tileentityconduit.tickCount;
        long i = world.getGameTime();
        List<BlockPos> list = tileentityconduit.effectBlocks;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntity.updateShape(world, blockposition, list);
            if (flag != tileentityconduit.isActive) {
                SoundEvent soundeffect = flag ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                world.playSound((Entity)null, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            tileentityconduit.isActive = flag;
            ConduitBlockEntity.updateHunting(tileentityconduit, list);
            if (flag) {
                ConduitBlockEntity.applyEffects(world, blockposition, list);
                ConduitBlockEntity.updateAndAttackTarget((ServerLevel)world, blockposition, iblockdata, tileentityconduit, list.size() >= 42);
            }
        }
        if (tileentityconduit.isActive()) {
            if (i % 80L == 0L) {
                world.playSound((Entity)null, blockposition, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > tileentityconduit.nextAmbientSoundActivation) {
                tileentityconduit.nextAmbientSoundActivation = i + 60L + (long)world.getRandom().nextInt(40);
                world.playSound((Entity)null, blockposition, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(ConduitBlockEntity tileentityconduit, List<BlockPos> list) {
        tileentityconduit.setHunting(list.size() >= 42);
    }

    private static boolean updateShape(Level world, BlockPos blockposition, List<BlockPos> list) {
        list.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos blockposition1 = blockposition.offset(i, j, k);
                    if (world.isWaterAt(blockposition1)) continue;
                    return false;
                }
            }
        }
        for (int l = -2; l <= 2; ++l) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                for (int j1 = -2; j1 <= 2; ++j1) {
                    int k1 = Math.abs(l);
                    int l1 = Math.abs(i1);
                    int i2 = Math.abs(j1);
                    if (k1 <= 1 && l1 <= 1 && i2 <= 1 || (l != 0 || l1 != 2 && i2 != 2) && (i1 != 0 || k1 != 2 && i2 != 2) && (j1 != 0 || k1 != 2 && l1 != 2)) continue;
                    BlockPos blockposition2 = blockposition.offset(l, i1, j1);
                    BlockState iblockdata = world.getBlockState(blockposition2);
                    for (Block block : VALID_BLOCKS) {
                        if (!iblockdata.is(block)) continue;
                        list.add(blockposition2);
                    }
                }
            }
        }
        return list.size() >= 16;
    }

    private static void applyEffects(Level world, BlockPos blockposition, List<BlockPos> list) {
        ConduitBlockEntity.applyEffects(world, blockposition, ConduitBlockEntity.getRange(list));
    }

    public static int getRange(List<BlockPos> list) {
        int i = list.size();
        int j = i / 7 * 16;
        return j;
    }

    private static void applyEffects(Level world, BlockPos blockposition, int j) {
        int i1;
        int l;
        int k = blockposition.getX();
        AABB axisalignedbb = new AABB(k, l = blockposition.getY(), i1 = blockposition.getZ(), k + 1, l + 1, i1 + 1).inflate(j).expandTowards(0.0, world.getHeight(), 0.0);
        List<Player> list1 = world.getEntitiesOfClass(Player.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (Player entityhuman : list1) {
                if (!blockposition.closerThan(entityhuman.blockPosition(), j) || !entityhuman.isInWaterOrRain()) continue;
                entityhuman.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true), EntityPotionEffectEvent.Cause.CONDUIT);
            }
        }
    }

    private static void updateAndAttackTarget(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, ConduitBlockEntity tileentityconduit, boolean flag) {
        ConduitBlockEntity.updateAndAttackTarget(worldserver, blockposition, iblockdata, tileentityconduit, flag, true);
    }

    public static void updateAndAttackTarget(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, ConduitBlockEntity tileentityconduit, boolean flag, boolean damageTarget) {
        EntityReference<LivingEntity> entityreference = ConduitBlockEntity.updateDestroyTarget(tileentityconduit.destroyTarget, worldserver, blockposition, flag);
        LivingEntity entityliving = EntityReference.getLivingEntity(entityreference, worldserver);
        if (damageTarget && entityliving != null && entityliving.hurtServer(worldserver, worldserver.damageSources().magic().directBlock(worldserver, blockposition), 4.0f)) {
            worldserver.playSound((Entity)null, entityliving.getX(), entityliving.getY(), entityliving.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (!Objects.equals(entityreference, tileentityconduit.destroyTarget)) {
            tileentityconduit.destroyTarget = entityreference;
            worldserver.sendBlockUpdated(blockposition, iblockdata, iblockdata, 2);
        }
    }

    @Nullable
    private static EntityReference<LivingEntity> updateDestroyTarget(@Nullable EntityReference<LivingEntity> entityreference, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag) {
            return null;
        }
        if (entityreference == null) {
            return ConduitBlockEntity.selectNewTarget(worldserver, blockposition);
        }
        LivingEntity entityliving = EntityReference.getLivingEntity(entityreference, worldserver);
        return entityliving != null && entityliving.isAlive() && blockposition.closerThan(entityliving.blockPosition(), 8.0) ? entityreference : null;
    }

    @Nullable
    private static EntityReference<LivingEntity> selectNewTarget(ServerLevel worldserver, BlockPos blockposition) {
        List<LivingEntity> list = worldserver.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(blockposition), entityliving -> entityliving instanceof Enemy && entityliving.isInWaterOrRain());
        return list.isEmpty() ? null : EntityReference.of(Util.getRandom(list, worldserver.random));
    }

    public static AABB getDestroyRangeAABB(BlockPos blockposition) {
        return new AABB(blockposition).inflate(8.0);
    }

    private static void animationTick(Level world, BlockPos blockposition, List<BlockPos> list, @Nullable Entity entity, int i) {
        RandomSource randomsource = world.random;
        double d0 = Mth.sin((float)(i + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3d = new Vec3((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.5 + d0, (double)blockposition.getZ() + 0.5);
        for (BlockPos blockposition1 : list) {
            if (randomsource.nextInt(50) != 0) continue;
            BlockPos blockposition2 = blockposition1.subtract(blockposition);
            float f = -0.5f + randomsource.nextFloat() + (float)blockposition2.getX();
            float f1 = -2.0f + randomsource.nextFloat() + (float)blockposition2.getY();
            float f2 = -0.5f + randomsource.nextFloat() + (float)blockposition2.getZ();
            world.addParticle(ParticleTypes.NAUTILUS, vec3d.x, vec3d.y, vec3d.z, f, f1, f2);
        }
        if (entity != null) {
            Vec3 vec3d1 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
            float f3 = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            float f4 = -1.0f + randomsource.nextFloat() * entity.getBbHeight();
            float f5 = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            Vec3 vec3d2 = new Vec3(f3, f4, f5);
            world.addParticle(ParticleTypes.NAUTILUS, vec3d1.x, vec3d1.y, vec3d1.z, vec3d2.x, vec3d2.y, vec3d2.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean flag) {
        this.isHunting = flag;
    }

    public float getActiveRotation(float f) {
        return (this.activeRotation + f) * -0.0375f;
    }
}

