/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(PalettedContainerFactory containerFactory, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData, @Nullable Tag persistentDataContainer) {
    private static final Codec<List<SavedTick<Block>>> BLOCK_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.BLOCK.byNameCodec()).listOf();
    private static final Codec<List<SavedTick<Fluid>>> FLUID_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.FLUID.byNameCodec()).listOf();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor levelheightaccessor, PalettedContainerFactory palettedcontainerfactory, CompoundTag nbttagcompound) {
        if (nbttagcompound.getString("Status").isEmpty()) {
            return null;
        }
        ChunkPos chunkcoordintpair = new ChunkPos(nbttagcompound.getIntOr(X_POS_TAG, 0), nbttagcompound.getIntOr(Z_POS_TAG, 0));
        long i = nbttagcompound.getLongOr("LastUpdate", 0L);
        long j = nbttagcompound.getLongOr("InhabitedTime", 0L);
        ChunkStatus chunkstatus = nbttagcompound.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY);
        UpgradeData chunkconverter = nbttagcompound.getCompound(TAG_UPGRADE_DATA).map(nbttagcompound1 -> new UpgradeData((CompoundTag)nbttagcompound1, levelheightaccessor)).orElse(UpgradeData.EMPTY);
        boolean flag = nbttagcompound.getBooleanOr(IS_LIGHT_ON_TAG, false);
        BlendingData.Packed blendingdata_d = nbttagcompound.read("blending_data", BlendingData.Packed.CODEC).orElse(null);
        BelowZeroRetrogen belowzeroretrogen = nbttagcompound.read("below_zero_retrogen", BelowZeroRetrogen.CODEC).orElse(null);
        long[] along = nbttagcompound.getLongArray("carving_mask").orElse(null);
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        nbttagcompound.getCompound(HEIGHTMAPS_TAG).ifPresent(nbttagcompound1 -> {
            for (Heightmap.Types heightmap_type : chunkstatus.heightmapsAfter()) {
                nbttagcompound1.getLongArray(heightmap_type.getSerializationKey()).ifPresent(along1 -> map.put(heightmap_type, (long[])along1));
            }
        });
        List<SavedTick<Block>> list = SavedTick.filterTickListForChunk(nbttagcompound.read(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC).orElse(List.of()), chunkcoordintpair);
        List<SavedTick<Fluid>> list1 = SavedTick.filterTickListForChunk(nbttagcompound.read(FLUID_TICKS_TAG, FLUID_TICKS_CODEC).orElse(List.of()), chunkcoordintpair);
        ChunkAccess.PackedTicks ichunkaccess_b = new ChunkAccess.PackedTicks(list, list1);
        ListTag nbttaglist = nbttagcompound.getListOrEmpty("PostProcessing");
        ShortList[] ashortlist = new ShortList[nbttaglist.size()];
        for (int k = 0; k < nbttaglist.size(); ++k) {
            ListTag nbttaglist1 = nbttaglist.getListOrEmpty(k);
            ShortArrayList shortlist = new ShortArrayList(nbttaglist1.size());
            for (int l = 0; l < nbttaglist1.size(); ++l) {
                shortlist.add(nbttaglist1.getShortOr(l, (short)0));
            }
            ashortlist[k] = shortlist;
        }
        List<CompoundTag> list2 = nbttagcompound.getList("entities").stream().flatMap(ListTag::compoundStream).toList();
        List<CompoundTag> list3 = nbttagcompound.getList("block_entities").stream().flatMap(ListTag::compoundStream).toList();
        CompoundTag nbttagcompound12 = nbttagcompound.getCompoundOrEmpty("structures");
        ListTag nbttaglist2 = nbttagcompound.getListOrEmpty(SECTIONS_TAG);
        ArrayList<SectionData> list4 = new ArrayList<SectionData>(nbttaglist2.size());
        Codec<PalettedContainer<Holder<Biome>>> codec = palettedcontainerfactory.biomeContainerCodecRW();
        Codec<PalettedContainer<BlockState>> codec1 = palettedcontainerfactory.blockStatesContainerCodec();
        for (int i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            LevelChunkSection chunksection;
            Optional<CompoundTag> optional = nbttaglist2.getCompound(i1);
            if (optional.isEmpty()) continue;
            CompoundTag nbttagcompound2 = optional.get();
            byte j1 = nbttagcompound2.getByteOr("Y", (byte)0);
            if (j1 >= levelheightaccessor.getMinSectionY() && j1 <= levelheightaccessor.getMaxSectionY()) {
                Optional<PalettedContainerRO<Object>> optional1 = nbttagcompound2.getCompound("block_states").map(nbttagcompound3 -> (PalettedContainer)codec1.parse((DynamicOps)NbtOps.INSTANCE, nbttagcompound3).promotePartial(s -> SerializableChunkData.logErrors(chunkcoordintpair, j1, s)).getOrThrow(ChunkReadException::new));
                Objects.requireNonNull(palettedcontainerfactory);
                PalettedContainer datapaletteblock = (PalettedContainer)optional1.orElseGet(palettedcontainerfactory::createForBlockStates);
                optional1 = nbttagcompound2.getCompound("biomes").map(nbttagcompound3 -> (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, nbttagcompound3).promotePartial(s -> SerializableChunkData.logErrors(chunkcoordintpair, j1, s)).getOrThrow(ChunkReadException::new));
                Objects.requireNonNull(palettedcontainerfactory);
                PalettedContainer palettedcontainerro = (PalettedContainer)optional1.orElseGet(palettedcontainerfactory::createForBiomes);
                chunksection = new LevelChunkSection(datapaletteblock, palettedcontainerro);
            } else {
                chunksection = null;
            }
            DataLayer nibblearray = nbttagcompound2.getByteArray(BLOCK_LIGHT_TAG).map(DataLayer::new).orElse(null);
            DataLayer nibblearray1 = nbttagcompound2.getByteArray(SKY_LIGHT_TAG).map(DataLayer::new).orElse(null);
            list4.add(new SectionData(j1, chunksection, nibblearray, nibblearray1));
        }
        return new SerializableChunkData(palettedcontainerfactory, chunkcoordintpair, levelheightaccessor.getMinSectionY(), i, j, chunkstatus, blendingdata_d, belowzeroretrogen, chunkconverter, along, map, ichunkaccess_b, ashortlist, flag, list4, list2, list3, nbttagcompound12, nbttagcompound.get("ChunkBukkitValues"));
    }

    public ProtoChunk read(ServerLevel worldserver, PoiManager villageplace, RegionStorageInfo regionstorageinfo, ChunkPos chunkcoordintpair) {
        ChunkAccess ichunkaccess;
        if (!Objects.equals(chunkcoordintpair, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{chunkcoordintpair, chunkcoordintpair, this.chunkPos});
            worldserver.getServer().reportMisplacedChunk(this.chunkPos, chunkcoordintpair, regionstorageinfo);
        }
        int i = worldserver.getSectionsCount();
        LevelChunkSection[] achunksection = new LevelChunkSection[i];
        boolean flag = worldserver.dimensionType().hasSkyLight();
        ServerChunkCache ichunkprovider = worldserver.getChunkSource();
        LevelLightEngine levellightengine = ((ChunkSource)ichunkprovider).getLightEngine();
        PalettedContainerFactory palettedcontainerfactory = worldserver.palettedContainerFactory();
        boolean flag1 = false;
        for (SectionData serializablechunkdata_b : this.sectionData) {
            boolean flag3;
            SectionPos sectionposition = SectionPos.of(chunkcoordintpair, serializablechunkdata_b.y);
            if (serializablechunkdata_b.chunkSection != null) {
                achunksection[worldserver.getSectionIndexFromSectionY((int)serializablechunkdata_b.y)] = serializablechunkdata_b.chunkSection;
                villageplace.checkConsistencyWithBlocks(sectionposition, serializablechunkdata_b.chunkSection);
            }
            boolean flag2 = serializablechunkdata_b.blockLight != null;
            boolean bl = flag3 = flag && serializablechunkdata_b.skyLight != null;
            if (!flag2 && !flag3) continue;
            if (!flag1) {
                levellightengine.retainData(chunkcoordintpair, true);
                flag1 = true;
            }
            if (flag2) {
                levellightengine.queueSectionData(LightLayer.BLOCK, sectionposition, serializablechunkdata_b.blockLight);
            }
            if (!flag3) continue;
            levellightengine.queueSectionData(LightLayer.SKY, sectionposition, serializablechunkdata_b.skyLight);
        }
        ChunkType chunktype = this.chunkStatus.getChunkType();
        if (chunktype == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> levelchunkticks = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            LevelChunkTicks<Fluid> levelchunkticks1 = new LevelChunkTicks<Fluid>(this.packedTicks.fluids());
            ichunkaccess = new LevelChunk(worldserver.getLevel(), chunkcoordintpair, this.upgradeData, levelchunkticks, levelchunkticks1, this.inhabitedTime, achunksection, SerializableChunkData.postLoadChunk(worldserver, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunkTicks<Block> protochunkticklist = ProtoChunkTicks.load(this.packedTicks.blocks());
            ProtoChunkTicks<Fluid> protochunkticklist1 = ProtoChunkTicks.load(this.packedTicks.fluids());
            ProtoChunk protochunk = new ProtoChunk(chunkcoordintpair, this.upgradeData, achunksection, protochunkticklist, protochunkticklist1, worldserver, palettedcontainerfactory, BlendingData.unpack(this.blendingData));
            ichunkaccess = protochunk;
            protochunk.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                protochunk.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            protochunk.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protochunk.setLightEngine(levellightengine);
            }
        }
        if (this.persistentDataContainer instanceof CompoundTag) {
            ichunkaccess.persistentDataContainer.putAll((CompoundTag)this.persistentDataContainer);
        }
        ichunkaccess.setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap_type : ichunkaccess.getPersistedStatus().heightmapsAfter()) {
            long[] along = this.heightmaps.get(heightmap_type);
            if (along != null) {
                ichunkaccess.setHeightmap(heightmap_type, along);
                continue;
            }
            enumset.add(heightmap_type);
        }
        Heightmap.primeHeightmaps(ichunkaccess, enumset);
        ichunkaccess.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(worldserver), this.structureData, worldserver.getSeed()));
        ichunkaccess.setAllReferences(SerializableChunkData.unpackStructureReferences(worldserver.registryAccess(), chunkcoordintpair, this.structureData));
        for (int j = 0; j < this.postProcessingSections.length; ++j) {
            ichunkaccess.addPackedPostProcess(this.postProcessingSections[j], j);
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)ichunkaccess, false);
        }
        ProtoChunk protochunk1 = (ProtoChunk)ichunkaccess;
        for (CompoundTag nbttagcompound : this.entities) {
            protochunk1.addEntity(nbttagcompound);
        }
        for (CompoundTag nbttagcompound1 : this.blockEntities) {
            protochunk1.setBlockEntityNbt(nbttagcompound1);
        }
        if (this.carvingMask != null) {
            protochunk1.setCarvingMask(new CarvingMask(this.carvingMask, ichunkaccess.getMinY()));
        }
        return protochunk1;
    }

    private static void logErrors(ChunkPos chunkcoordintpair, int i, String s) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkcoordintpair.x, i, chunkcoordintpair.z, s});
    }

    public static SerializableChunkData copyOf(ServerLevel worldserver, ChunkAccess ichunkaccess) {
        if (!ichunkaccess.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(ichunkaccess));
        }
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        ArrayList<SectionData> list = new ArrayList<SectionData>();
        LevelChunkSection[] achunksection = ichunkaccess.getSections();
        ThreadedLevelLightEngine levellightengine = worldserver.getChunkSource().getLightEngine();
        for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
            DataLayer nibblearray3;
            int j = ichunkaccess.getSectionIndexFromSectionY(i);
            boolean flag = j >= 0 && j < achunksection.length;
            DataLayer nibblearray = levellightengine.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of(chunkcoordintpair, i));
            DataLayer nibblearray1 = levellightengine.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of(chunkcoordintpair, i));
            DataLayer dataLayer = nibblearray != null && !nibblearray.isEmpty() ? nibblearray.copy() : null;
            DataLayer dataLayer2 = nibblearray3 = nibblearray1 != null && !nibblearray1.isEmpty() ? nibblearray1.copy() : null;
            if (!flag && dataLayer == null && nibblearray3 == null) continue;
            LevelChunkSection chunksection = flag ? achunksection[j].copy() : null;
            list.add(new SectionData(i, chunksection, dataLayer, nibblearray3));
        }
        ArrayList<CompoundTag> list1 = new ArrayList<CompoundTag>(ichunkaccess.getBlockEntitiesPos().size());
        for (BlockPos blockposition : ichunkaccess.getBlockEntitiesPos()) {
            CompoundTag nbttagcompound = ichunkaccess.getBlockEntityNbtForSaving(blockposition, worldserver.registryAccess());
            if (nbttagcompound == null) continue;
            list1.add(nbttagcompound);
        }
        ArrayList<CompoundTag> list2 = new ArrayList<CompoundTag>();
        long[] along = null;
        if (ichunkaccess.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            list2.addAll(protochunk.getEntities());
            CarvingMask carvingmask = protochunk.getCarvingMask();
            if (carvingmask != null) {
                along = carvingmask.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry entry : ichunkaccess.getHeightmaps()) {
            if (!ichunkaccess.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] along1 = ((Heightmap)entry.getValue()).getRawData();
            map.put((Heightmap.Types)entry.getKey(), (long[])along1.clone());
        }
        ChunkAccess.PackedTicks ichunkaccess_b = ichunkaccess.getTicksForSerialization(worldserver.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(ichunkaccess.getPostProcessing()).map(shortlist -> shortlist != null ? new ShortArrayList(shortlist) : null).toArray(ShortList[]::new);
        CompoundTag nbttagcompound1 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(worldserver), chunkcoordintpair, ichunkaccess.getAllStarts(), ichunkaccess.getAllReferences());
        CompoundTag persistentDataContainer = null;
        if (!ichunkaccess.persistentDataContainer.isEmpty()) {
            persistentDataContainer = ichunkaccess.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData(worldserver.palettedContainerFactory(), chunkcoordintpair, ichunkaccess.getMinSectionY(), worldserver.getGameTime(), ichunkaccess.getInhabitedTime(), ichunkaccess.getPersistedStatus(), Optionull.map(ichunkaccess.getBlendingData(), BlendingData::pack), ichunkaccess.getBelowZeroRetrogen(), ichunkaccess.getUpgradeData().copy(), along, map, ichunkaccess_b, shortListArray, ichunkaccess.isLightCorrect(), list, list2, list1, nbttagcompound1, persistentDataContainer);
    }

    public CompoundTag write() {
        CompoundTag nbttagcompound = NbtUtils.addCurrentDataVersion(new CompoundTag());
        nbttagcompound.putInt(X_POS_TAG, this.chunkPos.x);
        nbttagcompound.putInt("yPos", this.minSectionY);
        nbttagcompound.putInt(Z_POS_TAG, this.chunkPos.z);
        nbttagcompound.putLong("LastUpdate", this.lastUpdateTime);
        nbttagcompound.putLong("InhabitedTime", this.inhabitedTime);
        nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        nbttagcompound.storeNullable("blending_data", BlendingData.Packed.CODEC, this.blendingData);
        nbttagcompound.storeNullable("below_zero_retrogen", BelowZeroRetrogen.CODEC, this.belowZeroRetrogen);
        if (!this.upgradeData.isEmpty()) {
            nbttagcompound.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag nbttaglist = new ListTag();
        Codec<PalettedContainer<BlockState>> codec = this.containerFactory.blockStatesContainerCodec();
        Codec<PalettedContainerRO<Holder<Biome>>> codec1 = this.containerFactory.biomeContainerCodec();
        for (SectionData serializablechunkdata_b : this.sectionData) {
            CompoundTag nbttagcompound1 = new CompoundTag();
            LevelChunkSection chunksection = serializablechunkdata_b.chunkSection;
            if (chunksection != null) {
                nbttagcompound1.store("block_states", codec, chunksection.getStates());
                nbttagcompound1.store("biomes", codec1, chunksection.getBiomes());
            }
            if (serializablechunkdata_b.blockLight != null) {
                nbttagcompound1.putByteArray(BLOCK_LIGHT_TAG, serializablechunkdata_b.blockLight.getData());
            }
            if (serializablechunkdata_b.skyLight != null) {
                nbttagcompound1.putByteArray(SKY_LIGHT_TAG, serializablechunkdata_b.skyLight.getData());
            }
            if (nbttagcompound1.isEmpty()) continue;
            nbttagcompound1.putByte("Y", (byte)serializablechunkdata_b.y);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.put(SECTIONS_TAG, nbttaglist);
        if (this.lightCorrect) {
            nbttagcompound.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag nbttaglist1 = new ListTag();
        nbttaglist1.addAll(this.blockEntities);
        nbttagcompound.put("block_entities", nbttaglist1);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag nbttaglist2 = new ListTag();
            nbttaglist2.addAll(this.entities);
            nbttagcompound.put("entities", nbttaglist2);
            if (this.carvingMask != null) {
                nbttagcompound.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(nbttagcompound, this.packedTicks);
        nbttagcompound.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag nbttagcompound2 = new CompoundTag();
        this.heightmaps.forEach((heightmap_type, along) -> nbttagcompound2.put(heightmap_type.getSerializationKey(), new LongArrayTag((long[])along)));
        nbttagcompound.put(HEIGHTMAPS_TAG, nbttagcompound2);
        nbttagcompound.put("structures", this.structureData);
        if (this.persistentDataContainer != null) {
            nbttagcompound.put("ChunkBukkitValues", this.persistentDataContainer);
        }
        return nbttagcompound;
    }

    private static void saveTicks(CompoundTag nbttagcompound, ChunkAccess.PackedTicks ichunkaccess_b) {
        nbttagcompound.store(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC, ichunkaccess_b.blocks());
        nbttagcompound.store(FLUID_TICKS_TAG, FLUID_TICKS_CODEC, ichunkaccess_b.fluids());
    }

    public static ChunkStatus getChunkStatusFromTag(@Nullable CompoundTag nbttagcompound) {
        return nbttagcompound != null ? nbttagcompound.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY) : ChunkStatus.EMPTY;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel worldserver, List<CompoundTag> list, List<CompoundTag> list1) {
        return list.isEmpty() && list1.isEmpty() ? null : chunk -> {
            if (!list.isEmpty()) {
                try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(chunk.problemPath(), LOGGER);){
                    worldserver.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)worldserver.registryAccess(), list), worldserver, EntitySpawnReason.LOAD));
                }
            }
            for (CompoundTag nbttagcompound : list1) {
                boolean flag = nbttagcompound.getBooleanOr("keepPacked", false);
                if (flag) {
                    chunk.setBlockEntityNbt(nbttagcompound);
                    continue;
                }
                BlockPos blockposition = BlockEntity.getPosFromTag(chunk.getPos(), nbttagcompound);
                BlockEntity tileentity = BlockEntity.loadStatic(blockposition, chunk.getBlockState(blockposition), nbttagcompound, worldserver.registryAccess());
                if (tileentity == null) continue;
                chunk.setBlockEntity(tileentity);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext structurepieceserializationcontext, ChunkPos chunkcoordintpair, Map<Structure, StructureStart> map, Map<Structure, LongSet> map1) {
        CompoundTag nbttagcompound = new CompoundTag();
        CompoundTag nbttagcompound1 = new CompoundTag();
        HolderLookup.RegistryLookup iregistry = structurepieceserializationcontext.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> map_entry : map.entrySet()) {
            ResourceLocation minecraftkey = iregistry.getKey(map_entry.getKey());
            nbttagcompound1.put(minecraftkey.toString(), map_entry.getValue().createTag(structurepieceserializationcontext, chunkcoordintpair));
        }
        nbttagcompound.put("starts", nbttagcompound1);
        CompoundTag nbttagcompound2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> map_entry1 : map1.entrySet()) {
            if (map_entry1.getValue().isEmpty()) continue;
            ResourceLocation minecraftkey1 = iregistry.getKey(map_entry1.getKey());
            nbttagcompound2.putLongArray(minecraftkey1.toString(), map_entry1.getValue().toLongArray());
        }
        nbttagcompound.put("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound, long i) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup iregistry = structurepieceserializationcontext.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty("starts");
        for (String s : nbttagcompound1.keySet()) {
            ResourceLocation minecraftkey = ResourceLocation.tryParse(s);
            Structure structure = (Structure)iregistry.getValue(minecraftkey);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.loadStaticStart(structurepieceserializationcontext, nbttagcompound1.getCompoundOrEmpty(s), i);
            if (structurestart == null) continue;
            Tag persistentBase = nbttagcompound1.getCompoundOrEmpty(s).get("StructureBukkitValues");
            if (persistentBase instanceof CompoundTag) {
                structurestart.persistentDataContainer.putAll((CompoundTag)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess iregistrycustom, ChunkPos chunkcoordintpair, CompoundTag nbttagcompound) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup iregistry = iregistrycustom.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag nbttagcompound1 = nbttagcompound.getCompoundOrEmpty("References");
        nbttagcompound1.forEach((arg_0, arg_1) -> SerializableChunkData.lambda$unpackStructureReferences$12((Registry)iregistry, chunkcoordintpair, map, arg_0, arg_1));
        return map;
    }

    private static ListTag packOffsets(ShortList[] ashortlist) {
        ListTag nbttaglist = new ListTag();
        for (ShortList shortlist : ashortlist) {
            ListTag nbttaglist1 = new ListTag();
            if (shortlist != null) {
                for (int i = 0; i < shortlist.size(); ++i) {
                    nbttaglist1.add(ShortTag.valueOf(shortlist.getShort(i)));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    private static /* synthetic */ void lambda$unpackStructureReferences$12(Registry iregistry, ChunkPos chunkcoordintpair, Map map, String s, Tag nbtbase) {
        ResourceLocation minecraftkey = ResourceLocation.tryParse(s);
        Structure structure = (Structure)iregistry.getValue(minecraftkey);
        if (structure == null) {
            LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)chunkcoordintpair);
        } else {
            Optional<long[]> optional = nbtbase.asLongArray();
            if (!optional.isEmpty()) {
                map.put(structure, new LongOpenHashSet(Arrays.stream(optional.get()).filter(i -> {
                    ChunkPos chunkcoordintpair1 = new ChunkPos(i);
                    if (chunkcoordintpair1.getChessboardDistance(chunkcoordintpair) > 8) {
                        LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, chunkcoordintpair});
                        return false;
                    }
                    return true;
                }).toArray()));
            }
        }
    }

    public record SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String s) {
            super(s);
        }
    }
}

