/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.slf4j.Logger;

public class Heightmap {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Predicate<BlockState> NOT_AIR = var0 -> !var0.isAir();
    static final Predicate<BlockState> MATERIAL_MOTION_BLOCKING = BlockBehaviour.BlockStateBase::blocksMotion;
    private final BitStorage data;
    private final Predicate<BlockState> isOpaque;
    private final ChunkAccess chunk;

    public Heightmap(ChunkAccess var0, Types var1) {
        this.isOpaque = var1.isOpaque();
        this.chunk = var0;
        int var2 = Mth.ceillog2(var0.getHeight() + 1);
        this.data = new SimpleBitStorage(var2, 256);
    }

    public static void primeHeightmaps(ChunkAccess var0, Set<Types> var1) {
        if (var1.isEmpty()) {
            return;
        }
        int var2 = var1.size();
        ObjectArrayList var3 = new ObjectArrayList(var2);
        ObjectListIterator var4 = var3.iterator();
        int var5 = var0.getHighestSectionPosition() + 16;
        BlockPos.MutableBlockPos var6 = new BlockPos.MutableBlockPos();
        for (int var7 = 0; var7 < 16; ++var7) {
            block1: for (int var8 = 0; var8 < 16; ++var8) {
                for (Types types : var1) {
                    var3.add((Object)var0.getOrCreateHeightmapUnprimed(types));
                }
                for (int var9 = var5 - 1; var9 >= var0.getMinY(); --var9) {
                    var6.set(var7, var9, var8);
                    BlockState blockState = var0.getBlockState(var6);
                    if (blockState.is(Blocks.AIR)) continue;
                    while (var4.hasNext()) {
                        Heightmap var11 = (Heightmap)var4.next();
                        if (!var11.isOpaque.test(blockState)) continue;
                        var11.setHeight(var7, var8, var9 + 1);
                        var4.remove();
                    }
                    if (var3.isEmpty()) continue block1;
                    var4.back(var2);
                }
            }
        }
    }

    public boolean update(int var0, int var1, int var2, BlockState var3) {
        int var4 = this.getFirstAvailable(var0, var2);
        if (var1 <= var4 - 2) {
            return false;
        }
        if (this.isOpaque.test(var3)) {
            if (var1 >= var4) {
                this.setHeight(var0, var2, var1 + 1);
                return true;
            }
        } else if (var4 - 1 == var1) {
            BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
            for (int var6 = var1 - 1; var6 >= this.chunk.getMinY(); --var6) {
                var5.set(var0, var6, var2);
                if (!this.isOpaque.test(this.chunk.getBlockState(var5))) continue;
                this.setHeight(var0, var2, var6 + 1);
                return true;
            }
            this.setHeight(var0, var2, this.chunk.getMinY());
            return true;
        }
        return false;
    }

    public int getFirstAvailable(int var0, int var1) {
        return this.getFirstAvailable(Heightmap.getIndex(var0, var1));
    }

    public int getHighestTaken(int var0, int var1) {
        return this.getFirstAvailable(Heightmap.getIndex(var0, var1)) - 1;
    }

    private int getFirstAvailable(int var0) {
        return this.data.get(var0) + this.chunk.getMinY();
    }

    private void setHeight(int var0, int var1, int var2) {
        this.data.set(Heightmap.getIndex(var0, var1), var2 - this.chunk.getMinY());
    }

    public void setRawData(ChunkAccess var0, Types var1, long[] var2) {
        long[] var3 = this.data.getRaw();
        if (var3.length == var2.length) {
            System.arraycopy(var2, 0, var3, 0, var2.length);
            return;
        }
        LOGGER.warn("Ignoring heightmap data for chunk {}, size does not match; expected: {}, got: {}", new Object[]{var0.getPos(), var3.length, var2.length});
        Heightmap.primeHeightmaps(var0, EnumSet.of(var1));
    }

    public long[] getRawData() {
        return this.data.getRaw();
    }

    private static int getIndex(int var0, int var1) {
        return var0 + var1 * 16;
    }

    public static enum Types implements StringRepresentable
    {
        WORLD_SURFACE_WG(0, "WORLD_SURFACE_WG", Usage.WORLDGEN, NOT_AIR),
        WORLD_SURFACE(1, "WORLD_SURFACE", Usage.CLIENT, NOT_AIR),
        OCEAN_FLOOR_WG(2, "OCEAN_FLOOR_WG", Usage.WORLDGEN, MATERIAL_MOTION_BLOCKING),
        OCEAN_FLOOR(3, "OCEAN_FLOOR", Usage.LIVE_WORLD, MATERIAL_MOTION_BLOCKING),
        MOTION_BLOCKING(4, "MOTION_BLOCKING", Usage.CLIENT, var0 -> var0.blocksMotion() || !var0.getFluidState().isEmpty()),
        MOTION_BLOCKING_NO_LEAVES(5, "MOTION_BLOCKING_NO_LEAVES", Usage.CLIENT, var0 -> (var0.blocksMotion() || !var0.getFluidState().isEmpty()) && !(var0.getBlock() instanceof LeavesBlock));

        public static final Codec<Types> CODEC;
        private static final IntFunction<Types> BY_ID;
        public static final StreamCodec<ByteBuf, Types> STREAM_CODEC;
        private final int id;
        private final String serializationKey;
        private final Usage usage;
        private final Predicate<BlockState> isOpaque;

        private Types(int var2, String var3, Usage var4, Predicate var5) {
            this.id = var2;
            this.serializationKey = var3;
            this.usage = var4;
            this.isOpaque = var5;
        }

        public String getSerializationKey() {
            return this.serializationKey;
        }

        public boolean sendToClient() {
            return this.usage == Usage.CLIENT;
        }

        public boolean keepAfterWorldgen() {
            return this.usage != Usage.WORLDGEN;
        }

        public Predicate<BlockState> isOpaque() {
            return this.isOpaque;
        }

        @Override
        public String getSerializedName() {
            return this.serializationKey;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Types::values);
            BY_ID = ByIdMap.continuous(var0 -> var0.id, Types.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
        }
    }

    public static enum Usage {
        WORLDGEN,
        LIVE_WORLD,
        CLIENT;

    }
}

