/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.NotPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.UnobstructedPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public interface BlockPredicate
extends BiPredicate<WorldGenLevel, BlockPos> {
    public static final Codec<BlockPredicate> CODEC = BuiltInRegistries.BLOCK_PREDICATE_TYPE.byNameCodec().dispatch(BlockPredicate::type, BlockPredicateType::codec);
    public static final BlockPredicate ONLY_IN_AIR_PREDICATE = BlockPredicate.matchesBlocks(Blocks.AIR);
    public static final BlockPredicate ONLY_IN_AIR_OR_WATER_PREDICATE = BlockPredicate.matchesBlocks(Blocks.AIR, Blocks.WATER);

    public BlockPredicateType<?> type();

    public static BlockPredicate allOf(List<BlockPredicate> var0) {
        return new AllOfPredicate(var0);
    }

    public static BlockPredicate allOf(BlockPredicate ... var0) {
        return BlockPredicate.allOf(List.of(var0));
    }

    public static BlockPredicate allOf(BlockPredicate var0, BlockPredicate var1) {
        return BlockPredicate.allOf(List.of(var0, var1));
    }

    public static BlockPredicate anyOf(List<BlockPredicate> var0) {
        return new AnyOfPredicate(var0);
    }

    public static BlockPredicate anyOf(BlockPredicate ... var0) {
        return BlockPredicate.anyOf(List.of(var0));
    }

    public static BlockPredicate anyOf(BlockPredicate var0, BlockPredicate var1) {
        return BlockPredicate.anyOf(List.of(var0, var1));
    }

    public static BlockPredicate matchesBlocks(Vec3i var0, List<Block> var1) {
        return new MatchingBlocksPredicate(var0, HolderSet.direct(Block::builtInRegistryHolder, var1));
    }

    public static BlockPredicate matchesBlocks(List<Block> var0) {
        return BlockPredicate.matchesBlocks(Vec3i.ZERO, var0);
    }

    public static BlockPredicate matchesBlocks(Vec3i var0, Block ... var1) {
        return BlockPredicate.matchesBlocks(var0, List.of(var1));
    }

    public static BlockPredicate matchesBlocks(Block ... var0) {
        return BlockPredicate.matchesBlocks(Vec3i.ZERO, var0);
    }

    public static BlockPredicate matchesTag(Vec3i var0, TagKey<Block> var1) {
        return new MatchingBlockTagPredicate(var0, var1);
    }

    public static BlockPredicate matchesTag(TagKey<Block> var0) {
        return BlockPredicate.matchesTag(Vec3i.ZERO, var0);
    }

    public static BlockPredicate matchesFluids(Vec3i var0, List<Fluid> var1) {
        return new MatchingFluidsPredicate(var0, HolderSet.direct(Fluid::builtInRegistryHolder, var1));
    }

    public static BlockPredicate matchesFluids(Vec3i var0, Fluid ... var1) {
        return BlockPredicate.matchesFluids(var0, List.of(var1));
    }

    public static BlockPredicate matchesFluids(Fluid ... var0) {
        return BlockPredicate.matchesFluids(Vec3i.ZERO, var0);
    }

    public static BlockPredicate not(BlockPredicate var0) {
        return new NotPredicate(var0);
    }

    public static BlockPredicate replaceable(Vec3i var0) {
        return new ReplaceablePredicate(var0);
    }

    public static BlockPredicate replaceable() {
        return BlockPredicate.replaceable(Vec3i.ZERO);
    }

    public static BlockPredicate wouldSurvive(BlockState var0, Vec3i var1) {
        return new WouldSurvivePredicate(var1, var0);
    }

    public static BlockPredicate hasSturdyFace(Vec3i var0, Direction var1) {
        return new HasSturdyFacePredicate(var0, var1);
    }

    public static BlockPredicate hasSturdyFace(Direction var0) {
        return BlockPredicate.hasSturdyFace(Vec3i.ZERO, var0);
    }

    public static BlockPredicate solid(Vec3i var0) {
        return new SolidPredicate(var0);
    }

    public static BlockPredicate solid() {
        return BlockPredicate.solid(Vec3i.ZERO);
    }

    public static BlockPredicate noFluid() {
        return BlockPredicate.noFluid(Vec3i.ZERO);
    }

    public static BlockPredicate noFluid(Vec3i var0) {
        return BlockPredicate.matchesFluids(var0, Fluids.EMPTY);
    }

    public static BlockPredicate insideWorld(Vec3i var0) {
        return new InsideWorldBoundsPredicate(var0);
    }

    public static BlockPredicate alwaysTrue() {
        return TrueBlockPredicate.INSTANCE;
    }

    public static BlockPredicate unobstructed(Vec3i var0) {
        return new UnobstructedPredicate(var0);
    }

    public static BlockPredicate unobstructed() {
        return BlockPredicate.unobstructed(Vec3i.ZERO);
    }
}

